/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Arrays;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestampNew;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestsWithParameters.class, TestsWithoutParameters.class})
public class TestGenericUDFToUtcTimestampNew {

    public static class TestsWithoutParameters {
        @Test
        public void testTimestamp() throws HiveException {
            TimeZone defaultTz = TimeZone.getDefault();
            TimeZone systemTimeZone = TimeZone.getTimeZone("Australia/Sydney");
            TimeZone.setDefault(systemTimeZone);
            ObjectInspector[] objectInspectors = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector};
            GenericUDF.DeferredJavaObject[] values = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject((Object)new TimestampWritableV2(Timestamp.valueOf((String)"1970-01-01 00:00:00"))), new GenericUDF.DeferredJavaObject((Object)new Text("Australia/Sydney"))};
            GenericUDFToUtcTimestampNew udf = new GenericUDFToUtcTimestampNew();
            udf.initialize(objectInspectors);
            Object result = udf.evaluate((GenericUDF.DeferredObject[])values);
            Assert.assertEquals((Object)"1969-12-31 14:00:00", (Object)result.toString());
            TimeZone.setDefault(defaultTz);
        }

        @Test
        public void testDate() throws HiveException {
            TimeZone defaultTz = TimeZone.getDefault();
            TimeZone systemTimeZone = TimeZone.getTimeZone("Australia/Sydney");
            TimeZone.setDefault(systemTimeZone);
            ObjectInspector[] objectInspectors = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector};
            GenericUDF.DeferredJavaObject[] values = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(0)), new GenericUDF.DeferredJavaObject((Object)new Text("Australia/Sydney"))};
            GenericUDFToUtcTimestampNew udf = new GenericUDFToUtcTimestampNew();
            udf.initialize(objectInspectors);
            Object result = udf.evaluate((GenericUDF.DeferredObject[])values);
            Assert.assertEquals((Object)"1969-12-31 14:00:00", (Object)result.toString());
            TimeZone.setDefault(defaultTz);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TestsWithParameters {
        private GenericUDF.DeferredJavaObject[] values;
        private ObjectInspector[] objectInspectors;
        private String expectedString;

        public TestsWithParameters(ObjectInspector timeObjectInspectors, Object timeValue, String zoneValues, String expectedString) {
            this.objectInspectors = new ObjectInspector[]{timeObjectInspectors, PrimitiveObjectInspectorFactory.writableStringObjectInspector};
            this.values = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(timeValue), new GenericUDF.DeferredJavaObject((Object)new Text(zoneValues))};
            this.expectedString = expectedString;
        }

        @Parameterized.Parameters(name="{0}")
        public static Collection<Object[]> data() {
            return Arrays.asList({PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, new BooleanWritable(true), "Australia/Sydney", "1969-12-31 14:00:00.001"}, {PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, new BooleanWritable(false), "Australia/Sydney", "1969-12-31 14:00:00"}, {PrimitiveObjectInspectorFactory.writableByteObjectInspector, new ByteWritable(0), "Australia/Sydney", "1969-12-31 14:00:00"}, {PrimitiveObjectInspectorFactory.writableByteObjectInspector, new ByteWritable(127), "Australia/Sydney", "1969-12-31 14:00:00.127"}, {PrimitiveObjectInspectorFactory.writableByteObjectInspector, new ByteWritable(-128), "Australia/Sydney", "1969-12-31 13:59:59.872"}, {PrimitiveObjectInspectorFactory.writableShortObjectInspector, new ShortWritable(0), "Australia/Sydney", "1969-12-31 14:00:00"}, {PrimitiveObjectInspectorFactory.writableShortObjectInspector, new ShortWritable(Short.MAX_VALUE), "Australia/Sydney", "1969-12-31 14:00:32.767"}, {PrimitiveObjectInspectorFactory.writableShortObjectInspector, new ShortWritable(Short.MIN_VALUE), "Australia/Sydney", "1969-12-31 13:59:27.232"}, {PrimitiveObjectInspectorFactory.writableIntObjectInspector, new IntWritable(0), "Australia/Sydney", "1969-12-31 14:00:00"}, {PrimitiveObjectInspectorFactory.writableIntObjectInspector, new IntWritable(Integer.MAX_VALUE), "Australia/Sydney", "1970-01-25 10:31:23.647"}, {PrimitiveObjectInspectorFactory.writableIntObjectInspector, new IntWritable(Integer.MIN_VALUE), "Australia/Sydney", "1969-12-06 17:28:36.352"}, {PrimitiveObjectInspectorFactory.writableLongObjectInspector, new LongWritable(0L), "Australia/Sydney", "1969-12-31 14:00:00"}, {PrimitiveObjectInspectorFactory.writableLongObjectInspector, new LongWritable(1538877600000L), "Australia/Sydney", "2018-10-06 16:00:00"}, {PrimitiveObjectInspectorFactory.writableFloatObjectInspector, new FloatWritable(0.12345679f), "Australia/Sydney", "1969-12-31 14:00:00.123456791"}, {PrimitiveObjectInspectorFactory.writableFloatObjectInspector, new FloatWritable(1.5388776E9f), "Australia/Sydney", "2018-10-06 15:59:28"}, {PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, new DoubleWritable(0.123456789), "Australia/Sydney", "1969-12-31 14:00:00.123456789"}, {PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, new DoubleWritable(1.5388776001234567E9), "Australia/Sydney", "2018-10-06 16:00:00.1234567"}, {PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector, new HiveDecimalWritable("0.123456789"), "Australia/Sydney", "1969-12-31 14:00:00.123456789"}, {PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector, new HiveDecimalWritable("1538877600.123456789"), "Australia/Sydney", "2018-10-06 16:00:00.123456789"}, {PrimitiveObjectInspectorFactory.writableStringObjectInspector, new Text("2018-10-07 02:00:00"), "Australia/Sydney", "2018-10-06 16:00:00"}, {PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, new HiveVarcharWritable(new HiveVarchar("1970-01-01 00:00:00.123456789", 55)), "Australia/Sydney", "1969-12-31 14:00:00.123456789"}, {PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, new HiveVarcharWritable(new HiveVarchar("2018-10-07 02:00:00", 55)), "Australia/Sydney", "2018-10-06 16:00:00"});
        }

        @Test
        public void testToUtcTimestampInDSTZone() throws HiveException {
            TimeZone defaultTz = TimeZone.getDefault();
            TimeZone systemTimeZone = TimeZone.getTimeZone("Australia/Sydney");
            TimeZone.setDefault(systemTimeZone);
            GenericUDFToUtcTimestampNew udf = new GenericUDFToUtcTimestampNew();
            udf.initialize(this.objectInspectors);
            Object result = udf.evaluate((GenericUDF.DeferredObject[])this.values);
            Assert.assertEquals((Object)this.expectedString, (Object)result.toString());
            TimeZone.setDefault(defaultTz);
        }

        @Test
        public void testToUtcTimestampNotInDSTZone() throws HiveException {
            TimeZone defaultTz = TimeZone.getDefault();
            TimeZone systemTimeZone = TimeZone.getTimeZone("UTC");
            TimeZone.setDefault(systemTimeZone);
            GenericUDFToUtcTimestampNew udf = new GenericUDFToUtcTimestampNew();
            udf.initialize(this.objectInspectors);
            Object result = udf.evaluate((GenericUDF.DeferredObject[])this.values);
            Assert.assertEquals((Object)this.expectedString, (Object)result.toString());
            TimeZone.setDefault(defaultTz);
        }
    }
}

