/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeCaptureOutputDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;

public class FakeCaptureOutputOperator
extends Operator<FakeCaptureOutputDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OutputInspector outputInspector;
    private transient List<Object> rows;

    public void setOutputInspector(OutputInspector outputInspector) {
        this.outputInspector = outputInspector;
    }

    public OutputInspector getOutputInspector() {
        return this.outputInspector;
    }

    public static FakeCaptureOutputOperator addCaptureOutputChild(CompilationOpContext ctx, Operator<? extends OperatorDesc> op) {
        FakeCaptureOutputOperator out = new FakeCaptureOutputOperator(ctx);
        ArrayList<Operator<? extends OperatorDesc>> listParents = new ArrayList<Operator<? extends OperatorDesc>>(1);
        listParents.add(op);
        out.setParentOperators(listParents);
        ArrayList<FakeCaptureOutputOperator> listChildren = new ArrayList<FakeCaptureOutputOperator>(1);
        listChildren.add(out);
        op.setChildOperators(listChildren);
        return out;
    }

    public List<Object> getCapturedRows() {
        return this.rows;
    }

    protected FakeCaptureOutputOperator() {
    }

    public FakeCaptureOutputOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public void initializeOp(Configuration conf) throws HiveException {
        super.initializeOp(conf);
        this.rows = new ArrayList<Object>();
    }

    public void process(Object row, int tag) throws HiveException {
        this.rows.add(row);
        if (null != this.outputInspector) {
            this.outputInspector.inspectRow(row, tag);
        }
    }

    public OperatorType getType() {
        return null;
    }

    public String getName() {
        return FakeCaptureOutputOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "FAKE_CAPTURE";
    }

    public static interface OutputInspector {
        public void inspectRow(Object var1, int var2) throws HiveException;
    }
}

