/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Test;

public class TestVectorDateDiff {
    @Test
    public void testDateDate() throws Exception {
        Random random = new Random(7743L);
        this.doDateDiffTests(random, "date", "date");
    }

    @Test
    public void testDateTimestamp() throws Exception {
        Random random = new Random(7743L);
        this.doDateDiffTests(random, "date", "timestamp");
    }

    @Test
    public void testDateString() throws Exception {
        Random random = new Random(7743L);
        this.doDateDiffTests(random, "date", "string");
    }

    @Test
    public void testTimestampDate() throws Exception {
        Random random = new Random(82L);
        this.doDateDiffTests(random, "timestamp", "date");
    }

    @Test
    public void testTimestampTimestamp() throws Exception {
        Random random = new Random(82L);
        this.doDateDiffTests(random, "timestamp", "timestamp");
    }

    @Test
    public void testTimestampString() throws Exception {
        Random random = new Random(82L);
        this.doDateDiffTests(random, "timestamp", "string");
    }

    @Test
    public void testStringFamily() throws Exception {
        Random random = new Random(12882L);
        this.doDateDiffTests(random, "char(20)", "date");
        this.doDateDiffTests(random, "char(20)", "timestamp");
        this.doDateDiffTests(random, "char(20)", "string");
        this.doDateDiffTests(random, "varchar(20)", "date");
        this.doDateDiffTests(random, "varchar(20)", "timestamp");
        this.doDateDiffTests(random, "varchar(20)", "string");
    }

    private void doDateDiffTests(Random random, String dateTimeStringTypeName, String integerTypeName) throws Exception {
        for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
            this.doDateDiffTestsWithDiffColumnScalar(random, dateTimeStringTypeName, integerTypeName, columnScalarMode);
        }
    }

    private void doDateDiffTestsWithDiffColumnScalar(Random random, String dateTimeStringTypeName1, String dateTimeStringTypeName2, ColumnScalarMode columnScalarMode) throws Exception {
        int i;
        ExprNodeConstantDesc col2Expr;
        ExprNodeConstantDesc col1Expr;
        TypeInfo dateTimeStringTypeInfo1 = TypeInfoUtils.getTypeInfoFromTypeString((String)dateTimeStringTypeName1);
        PrimitiveObjectInspector.PrimitiveCategory dateTimeStringPrimitiveCategory1 = ((PrimitiveTypeInfo)dateTimeStringTypeInfo1).getPrimitiveCategory();
        boolean isStringFamily1 = dateTimeStringPrimitiveCategory1 == PrimitiveObjectInspector.PrimitiveCategory.STRING || dateTimeStringPrimitiveCategory1 == PrimitiveObjectInspector.PrimitiveCategory.CHAR || dateTimeStringPrimitiveCategory1 == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR;
        TypeInfo dateTimeStringTypeInfo2 = TypeInfoUtils.getTypeInfoFromTypeString((String)dateTimeStringTypeName2);
        PrimitiveObjectInspector.PrimitiveCategory dateTimeStringPrimitiveCategory2 = ((PrimitiveTypeInfo)dateTimeStringTypeInfo2).getPrimitiveCategory();
        boolean isStringFamily2 = dateTimeStringPrimitiveCategory2 == PrimitiveObjectInspector.PrimitiveCategory.STRING || dateTimeStringPrimitiveCategory2 == PrimitiveObjectInspector.PrimitiveCategory.CHAR || dateTimeStringPrimitiveCategory2 == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR;
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 0;
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.COLUMN_SCALAR) {
            if (!isStringFamily1) {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(dateTimeStringTypeInfo1));
            } else {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createStringFamilyOtherTypeValue(dateTimeStringTypeInfo1, (TypeInfo)TypeInfoFactory.dateTypeInfo));
            }
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col1Expr = new ExprNodeColumnDesc(dateTimeStringTypeInfo1, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar1Object = !isStringFamily1 ? VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)dateTimeStringTypeInfo1) : VectorRandomRowSource.randomStringFamilyOtherTypeValue(random, dateTimeStringTypeInfo1, (TypeInfo)TypeInfoFactory.dateTypeInfo, false);
            col1Expr = new ExprNodeConstantDesc(dateTimeStringTypeInfo1, scalar1Object);
        }
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            if (!isStringFamily2) {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(dateTimeStringTypeInfo2));
            } else {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createStringFamilyOtherTypeValue(dateTimeStringTypeInfo2, (TypeInfo)TypeInfoFactory.dateTypeInfo));
            }
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col2Expr = new ExprNodeColumnDesc(dateTimeStringTypeInfo2, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar2Object = !isStringFamily2 ? VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)dateTimeStringTypeInfo2) : VectorRandomRowSource.randomStringFamilyOtherTypeValue(random, dateTimeStringTypeInfo2, (TypeInfo)TypeInfoFactory.dateTypeInfo, false);
            col2Expr = new ExprNodeConstantDesc(dateTimeStringTypeInfo2, scalar2Object);
        }
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        children.add((ExprNodeDesc)col2Expr);
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        String[] outputScratchTypeNames = new String[]{"date"};
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, outputScratchTypeNames, null);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[DateDiffTestMode.count][];
        block4: for (i = 0; i < DateDiffTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            GenericUDFDateDiff udf = new GenericUDFDateDiff();
            ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)udf, children);
            DateDiffTestMode dateDiffTestMode = DateDiffTestMode.values()[i];
            switch (dateDiffTestMode) {
                case ROW_MODE: {
                    this.doRowDateAddSubTest(dateTimeStringTypeInfo1, dateTimeStringTypeInfo2, columns, children, exprDesc, randomRows, columnScalarMode, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects);
                    continue block4;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    this.doVectorDateAddSubTest(dateTimeStringTypeInfo1, dateTimeStringTypeInfo2, columns, rowSource.typeInfos(), children, exprDesc, dateDiffTestMode, columnScalarMode, batchSource, batchContext, resultObjects);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + dateDiffTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < DateDiffTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " " + DateDiffTestMode.values()[v] + " " + columnScalarMode + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + " row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " " + DateDiffTestMode.values()[v] + " " + columnScalarMode + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i])));
            }
        }
    }

    private void doRowDateAddSubTest(TypeInfo dateTimeStringTypeInfo1, TypeInfo dateTimeStringTypeInfo2, List<String> columns, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ColumnScalarMode columnScalarMode, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        System.out.println("*DEBUG* dateTimeStringTypeInfo " + dateTimeStringTypeInfo1.toString() + " dateTimeStringTypeInfo2 " + dateTimeStringTypeInfo2 + " dateDiffTestMode ROW_MODE columnScalarMode " + columnScalarMode + " exprDesc " + exprDesc.toString());
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            resultObjects[rowIndex++] = scrqtchRow[0];
        }
    }

    private void doVectorDateAddSubTest(TypeInfo dateTimeStringTypeInfo1, TypeInfo dateTimeStringTypeInfo2, List<String> columns, TypeInfo[] typeInfos, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, DateDiffTestMode dateDiffTestMode, ColumnScalarMode columnScalarMode, VectorRandomBatchSource batchSource, VectorizedRowBatchCtx batchContext, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (dateDiffTestMode == DateDiffTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        Object[] dataTypePhysicalVariations = new DataTypePhysicalVariation[2];
        Arrays.fill(dataTypePhysicalVariations, DataTypePhysicalVariation.NONE);
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        vectorExpression.transientInit();
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{TypeInfoFactory.intTypeInfo}, new int[]{columns.size()});
        Object[] scrqtchRow = new Object[1];
        System.out.println("*DEBUG* dateTimeStringTypeInfo1 " + dateTimeStringTypeInfo1.toString() + " dateTimeStringTypeInfo2 " + dateTimeStringTypeInfo2.toString() + " dateDiffTestMode " + dateDiffTestMode + " columnScalarMode " + columnScalarMode + " vectorExpression " + vectorExpression.toString());
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum ColumnScalarMode {
        COLUMN_COLUMN,
        COLUMN_SCALAR,
        SCALAR_COLUMN;

        static final int count;

        static {
            count = ColumnScalarMode.values().length;
        }
    }

    public static enum DateDiffTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = DateDiffTestMode.values().length;
        }
    }
}

