/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.maprdb.json.serde.MapRDBSerDe;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.hive.maprdb.json.util.MapRDbJsonTableUtil;
import org.apache.hadoop.hive.ql.exec.MapRDbJsonFetchByIdOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MapRDbJsonFetchByIdWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.ojai.Document;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@Ignore
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MapRDbJsonTableUtil.class})
public class TestMapRDbJsonFetchByIdOperator {
    private MapRDbJsonFetchByIdWork fetchWork = (MapRDbJsonFetchByIdWork)Mockito.mock(MapRDbJsonFetchByIdWork.class);
    private JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
    private Operator source = (Operator)Mockito.mock(Operator.class);
    private Document document = (Document)Mockito.mock(Document.class);
    private TableDesc tableDesc = (TableDesc)Mockito.mock(TableDesc.class);
    private MapRDBSerDe mapRDBSerDe = (MapRDBSerDe)Mockito.mock(MapRDBSerDe.class);
    private StructObjectInspector objectInspector = (StructObjectInspector)Mockito.mock(StructObjectInspector.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.fetchWork.getTblDesc()).thenReturn((Object)this.tableDesc);
        Mockito.when((Object)this.fetchWork.getMapRDbTableName()).thenReturn((Object)"test_table");
        Mockito.when((Object)this.fetchWork.getSearchValue()).thenReturn((Object)"test_value");
        Mockito.when((Object)this.tableDesc.getDeserializer((Configuration)ArgumentMatchers.any(Configuration.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)this.mapRDBSerDe);
        Mockito.when((Object)this.mapRDBSerDe.getObjectInspector()).thenReturn((Object)this.objectInspector);
        PowerMockito.mockStatic(MapRDbJsonTableUtil.class, (Class[])new Class[0]);
        PowerMockito.when((Object)MapRDbJsonTableUtil.findById((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)this.document);
    }

    @Test
    public void testGetNextRowWorkIsEmpty() throws Exception {
        Mockito.when((Object)this.fetchWork.isEmpty()).thenReturn((Object)true);
        MapRDbJsonFetchByIdOperator mapRDbJsonFetchByIdOperator = new MapRDbJsonFetchByIdOperator((FetchWork)this.fetchWork, this.jobConf, this.source);
        Assert.assertNull((Object)mapRDbJsonFetchByIdOperator.getNextRow());
    }

    @Test
    public void testGetNextRowDocumentEqualsNull() throws Exception {
        PowerMockito.when((Object)MapRDbJsonTableUtil.findById((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(null);
        MapRDbJsonFetchByIdOperator mapRDbJsonFetchByIdOperator = new MapRDbJsonFetchByIdOperator((FetchWork)this.fetchWork, this.jobConf, this.source);
        Assert.assertNull((Object)mapRDbJsonFetchByIdOperator.getNextRow());
    }

    @Test
    public void testGetNextRow() throws Exception {
        MapRDbJsonFetchByIdOperator mapRDbJsonFetchByIdOperator = new MapRDbJsonFetchByIdOperator((FetchWork)this.fetchWork, this.jobConf, this.source);
        mapRDbJsonFetchByIdOperator.getNextRow();
        ((MapRDBSerDe)Mockito.verify((Object)this.mapRDBSerDe, (VerificationMode)Mockito.times((int)2))).getObjectInspector();
        ((MapRDBSerDe)Mockito.verify((Object)this.mapRDBSerDe, (VerificationMode)Mockito.times((int)1))).deserialize((Writable)ArgumentMatchers.any(DocumentWritable.class));
    }
}

