/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TxnCommandsBaseForTests.class);
    static final int BUCKET_COUNT = 2;
    @Rule
    public TestName testName = new TestName();
    HiveConf hiveConf;
    Driver d;

    @Before
    public void setUp() throws Exception {
        this.setUpInternal();
    }

    void initHiveConf() {
        this.hiveConf = new HiveConf(this.getClass());
        this.hiveConf.set("fs.defaultFS", "file:///");
    }

    void setUpInternal() throws Exception {
        this.initHiveConf();
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.hiveConf.set("mapred.local.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "local");
        this.hiveConf.set("mapred.system.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "system");
        this.hiveConf.set("mapreduce.jobtracker.staging.root.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "staging");
        this.hiveConf.set("mapred.temp.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "temp");
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, this.getWarehouseDir());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEINPUTFORMAT, HiveInputFormat.class.getName());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVESTATSCOLAUTOGATHER, false);
        this.hiveConf.setBoolean("mapred.input.dir.recursive", true);
        TxnDbUtil.setConfValues((Configuration)this.hiveConf);
        TxnDbUtil.prepDb((Configuration)this.hiveConf);
        File f = new File(this.getWarehouseDir());
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(this.getWarehouseDir()).mkdirs()) {
            throw new RuntimeException("Could not create " + this.getWarehouseDir());
        }
        SessionState ss = SessionState.start((HiveConf)this.hiveConf);
        ss.applyAuthorizationPolicy();
        this.d = new Driver(new QueryState.Builder().withHiveConf(this.hiveConf).nonIsolated().build(), null);
        this.d.setMaxRows(10000);
        this.dropTables();
        this.runStatementOnDriver("create table " + Table.ACIDTBL + "(a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + Table.ACIDTBLPART + "(a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + Table.NONACIDORCTBL + "(a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + Table.NONACIDORCTBL2 + "(a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create temporary  table " + Table.ACIDTBL2 + "(a int, b int, c int) clustered by (c) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + Table.NONACIDNONBUCKET + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='false')");
    }

    protected void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + t);
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                this.dropTables();
                this.d.close();
                this.d.destroy();
                this.d = null;
            }
        }
        finally {
            TxnDbUtil.cleanDb((Configuration)this.hiveConf);
            FileUtils.deleteDirectory((File)new File(this.getTestDataDir()));
        }
    }

    String getWarehouseDir() {
        return this.getTestDataDir() + "/warehouse";
    }

    abstract String getTestDataDir();

    List<String> stringifyValues(int[][] rowsIn) {
        return TestTxnCommands2.stringifyValues(rowsIn);
    }

    String makeValuesClause(int[][] rows) {
        return TestTxnCommands2.makeValuesClause(rows);
    }

    void runWorker(HiveConf hiveConf) throws MetaException {
        TestTxnCommands2.runWorker(hiveConf);
    }

    void runCleaner(HiveConf hiveConf) throws MetaException {
        TestTxnCommands2.runCleaner(hiveConf);
    }

    List<String> runStatementOnDriver(String stmt) throws Exception {
        LOG.info("Running the query: " + stmt);
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            throw new RuntimeException(stmt + " failed: " + cpr);
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    CommandProcessorResponse runStatementOnDriverNegative(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            return cpr;
        }
        throw new RuntimeException("Didn't get expected failure!");
    }

    void assertVectorized(boolean vectorized, String query) throws Exception {
        List<String> rs = this.runStatementOnDriver("EXPLAIN VECTORIZATION DETAIL " + query);
        for (String line : rs) {
            if (line == null || !line.contains("Execution mode: vectorized")) continue;
            Assert.assertTrue((String)"Was vectorized when it wasn't expected", (boolean)vectorized);
            return;
        }
        Assert.assertTrue((String)"Din't find expected 'vectorized' in plan", (!vectorized ? 1 : 0) != 0);
    }

    void assertExpectedFileSet(Set<String> expectedFiles, String rootPath) throws Exception {
        int suffixLength = 0;
        for (String s : expectedFiles) {
            if (suffixLength > 0) assert (suffixLength == s.length()) : "all entries must be the same length. current: " + s;
            suffixLength = s.length();
        }
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        HashSet<String> actualFiles = new HashSet<String>();
        RemoteIterator remoteIterator = fs.listFiles(new Path(rootPath), true);
        while (remoteIterator.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)remoteIterator.next();
            if (lfs.isDirectory() || !org.apache.hadoop.hive.common.FileUtils.HIDDEN_FILES_PATH_FILTER.accept(lfs.getPath())) continue;
            String p = lfs.getPath().toString();
            actualFiles.add(p.substring(p.length() - suffixLength, p.length()));
        }
        Assert.assertEquals((String)"Unexpected file list", expectedFiles, actualFiles);
    }

    void checkExpected(List<String> rs, String[][] expected, String msg, Logger LOG, boolean checkFileName) {
        LOG.warn(this.testName.getMethodName() + ": read data(" + msg + "): ");
        this.logResult(LOG, rs);
        Assert.assertEquals((String)(this.testName.getMethodName() + ": " + msg + "; " + rs), (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line (data) " + i + " data: " + rs.get(i)), (boolean)rs.get(i).startsWith(expected[i][0]));
            if (!checkFileName) continue;
            Assert.assertTrue((String)("Actual line(file) " + i + " file: " + rs.get(i)), (boolean)rs.get(i).endsWith(expected[i][1]));
        }
    }

    void logResult(Logger LOG, List<String> rs) {
        StringBuilder sb = new StringBuilder();
        for (String s : rs) {
            sb.append(s).append('\n');
        }
        LOG.info(sb.toString());
    }

    void checkResult(String[][] expectedResult, String query, boolean isVectorized, String msg, Logger LOG) throws Exception {
        List<String> rs = this.runStatementOnDriver(query);
        this.checkExpected(rs, expectedResult, msg + (isVectorized ? " vect" : ""), LOG, !isVectorized);
        this.assertVectorized(isVectorized, query);
    }

    static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBLPART("acidTblPart"),
        ACIDTBL2("acidTbl2"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDORCTBL2("nonAcidOrcTbl2"),
        NONACIDNONBUCKET("nonAcidNonBucket");

        final String name;

        public String toString() {
            return this.name;
        }

        private Table(String name) {
            this.name = name;
        }
    }
}

