/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

public class CreateDatabaseHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        MetaData metaData;
        try {
            FileSystem fs = FileSystem.get((URI)new Path(context.location).toUri(), (Configuration)context.hiveConf);
            metaData = EximUtil.readMetaData(fs, new Path(context.location, "_metadata"));
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
        Database db = metaData.getDatabase();
        String destinationDBName = context.dbName == null ? db.getName() : context.dbName;
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc(destinationDBName, db.getDescription(), null, true);
        createDatabaseDesc.setDatabaseProperties(db.getParameters());
        Task<DDLWork> createDBTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), createDatabaseDesc), context.hiveConf);
        if (!db.getParameters().isEmpty()) {
            AlterDatabaseDesc alterDbDesc = new AlterDatabaseDesc(destinationDBName, db.getParameters(), context.eventOnlyReplicationSpec());
            Task<DDLWork> alterDbProperties = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc), context.hiveConf);
            createDBTask.addDependentTask(alterDbProperties);
        }
        if (StringUtils.isNotEmpty((String)db.getOwnerName())) {
            AlterDatabaseDesc alterDbOwner = new AlterDatabaseDesc(destinationDBName, new PrincipalDesc(db.getOwnerName(), db.getOwnerType()), context.eventOnlyReplicationSpec());
            Task<DDLWork> alterDbTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbOwner), context.hiveConf);
            createDBTask.addDependentTask(alterDbTask);
        }
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), destinationDBName, null, null);
        return Collections.singletonList(createDBTask);
    }
}

