/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedWorkOptimizer
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger(SharedWorkOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        HashMap<String, TableScanOperator> topOps = pctx.getTopOps();
        if (topOps.size() < 2) {
            return pctx;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before SharedWorkOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
        }
        SharedWorkOptimizerCache optimizerCache = new SharedWorkOptimizerCache();
        SharedWorkOptimizer.gatherDPPTableScanOps(pctx, optimizerCache);
        Multimap<String, TableScanOperator> tableNameToOps = SharedWorkOptimizer.splitTableScanOpsByTable(pctx);
        List<Map.Entry<String, Long>> sortedTables = SharedWorkOptimizer.rankTablesByAccumulatedSize(pctx);
        LOG.debug("Sorted tables by size: {}", sortedTables);
        ArrayListMultimap existingOps = ArrayListMultimap.create();
        HashSet removedOps = new HashSet();
        for (Map.Entry<String, Long> tablePair : sortedTables) {
            String tableName = tablePair.getKey();
            for (TableScanOperator tableScanOperator : tableNameToOps.get((Object)tableName)) {
                if (removedOps.contains(tableScanOperator)) {
                    LOG.debug("Skip {} as it has already been removed", (Object)tableScanOperator);
                    continue;
                }
                Collection prevTsOps = existingOps.get((Object)tableName);
                for (TableScanOperator retainableTsOp : prevTsOps) {
                    if (removedOps.contains(retainableTsOp)) {
                        LOG.debug("Skip {} as it has already been removed", (Object)retainableTsOp);
                        continue;
                    }
                    boolean mergeable = SharedWorkOptimizer.areMergeable(pctx, optimizerCache, retainableTsOp, tableScanOperator);
                    if (!mergeable) {
                        LOG.debug("{} and {} cannot be merged", (Object)retainableTsOp, (Object)tableScanOperator);
                        continue;
                    }
                    SharedResult sr = SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, retainableTsOp, tableScanOperator);
                    if (!SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, sr)) {
                        LOG.debug("{} and {} do not meet preconditions", (Object)retainableTsOp, (Object)tableScanOperator);
                        continue;
                    }
                    if (sr.retainableOps.size() > 1) {
                        Operator<?> lastRetainableOp = sr.retainableOps.get(sr.retainableOps.size() - 1);
                        Operator<?> lastDiscardableOp = sr.discardableOps.get(sr.discardableOps.size() - 1);
                        if (lastDiscardableOp.getNumChild() != 0) {
                            ArrayList allChildren = Lists.newArrayList(lastDiscardableOp.getChildOperators());
                            for (Operator op : allChildren) {
                                lastDiscardableOp.getChildOperators().remove(op);
                                op.replaceParent(lastDiscardableOp, lastRetainableOp);
                                lastRetainableOp.getChildOperators().add(op);
                            }
                        }
                        LOG.debug("Merging subtree starting at {} into subtree starting at {}", (Object)tableScanOperator, (Object)retainableTsOp);
                    } else {
                        ExprNodeGenericFuncDesc tsExprNode;
                        if (((TableScanDesc)retainableTsOp.getConf()).getFilterExpr() != null) {
                            SharedWorkOptimizer.pushFilterToTopOfTableScan(optimizerCache, retainableTsOp);
                        }
                        if (((TableScanDesc)tableScanOperator.getConf()).getFilterExpr() != null) {
                            SharedWorkOptimizer.pushFilterToTopOfTableScan(optimizerCache, tableScanOperator);
                        }
                        Object exprNode = null;
                        if (((TableScanDesc)retainableTsOp.getConf()).getFilterExpr() != null && ((TableScanDesc)tableScanOperator.getConf()).getFilterExpr() != null && !((ExprNodeGenericFuncDesc)(exprNode = ((TableScanDesc)retainableTsOp.getConf()).getFilterExpr())).isSame(tsExprNode = ((TableScanDesc)tableScanOperator.getConf()).getFilterExpr())) {
                            if (((ExprNodeGenericFuncDesc)exprNode).getGenericUDF() instanceof GenericUDFOPOr) {
                                ExprNodeDesc childExprNode;
                                ArrayList newChildren = new ArrayList(((ExprNodeGenericFuncDesc)exprNode).getChildren().size() + 1);
                                Iterator<Object> iterator = ((ExprNodeGenericFuncDesc)exprNode).getChildren().iterator();
                                while (iterator.hasNext() && !(childExprNode = (ExprNodeDesc)iterator.next()).isSame(tsExprNode)) {
                                    newChildren.add(childExprNode);
                                }
                                if (((ExprNodeGenericFuncDesc)exprNode).getChildren().size() == newChildren.size()) {
                                    newChildren.add(tsExprNode);
                                    exprNode = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPOr(), newChildren);
                                }
                            } else {
                                exprNode = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPOr(), Arrays.asList(exprNode, tsExprNode));
                            }
                        }
                        ((TableScanDesc)retainableTsOp.getConf()).setFilterExpr((ExprNodeGenericFuncDesc)exprNode);
                        ArrayList allChildren = Lists.newArrayList(tableScanOperator.getChildOperators());
                        for (Object op2 : allChildren) {
                            tableScanOperator.getChildOperators().remove(op2);
                            ((Operator)op2).replaceParent(tableScanOperator, retainableTsOp);
                            retainableTsOp.getChildOperators().add((Operator<OperatorDesc>)op2);
                        }
                        LOG.debug("Merging {} into {}", (Object)tableScanOperator, (Object)retainableTsOp);
                    }
                    for (Operator<?> op : sr.discardableInputOps) {
                        DynamicPruningEventDesc dped;
                        OperatorUtils.removeOperator(op);
                        optimizerCache.removeOp(op);
                        removedOps.add(op);
                        if (op instanceof ReduceSinkOperator) {
                            SemiJoinBranchInfo sjbi = pctx.getRsToSemiJoinBranchInfo().get(op);
                            if (sjbi != null && !sr.discardableOps.contains(sjbi.getTsOp()) && !sr.discardableInputOps.contains(sjbi.getTsOp())) {
                                GenTezUtils.removeSemiJoinOperator(pctx, (ReduceSinkOperator)op, sjbi.getTsOp());
                                optimizerCache.tableScanToDPPSource.remove((Object)sjbi.getTsOp(), op);
                            }
                        } else if (op instanceof AppMasterEventOperator && !sr.discardableOps.contains((dped = (DynamicPruningEventDesc)op.getConf()).getTableScan()) && !sr.discardableInputOps.contains(dped.getTableScan())) {
                            GenTezUtils.removeSemiJoinOperator(pctx, (AppMasterEventOperator)op, dped.getTableScan());
                            optimizerCache.tableScanToDPPSource.remove((Object)dped.getTableScan(), op);
                        }
                        LOG.debug("Input operator removed: {}", op);
                    }
                    optimizerCache.removeOpAndCombineWork(tableScanOperator, retainableTsOp);
                    removedOps.add(tableScanOperator);
                    for (Operator<?> op : sr.discardableOps) {
                        OperatorUtils.removeOperator(op);
                        optimizerCache.removeOp(op);
                        removedOps.add(op);
                        if (sr.discardableOps.size() == 1) {
                            Object op2;
                            Collection c = optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op));
                            op2 = c.iterator();
                            while (op2.hasNext()) {
                                Operator dppSource = (Operator)op2.next();
                                if (dppSource instanceof ReduceSinkOperator) {
                                    GenTezUtils.removeSemiJoinOperator(pctx, (ReduceSinkOperator)dppSource, (TableScanOperator)sr.retainableOps.get(0));
                                    optimizerCache.tableScanToDPPSource.remove(sr.retainableOps.get(0), op);
                                    continue;
                                }
                                if (!(dppSource instanceof AppMasterEventOperator)) continue;
                                GenTezUtils.removeSemiJoinOperator(pctx, (AppMasterEventOperator)dppSource, (TableScanOperator)sr.retainableOps.get(0));
                                optimizerCache.tableScanToDPPSource.remove(sr.retainableOps.get(0), op);
                            }
                        }
                        LOG.debug("Operator removed: {}", op);
                    }
                }
                if (removedOps.contains(tableScanOperator)) {
                    existingOps.remove((Object)tableName, (Object)tableScanOperator);
                    continue;
                }
                existingOps.put((Object)tableName, (Object)tableScanOperator);
            }
        }
        Iterator it = topOps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (((TableScanOperator)e.getValue()).getNumChild() != 0) continue;
            it.remove();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("After SharedWorkOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_EXTENDED_OPTIMIZATION)) {
            ArrayListMultimap parentToRsOps = ArrayListMultimap.create();
            HashSet<Operator<Object>> visited = new HashSet();
            for (Map.Entry entry : topOps.entrySet()) {
                SharedWorkOptimizer.gatherReduceSinkOpsByInput(parentToRsOps, visited, SharedWorkOptimizer.findWorkOperators(optimizerCache, (Operator)entry.getValue()));
            }
            while (!parentToRsOps.isEmpty()) {
                List<Map.Entry<Operator<?>, Long>> sortedRSGroups = SharedWorkOptimizer.rankOpsByAccumulatedSize(parentToRsOps.keySet());
                LOG.debug("Sorted operators by size: {}", sortedRSGroups);
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                for (Map.Entry<Operator<?>, Long> rsGroupInfo : sortedRSGroups) {
                    Operator<?> rsParent = rsGroupInfo.getKey();
                    for (ReduceSinkOperator discardableRsOp : parentToRsOps.get(rsParent)) {
                        if (removedOps.contains(discardableRsOp)) {
                            LOG.debug("Skip {} as it has already been removed", (Object)discardableRsOp);
                            continue;
                        }
                        Collection otherRsOps = arrayListMultimap.get(rsParent);
                        for (ReduceSinkOperator retainableRsOp : otherRsOps) {
                            boolean mergeable;
                            if (removedOps.contains(retainableRsOp)) {
                                LOG.debug("Skip {} as it has already been removed", (Object)retainableRsOp);
                                continue;
                            }
                            boolean bl = mergeable = SharedWorkOptimizer.compareOperator(pctx, retainableRsOp, discardableRsOp) && SharedWorkOptimizer.compareOperator(pctx, retainableRsOp.getChildOperators().get(0), discardableRsOp.getChildOperators().get(0));
                            if (!mergeable) {
                                LOG.debug("{} and {} cannot be merged", (Object)retainableRsOp, (Object)discardableRsOp);
                                continue;
                            }
                            LOG.debug("Checking additional conditions for merging subtree starting at {} into subtree starting at {}", (Object)discardableRsOp, (Object)retainableRsOp);
                            Operator<OperatorDesc> retainableRsOpChild = retainableRsOp.getChildOperators().get(0);
                            Operator<OperatorDesc> discardableRsOpChild = discardableRsOp.getChildOperators().get(0);
                            SharedResult sr = SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, retainableRsOp, discardableRsOp, retainableRsOpChild, discardableRsOpChild);
                            if (sr.retainableOps.isEmpty() || !SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, sr)) {
                                LOG.debug("{} and {} do not meet preconditions", (Object)retainableRsOp, (Object)discardableRsOp);
                                continue;
                            }
                            Operator<?> lastRetainableOp = sr.retainableOps.get(sr.retainableOps.size() - 1);
                            Operator<?> lastDiscardableOp = sr.discardableOps.get(sr.discardableOps.size() - 1);
                            if (lastDiscardableOp.getNumChild() != 0) {
                                ArrayList allChildren = Lists.newArrayList(lastDiscardableOp.getChildOperators());
                                for (Operator op : allChildren) {
                                    lastDiscardableOp.getChildOperators().remove(op);
                                    op.replaceParent(lastDiscardableOp, lastRetainableOp);
                                    lastRetainableOp.getChildOperators().add(op);
                                }
                            }
                            LOG.debug("Merging subtree starting at {} into subtree starting at {}", (Object)discardableRsOp, (Object)retainableRsOp);
                            for (Operator<?> op : sr.discardableInputOps) {
                                DynamicPruningEventDesc dped;
                                OperatorUtils.removeOperator(op);
                                optimizerCache.removeOp(op);
                                removedOps.add(op);
                                if (op instanceof ReduceSinkOperator) {
                                    SemiJoinBranchInfo sjbi = pctx.getRsToSemiJoinBranchInfo().get(op);
                                    if (sjbi != null && !sr.discardableOps.contains(sjbi.getTsOp()) && !sr.discardableInputOps.contains(sjbi.getTsOp())) {
                                        GenTezUtils.removeSemiJoinOperator(pctx, (ReduceSinkOperator)op, sjbi.getTsOp());
                                        optimizerCache.tableScanToDPPSource.remove((Object)sjbi.getTsOp(), op);
                                    }
                                } else if (op instanceof AppMasterEventOperator && !sr.discardableOps.contains((dped = (DynamicPruningEventDesc)op.getConf()).getTableScan()) && !sr.discardableInputOps.contains(dped.getTableScan())) {
                                    GenTezUtils.removeSemiJoinOperator(pctx, (AppMasterEventOperator)op, dped.getTableScan());
                                    optimizerCache.tableScanToDPPSource.remove((Object)dped.getTableScan(), op);
                                }
                                LOG.debug("Input operator removed: {}", op);
                            }
                            OperatorUtils.removeOperator(discardableRsOp);
                            optimizerCache.removeOp(discardableRsOp);
                            removedOps.add(discardableRsOp);
                            LOG.debug("Operator removed: {}", (Object)discardableRsOp);
                            optimizerCache.removeOpAndCombineWork(discardableRsOpChild, retainableRsOpChild);
                            for (Operator<?> op : sr.discardableOps) {
                                OperatorUtils.removeOperator(op);
                                optimizerCache.removeOp(op);
                                removedOps.add(op);
                                LOG.debug("Operator removed: {}", op);
                            }
                        }
                        if (removedOps.contains(discardableRsOp)) {
                            arrayListMultimap.remove(rsParent, (Object)discardableRsOp);
                            continue;
                        }
                        arrayListMultimap.put(rsParent, (Object)discardableRsOp);
                    }
                }
                parentToRsOps = ArrayListMultimap.create();
                visited = new HashSet();
                for (Map.Entry<Operator<Object>, Long> e : arrayListMultimap.entries()) {
                    if (removedOps.contains(e.getValue()) || ((ReduceSinkOperator)((Object)e.getValue())).getNumChild() < 1) continue;
                    SharedWorkOptimizer.gatherReduceSinkOpsByInput(parentToRsOps, visited, SharedWorkOptimizer.findWorkOperators(optimizerCache, ((ReduceSinkOperator)((Object)e.getValue())).getChildOperators().get(0)));
                }
            }
            it = topOps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (((TableScanOperator)e.getValue()).getNumChild() != 0) continue;
                it.remove();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("After SharedWorkExtendedOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
            }
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            HashSet<Operator> visited = new HashSet<Operator>();
            for (Map.Entry e : topOps.entrySet()) {
                for (Operator operator : OperatorUtils.findOperators((Operator)e.getValue(), Operator.class)) {
                    if (visited.contains(operator)) continue;
                    if (!SharedWorkOptimizer.findWorkOperators(optimizerCache, operator).equals(SharedWorkOptimizer.findWorkOperators(operator, new HashSet()))) {
                        throw new SemanticException("Error in shared work optimizer: operator cache contentsand actual plan differ");
                    }
                    visited.add(operator);
                }
            }
        }
        return pctx;
    }

    private static void gatherDPPTableScanOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache) throws SemanticException {
        HashMap<String, TableScanOperator> topOps = pctx.getTopOps();
        ArrayList tableScanOps = Lists.newArrayList(topOps.values());
        Set<AppMasterEventOperator> s = OperatorUtils.findOperators(tableScanOps, AppMasterEventOperator.class);
        for (AppMasterEventOperator appMasterEventOperator : s) {
            if (!(appMasterEventOperator.getConf() instanceof DynamicPruningEventDesc)) continue;
            DynamicPruningEventDesc dped = (DynamicPruningEventDesc)appMasterEventOperator.getConf();
            optimizerCache.tableScanToDPPSource.put((Object)dped.getTableScan(), (Object)appMasterEventOperator);
        }
        for (Map.Entry entry : pctx.getRsToSemiJoinBranchInfo().entrySet()) {
            optimizerCache.tableScanToDPPSource.put((Object)((SemiJoinBranchInfo)entry.getValue()).getTsOp(), (Object)((Operator)entry.getKey()));
        }
        LOG.debug("DPP information stored in the cache: {}", optimizerCache.tableScanToDPPSource);
    }

    private static Multimap<String, TableScanOperator> splitTableScanOpsByTable(ParseContext pctx) {
        ArrayListMultimap tableNameToOps = ArrayListMultimap.create();
        TreeMap<String, TableScanOperator> sortedTopOps = new TreeMap<String, TableScanOperator>(pctx.getTopOps());
        for (Map.Entry e : sortedTopOps.entrySet()) {
            TableScanOperator tsOp = (TableScanOperator)e.getValue();
            tableNameToOps.put((Object)(((TableScanDesc)tsOp.getConf()).getTableMetadata().getDbName() + "." + ((TableScanDesc)tsOp.getConf()).getTableMetadata().getTableName()), (Object)tsOp);
        }
        return tableNameToOps;
    }

    private static List<Map.Entry<String, Long>> rankTablesByAccumulatedSize(ParseContext pctx) {
        HashMap<CallSite, Long> tableToTotalSize = new HashMap<CallSite, Long>();
        for (Map.Entry<String, TableScanOperator> e : pctx.getTopOps().entrySet()) {
            TableScanOperator tsOp = e.getValue();
            String tableName = ((TableScanDesc)tsOp.getConf()).getTableMetadata().getDbName() + "." + ((TableScanDesc)tsOp.getConf()).getTableMetadata().getTableName();
            long tableSize = tsOp.getStatistics() != null ? tsOp.getStatistics().getDataSize() : 0L;
            Long totalSize = (Long)tableToTotalSize.get(tableName);
            if (totalSize != null) {
                tableToTotalSize.put((CallSite)((Object)tableName), StatsUtils.safeAdd(totalSize, tableSize));
                continue;
            }
            tableToTotalSize.put((CallSite)((Object)tableName), tableSize);
        }
        ArrayList<Map.Entry<String, Long>> sortedTables = new ArrayList<Map.Entry<String, Long>>(tableToTotalSize.entrySet());
        Collections.sort(sortedTables, Collections.reverseOrder(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }));
        return sortedTables;
    }

    private static void gatherReduceSinkOpsByInput(Multimap<Operator<?>, ReduceSinkOperator> parentToRsOps, Set<Operator<?>> visited, Set<Operator<?>> ops) {
        for (Operator<?> op : ops) {
            if (!(op instanceof ReduceSinkOperator) || visited.contains(op)) continue;
            Operator<OperatorDesc> parent = op.getParentOperators().get(0);
            LinkedHashSet<ReduceSinkOperator> s = new LinkedHashSet<ReduceSinkOperator>();
            for (Operator<OperatorDesc> c : parent.getChildOperators()) {
                if (!(c instanceof ReduceSinkOperator)) continue;
                s.add((ReduceSinkOperator)c);
                visited.add(c);
            }
            if (s.size() <= 1) continue;
            parentToRsOps.putAll(parent, s);
        }
    }

    private static List<Map.Entry<Operator<?>, Long>> rankOpsByAccumulatedSize(Set<Operator<?>> opsSet) {
        HashMap opToTotalSize = new HashMap();
        for (Operator<?> op : opsSet) {
            long size = op.getStatistics() != null ? op.getStatistics().getDataSize() : 0L;
            opToTotalSize.put(op, StatsUtils.safeMult((long)op.getChildOperators().size(), size));
        }
        ArrayList sortedOps = new ArrayList(opToTotalSize.entrySet());
        Collections.sort(sortedOps, Collections.reverseOrder(new Comparator<Map.Entry<Operator<?>, Long>>(){

            @Override
            public int compare(Map.Entry<Operator<?>, Long> o1, Map.Entry<Operator<?>, Long> o2) {
                int valCmp = o1.getValue().compareTo(o2.getValue());
                if (valCmp == 0) {
                    return o1.getKey().toString().compareTo(o2.getKey().toString());
                }
                return valCmp;
            }
        }));
        return sortedOps;
    }

    private static boolean areMergeable(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        Set<Operator<?>> ascendants;
        Operator op;
        int i;
        List<String> prevTsOpNeededColumns = tsOp1.getNeededColumns();
        List<String> tsOpNeededColumns = tsOp2.getNeededColumns();
        if (prevTsOpNeededColumns.size() != tsOpNeededColumns.size()) {
            return false;
        }
        boolean notEqual = false;
        for (int i2 = 0; i2 < prevTsOpNeededColumns.size(); ++i2) {
            if (prevTsOpNeededColumns.get(i2).equals(tsOpNeededColumns.get(i2))) continue;
            notEqual = true;
            break;
        }
        if (notEqual) {
            return false;
        }
        if (((TableScanDesc)tsOp1.getConf()).getRowLimit() != ((TableScanDesc)tsOp2.getConf()).getRowLimit()) {
            return false;
        }
        if (!Objects.equals(((TableScanDesc)tsOp1.getConf()).getOpProps(), ((TableScanDesc)tsOp2.getConf()).getOpProps())) {
            return false;
        }
        PrunedPartitionList prevTsOpPPList = pctx.getPrunedPartitions(tsOp1);
        PrunedPartitionList tsOpPPList = pctx.getPrunedPartitions(tsOp2);
        if (!prevTsOpPPList.getPartitions().equals(tsOpPPList.getPartitions())) {
            return false;
        }
        ArrayList dppsOp1 = new ArrayList(optimizerCache.tableScanToDPPSource.get((Object)tsOp1));
        ArrayList dppsOp2 = new ArrayList(optimizerCache.tableScanToDPPSource.get((Object)tsOp2));
        if (dppsOp1.isEmpty() && dppsOp2.isEmpty()) {
            return true;
        }
        for (i = 0; i < dppsOp1.size(); ++i) {
            op = (Operator)dppsOp1.get(i);
            if (!(op instanceof ReduceSinkOperator) || !(ascendants = SharedWorkOptimizer.findAscendantWorkOperators(pctx, optimizerCache, op)).contains(tsOp2)) continue;
            return false;
        }
        for (i = 0; i < dppsOp2.size(); ++i) {
            op = (Operator)dppsOp2.get(i);
            if (!(op instanceof ReduceSinkOperator) || !(ascendants = SharedWorkOptimizer.findAscendantWorkOperators(pctx, optimizerCache, op)).contains(tsOp1)) continue;
            return false;
        }
        if (dppsOp1.size() != dppsOp2.size()) {
            return false;
        }
        BitSet bs = new BitSet();
        for (int i3 = 0; i3 < dppsOp1.size(); ++i3) {
            Operator dppOp1 = (Operator)dppsOp1.get(i3);
            for (int j = 0; j < dppsOp2.size(); ++j) {
                Operator dppOp2;
                if (bs.get(j) || SharedWorkOptimizer.compareAndGatherOps(pctx, dppOp1, dppOp2 = (Operator)dppsOp2.get(j)) == null) continue;
                bs.set(j);
                break;
            }
            if (bs.cardinality() >= i3 + 1) continue;
            return false;
        }
        return true;
    }

    private static SharedResult extractSharedOptimizationInfoForRoot(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator retainableTsOp, TableScanOperator discardableTsOp) throws SemanticException {
        LinkedHashSet retainableOps = new LinkedHashSet();
        LinkedHashSet discardableOps = new LinkedHashSet();
        HashSet discardableInputOps = new HashSet();
        long dataSize = 0L;
        long maxDataSize = 0L;
        retainableOps.add(retainableTsOp);
        discardableOps.add(discardableTsOp);
        Operator equalOp1 = retainableTsOp;
        Operator equalOp2 = discardableTsOp;
        if (equalOp1.getNumChild() > 1 || equalOp2.getNumChild() > 1) {
            discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
            return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
        }
        Operator<OperatorDesc> currentOp1 = retainableTsOp.getChildOperators().get(0);
        Operator<OperatorDesc> currentOp2 = discardableTsOp.getChildOperators().get(0);
        if (currentOp1 instanceof FilterOperator && currentOp2 instanceof FilterOperator) {
            Multiset<String> conjsOp2String;
            Multiset<String> conjsOp1String;
            boolean equalFilters = false;
            FilterDesc op1Conf = (FilterDesc)((FilterOperator)currentOp1).getConf();
            FilterDesc op2Conf = (FilterDesc)((FilterOperator)currentOp2).getConf();
            if (op1Conf.getIsSamplingPred() == op2Conf.getIsSamplingPred() && StringUtils.equals((String)op1Conf.getSampleDescExpr(), (String)op2Conf.getSampleDescExpr()) && (conjsOp1String = SharedWorkOptimizer.extractConjsIgnoringDPPPreds(op1Conf.getPredicate())).equals(conjsOp2String = SharedWorkOptimizer.extractConjsIgnoringDPPPreds(op2Conf.getPredicate()))) {
                equalFilters = true;
            }
            if (equalFilters) {
                equalOp1 = currentOp1;
                equalOp2 = currentOp2;
                retainableOps.add(equalOp1);
                discardableOps.add(equalOp2);
                if (currentOp1.getChildOperators().size() > 1 || currentOp2.getChildOperators().size() > 1) {
                    discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
                    discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
                    return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
                }
                currentOp1 = currentOp1.getChildOperators().get(0);
                currentOp2 = currentOp2.getChildOperators().get(0);
            } else {
                discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
                discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
                return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
            }
        }
        return SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, equalOp1, equalOp2, currentOp1, currentOp2, retainableOps, discardableOps, discardableInputOps, false);
    }

    private static SharedResult extractSharedOptimizationInfo(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> retainableOpEqualParent, Operator<?> discardableOpEqualParent, Operator<?> retainableOp, Operator<?> discardableOp) throws SemanticException {
        return SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, retainableOpEqualParent, discardableOpEqualParent, retainableOp, discardableOp, new LinkedHashSet(), new LinkedHashSet(), new HashSet(), true);
    }

    private static SharedResult extractSharedOptimizationInfo(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> retainableOpEqualParent, Operator<?> discardableOpEqualParent, Operator<?> retainableOp, Operator<?> discardableOp, LinkedHashSet<Operator<?>> retainableOps, LinkedHashSet<Operator<?>> discardableOps, Set<Operator<?>> discardableInputOps, boolean removeInputBranch) throws SemanticException {
        Operator<?> equalOp1 = retainableOpEqualParent;
        Operator<?> equalOp2 = discardableOpEqualParent;
        Operator<Object> currentOp1 = retainableOp;
        Operator<Object> currentOp2 = discardableOp;
        long dataSize = 0L;
        long maxDataSize = 0L;
        while (!(currentOp1 instanceof ReduceSinkOperator) && SharedWorkOptimizer.compareOperator(pctx, currentOp1, currentOp2) && currentOp1.getParentOperators().size() == currentOp2.getParentOperators().size()) {
            if (currentOp1.getParentOperators().size() > 1) {
                int idx;
                ArrayList discardableOpsForCurrentOp = new ArrayList();
                for (idx = 0; idx < currentOp1.getParentOperators().size(); ++idx) {
                    List<Operator<?>> removeOpsForCurrentInput;
                    Operator<OperatorDesc> parentOp1 = currentOp1.getParentOperators().get(idx);
                    Operator<OperatorDesc> parentOp2 = currentOp2.getParentOperators().get(idx);
                    if (parentOp1 == equalOp1 && parentOp2 == equalOp2 && !removeInputBranch) continue;
                    if (parentOp1 == equalOp1 && parentOp2 != equalOp2 || parentOp1 != equalOp1 && parentOp2 == equalOp2 || (removeOpsForCurrentInput = SharedWorkOptimizer.compareAndGatherOps(pctx, parentOp1, parentOp2)) == null) break;
                    discardableOpsForCurrentOp.addAll(removeOpsForCurrentInput);
                }
                if (idx != currentOp1.getParentOperators().size()) break;
                discardableInputOps.addAll(discardableOpsForCurrentOp);
            }
            equalOp1 = currentOp1;
            equalOp2 = currentOp2;
            retainableOps.add(equalOp1);
            discardableOps.add(equalOp2);
            if (equalOp1 instanceof MapJoinOperator) {
                MapJoinOperator mop = (MapJoinOperator)equalOp1;
                dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
                maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
            }
            if (currentOp1.getChildOperators().size() > 1 || currentOp2.getChildOperators().size() > 1) break;
            currentOp1 = currentOp1.getChildOperators().get(0);
            currentOp2 = currentOp2.getChildOperators().get(0);
        }
        Set<Operator<?>> opsWork1 = SharedWorkOptimizer.findWorkOperators(optimizerCache, currentOp1);
        for (Operator<?> op : opsWork1) {
            if (!(op instanceof MapJoinOperator) || retainableOps.contains(op)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        Set<Operator<?>> opsWork2 = SharedWorkOptimizer.findWorkOperators(optimizerCache, currentOp2);
        for (Operator<?> op : opsWork2) {
            if (!(op instanceof MapJoinOperator) || discardableOps.contains(op)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, Sets.union(discardableInputOps, discardableOps)));
        discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
        return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
    }

    private static Multiset<String> extractConjsIgnoringDPPPreds(ExprNodeDesc predicate) {
        List<ExprNodeDesc> conjsOp = ExprNodeDescUtils.split(predicate);
        TreeMultiset conjsOpString = TreeMultiset.create();
        for (int i = 0; i < conjsOp.size(); ++i) {
            ExprNodeGenericFuncDesc func;
            if (conjsOp.get(i) instanceof ExprNodeGenericFuncDesc ? GenericUDFInBloomFilter.class == (func = (ExprNodeGenericFuncDesc)conjsOp.get(i)).getGenericUDF().getClass() || GenericUDFBetween.class == func.getGenericUDF().getClass() && (func.getChildren().get(2) instanceof ExprNodeDynamicValueDesc || func.getChildren().get(3) instanceof ExprNodeDynamicValueDesc) : conjsOp.get(i) instanceof ExprNodeDynamicListDesc) continue;
            conjsOpString.add((Object)conjsOp.get(i).toString());
        }
        return conjsOpString;
    }

    private static Set<Operator<?>> gatherDPPBranchOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Set<Operator<?>> ops) {
        HashSet dppBranches = new HashSet();
        for (Operator<?> op : ops) {
            if (!(op instanceof TableScanOperator)) continue;
            Collection c = optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op));
            for (Operator dppSource : c) {
                SharedWorkOptimizer.removeBranch(dppSource, dppBranches, ops);
            }
        }
        return dppBranches;
    }

    private static Set<Operator<?>> gatherDPPBranchOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Set<Operator<?>> ops, Set<Operator<?>> discardedOps) {
        HashSet dppBranches = new HashSet();
        for (Operator<?> op : ops) {
            if (!(op instanceof TableScanOperator)) continue;
            Collection c = optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op));
            for (Operator dppSource : c) {
                Set<Operator<?>> ascendants = SharedWorkOptimizer.findAscendantWorkOperators(pctx, optimizerCache, dppSource);
                if (Collections.disjoint(ascendants, discardedOps)) continue;
                SharedWorkOptimizer.removeBranch(dppSource, dppBranches, ops);
            }
        }
        return dppBranches;
    }

    private static void removeBranch(Operator<?> currentOp, Set<Operator<?>> branchesOps, Set<Operator<?>> discardableOps) {
        if (currentOp.getNumChild() > 1) {
            for (Operator<OperatorDesc> childOp : currentOp.getChildOperators()) {
                if (branchesOps.contains(childOp) || discardableOps.contains(childOp)) continue;
                return;
            }
        }
        branchesOps.add(currentOp);
        if (currentOp.getParentOperators() != null) {
            for (Operator<OperatorDesc> parentOp : currentOp.getParentOperators()) {
                SharedWorkOptimizer.removeBranch(parentOp, branchesOps, discardableOps);
            }
        }
    }

    private static List<Operator<?>> compareAndGatherOps(ParseContext pctx, Operator<?> op1, Operator<?> op2) throws SemanticException {
        ArrayList result = new ArrayList();
        boolean mergeable = SharedWorkOptimizer.compareAndGatherOps(pctx, op1, op2, result, true);
        if (!mergeable) {
            return null;
        }
        return result;
    }

    private static boolean compareAndGatherOps(ParseContext pctx, Operator<?> op1, Operator<?> op2, List<Operator<?>> result, boolean gather) throws SemanticException {
        if (!SharedWorkOptimizer.compareOperator(pctx, op1, op2)) {
            LOG.debug("Operators not equal: {} and {}", op1, op2);
            return false;
        }
        if (gather && op2.getChildOperators().size() > 1) {
            gather = false;
        }
        if (gather) {
            result.add(op2);
        }
        List<Operator<OperatorDesc>> op1ParentOperators = op1.getParentOperators();
        List<Operator<OperatorDesc>> op2ParentOperators = op2.getParentOperators();
        if (op1ParentOperators != null && op2ParentOperators != null) {
            if (op1ParentOperators.size() != op2ParentOperators.size()) {
                return false;
            }
            for (int i = 0; i < op1ParentOperators.size(); ++i) {
                Operator<OperatorDesc> op2ParentOp;
                Operator<OperatorDesc> op1ParentOp = op1ParentOperators.get(i);
                boolean mergeable = SharedWorkOptimizer.compareAndGatherOps(pctx, op1ParentOp, op2ParentOp = op2ParentOperators.get(i), result, gather);
                if (mergeable) continue;
                return false;
            }
        } else if (op1ParentOperators != null || op2ParentOperators != null) {
            return false;
        }
        return true;
    }

    private static boolean compareOperator(ParseContext pctx, Operator<?> op1, Operator<?> op2) throws SemanticException {
        if (!op1.getClass().getName().equals(op2.getClass().getName())) {
            return false;
        }
        if (op1 instanceof ReduceSinkOperator) {
            ReduceSinkDesc op1Conf = (ReduceSinkDesc)((ReduceSinkOperator)op1).getConf();
            ReduceSinkDesc op2Conf = (ReduceSinkDesc)((ReduceSinkOperator)op2).getConf();
            return StringUtils.equals((String)op1Conf.getKeyColString(), (String)op2Conf.getKeyColString()) && StringUtils.equals((String)op1Conf.getValueColsString(), (String)op2Conf.getValueColsString()) && StringUtils.equals((String)op1Conf.getParitionColsString(), (String)op2Conf.getParitionColsString()) && op1Conf.getTag() == op2Conf.getTag() && StringUtils.equals((String)op1Conf.getOrder(), (String)op2Conf.getOrder()) && op1Conf.getTopN() == op2Conf.getTopN() && op1Conf.isAutoParallel() == op2Conf.isAutoParallel();
        }
        if (op1 instanceof TableScanOperator) {
            TableScanOperator tsOp1 = (TableScanOperator)op1;
            TableScanOperator tsOp2 = (TableScanOperator)op2;
            TableScanDesc op1Conf = (TableScanDesc)tsOp1.getConf();
            TableScanDesc op2Conf = (TableScanDesc)tsOp2.getConf();
            Table tableMeta1 = op1Conf.getTableMetadata();
            Table tableMeta2 = op2Conf.getTableMetadata();
            return StringUtils.equals((String)tableMeta1.getFullyQualifiedName(), (String)tableMeta2.getFullyQualifiedName()) && op1Conf.getNeededColumns().equals(op2Conf.getNeededColumns()) && StringUtils.equals((String)op1Conf.getFilterExprString(), (String)op2Conf.getFilterExprString()) && pctx.getPrunedPartitions(tsOp1).getPartitions().equals(pctx.getPrunedPartitions(tsOp2).getPartitions()) && op1Conf.getRowLimit() == op2Conf.getRowLimit() && Objects.equals(op1Conf.getOpProps(), op2Conf.getOpProps());
        }
        return op1.logicalEquals(op2);
    }

    private static boolean validPreConditions(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, SharedResult sr) {
        Sets.SetView excludeOps2;
        Set<Operator<?>> inputWorksOps2;
        Set<Operator<?>> outputWorksOps2;
        if (sr.dataSize > sr.maxDataSize) {
            LOG.debug("accumulated data size: {} / max size: {}", (Object)sr.dataSize, (Object)sr.maxDataSize);
            return false;
        }
        Operator<?> op1 = sr.retainableOps.get(0);
        Operator<?> op2 = sr.discardableOps.get(0);
        Set<Operator<?>> workOps1 = SharedWorkOptimizer.findWorkOperators(optimizerCache, op1);
        Set<Operator<?>> workOps2 = SharedWorkOptimizer.findWorkOperators(optimizerCache, op2);
        boolean foundDummyStoreOp = false;
        for (Operator<?> op : workOps1) {
            if (op instanceof UnionOperator) {
                return false;
            }
            if (!(op instanceof DummyStoreOperator)) continue;
            foundDummyStoreOp = true;
        }
        for (Operator<?> op : workOps2) {
            if (op instanceof UnionOperator) {
                return false;
            }
            if (!foundDummyStoreOp || !(op instanceof DummyStoreOperator)) continue;
            return false;
        }
        Set<Operator<?>> outputWorksOps1 = SharedWorkOptimizer.findChildWorkOperators(pctx, optimizerCache, op1);
        if (!Collections.disjoint(outputWorksOps1, outputWorksOps2 = SharedWorkOptimizer.findChildWorkOperators(pctx, optimizerCache, op2))) {
            return false;
        }
        ImmutableSet excludeOps1 = sr.retainableOps.get(0).getNumParent() > 0 ? ImmutableSet.copyOf(sr.retainableOps.get(0).getParentOperators()) : ImmutableSet.of();
        Set<Operator<?>> inputWorksOps1 = SharedWorkOptimizer.findParentWorkOperators(pctx, optimizerCache, op1, excludeOps1);
        if (!Collections.disjoint(inputWorksOps1, inputWorksOps2 = SharedWorkOptimizer.findParentWorkOperators(pctx, optimizerCache, op2, excludeOps2 = sr.discardableOps.get(0).getNumParent() > 0 ? Sets.union((Set)ImmutableSet.copyOf(sr.discardableOps.get(0).getParentOperators()), sr.discardableInputOps) : sr.discardableInputOps))) {
            return false;
        }
        Set<Operator<?>> descendantWorksOps1 = SharedWorkOptimizer.findDescendantWorkOperators(pctx, optimizerCache, op1, sr.discardableInputOps);
        Set<Operator<?>> descendantWorksOps2 = SharedWorkOptimizer.findDescendantWorkOperators(pctx, optimizerCache, op2, sr.discardableInputOps);
        return Collections.disjoint(descendantWorksOps1, workOps2) && Collections.disjoint(workOps1, descendantWorksOps2);
    }

    private static Set<Operator<?>> findParentWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        return SharedWorkOptimizer.findParentWorkOperators(pctx, optimizerCache, start, ImmutableSet.of());
    }

    private static Set<Operator<?>> findParentWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start, Set<Operator<?>> excludeOps) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet set = new HashSet();
        for (Operator<?> op : workOps) {
            if (op.getParentOperators() != null) {
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    if (!(parent instanceof ReduceSinkOperator) || excludeOps.contains(parent)) continue;
                    set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, parent));
                }
                continue;
            }
            if (!(op instanceof TableScanOperator)) continue;
            for (Operator<OperatorDesc> parent : optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op))) {
                if (excludeOps.contains(parent)) continue;
                set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, parent));
            }
        }
        return set;
    }

    private static Set<Operator<?>> findAscendantWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet result = new HashSet();
        while (!workOps.isEmpty()) {
            HashSet set = new HashSet();
            for (Operator<?> op : workOps) {
                if (op.getParentOperators() != null) {
                    for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                        if (!(parent instanceof ReduceSinkOperator)) continue;
                        set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, parent));
                    }
                    continue;
                }
                if (!(op instanceof TableScanOperator)) continue;
                for (Operator<OperatorDesc> parent : optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op))) {
                    set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, parent));
                }
            }
            workOps = set;
            result.addAll(set);
        }
        return result;
    }

    private static Set<Operator<?>> findChildWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet set = new HashSet();
        for (Operator<?> op : workOps) {
            if (op instanceof ReduceSinkOperator) {
                SemiJoinBranchInfo sjbi;
                if (op.getChildOperators() != null) {
                    for (Operator<OperatorDesc> child : op.getChildOperators()) {
                        set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, child));
                    }
                }
                if ((sjbi = pctx.getRsToSemiJoinBranchInfo().get(op)) == null) continue;
                set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, sjbi.getTsOp()));
                continue;
            }
            if (!(op.getConf() instanceof DynamicPruningEventDesc)) continue;
            set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, ((DynamicPruningEventDesc)op.getConf()).getTableScan()));
        }
        return set;
    }

    private static Set<Operator<?>> findDescendantWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start, Set<Operator<?>> excludeOps) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet result = new HashSet();
        while (!workOps.isEmpty()) {
            HashSet set = new HashSet();
            for (Operator<?> op : workOps) {
                if (excludeOps.contains(op)) continue;
                if (op instanceof ReduceSinkOperator) {
                    SemiJoinBranchInfo sjbi;
                    if (op.getChildOperators() != null) {
                        for (Operator<OperatorDesc> child : op.getChildOperators()) {
                            set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, child));
                        }
                    }
                    if ((sjbi = pctx.getRsToSemiJoinBranchInfo().get(op)) == null) continue;
                    set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, sjbi.getTsOp()));
                    continue;
                }
                if (!(op.getConf() instanceof DynamicPruningEventDesc)) continue;
                set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, ((DynamicPruningEventDesc)op.getConf()).getTableScan()));
            }
            workOps = set;
            result.addAll(set);
        }
        return result;
    }

    private static Set<Operator<?>> findWorkOperators(SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        Set<Operator<?>> c = optimizerCache.operatorToWorkOperators.get(start);
        if (!c.isEmpty()) {
            return c;
        }
        c = SharedWorkOptimizer.findWorkOperators(start, new HashSet());
        for (Operator<?> op : c) {
            optimizerCache.operatorToWorkOperators.putAll(op, c);
        }
        return c;
    }

    private static Set<Operator<?>> findWorkOperators(Operator<?> start, Set<Operator<?>> found) {
        found.add(start);
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                if (parent instanceof ReduceSinkOperator || found.contains(parent)) continue;
                SharedWorkOptimizer.findWorkOperators(parent, found);
            }
        }
        if (start instanceof ReduceSinkOperator) {
            return found;
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                if (found.contains(child)) continue;
                SharedWorkOptimizer.findWorkOperators(child, found);
            }
        }
        return found;
    }

    private static void pushFilterToTopOfTableScan(SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp) throws UDFArgumentException {
        ExprNodeGenericFuncDesc tableScanExprNode = ((TableScanDesc)tsOp.getConf()).getFilterExpr();
        ArrayList allChildren = Lists.newArrayList(tsOp.getChildOperators());
        for (Operator op : allChildren) {
            if (op instanceof FilterOperator) {
                FilterOperator filterOp = (FilterOperator)op;
                ExprNodeDesc filterExprNode = ((FilterDesc)filterOp.getConf()).getPredicate();
                if (tableScanExprNode.isSame(filterExprNode)) {
                    return;
                }
                if (tableScanExprNode.getGenericUDF() instanceof GenericUDFOPOr) {
                    for (ExprNodeDesc childExprNode : tableScanExprNode.getChildren()) {
                        if (!childExprNode.isSame(filterExprNode)) continue;
                        return;
                    }
                }
                ExprNodeGenericFuncDesc newPred = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPAnd(), Arrays.asList(tableScanExprNode.clone(), filterExprNode));
                ((FilterDesc)filterOp.getConf()).setPredicate(newPred);
                continue;
            }
            Operator<FilterDesc> newOp = OperatorFactory.get(tsOp.getCompilationOpContext(), new FilterDesc(tableScanExprNode.clone(), false), new RowSchema(tsOp.getSchema().getSignature()));
            tsOp.replaceChild(op, newOp);
            newOp.getParentOperators().add(tsOp);
            op.replaceParent(tsOp, newOp);
            newOp.getChildOperators().add(op);
            optimizerCache.putIfWorkExists(newOp, tsOp);
        }
    }

    private static class SharedWorkOptimizerCache {
        final HashMultimap<Operator<?>, Operator<?>> operatorToWorkOperators = HashMultimap.create();
        final Multimap<TableScanOperator, Operator<?>> tableScanToDPPSource = HashMultimap.create();

        private SharedWorkOptimizerCache() {
        }

        void putIfWorkExists(Operator<?> opToAdd, Operator<?> existingOp) {
            ImmutableList c = ImmutableList.copyOf((Collection)this.operatorToWorkOperators.get(existingOp));
            if (!c.isEmpty()) {
                for (Operator op : c) {
                    this.operatorToWorkOperators.get((Object)op).add(opToAdd);
                }
                this.operatorToWorkOperators.putAll(opToAdd, (Iterable)c);
                this.operatorToWorkOperators.put(opToAdd, opToAdd);
            }
        }

        void removeOp(Operator<?> opToRemove) {
            Set s = this.operatorToWorkOperators.get(opToRemove);
            s.remove(opToRemove);
            ImmutableList c1 = ImmutableList.copyOf((Collection)s);
            if (!c1.isEmpty()) {
                for (Operator op1 : c1) {
                    this.operatorToWorkOperators.remove((Object)op1, opToRemove);
                }
                this.operatorToWorkOperators.removeAll(opToRemove);
            }
        }

        void removeOpAndCombineWork(Operator<?> opToRemove, Operator<?> replacementOp) {
            Set s = this.operatorToWorkOperators.get(opToRemove);
            s.remove(opToRemove);
            ImmutableList c1 = ImmutableList.copyOf((Collection)s);
            ImmutableList c2 = ImmutableList.copyOf((Collection)this.operatorToWorkOperators.get(replacementOp));
            if (!c1.isEmpty() && !c2.isEmpty()) {
                for (Operator op1 : c1) {
                    this.operatorToWorkOperators.remove((Object)op1, opToRemove);
                    this.operatorToWorkOperators.putAll((Object)op1, (Iterable)c2);
                }
                this.operatorToWorkOperators.removeAll(opToRemove);
                for (Operator op2 : c2) {
                    this.operatorToWorkOperators.putAll((Object)op2, (Iterable)c1);
                }
            }
        }

        public String toString() {
            return "SharedWorkOptimizerCache { \n" + this.operatorToWorkOperators.toString() + "\n };";
        }
    }

    private static class SharedResult {
        final List<Operator<?>> retainableOps;
        final List<Operator<?>> discardableOps;
        final Set<Operator<?>> discardableInputOps;
        final long dataSize;
        final long maxDataSize;

        private SharedResult(Collection<Operator<?>> retainableOps, Collection<Operator<?>> discardableOps, Set<Operator<?>> discardableInputOps, long dataSize, long maxDataSize) {
            this.retainableOps = ImmutableList.copyOf(retainableOps);
            this.discardableOps = ImmutableList.copyOf(discardableOps);
            this.discardableInputOps = ImmutableSet.copyOf(discardableInputOps);
            this.dataSize = dataSize;
            this.maxDataSize = maxDataSize;
        }

        public String toString() {
            return "SharedResult { " + this.retainableOps + "; " + this.discardableOps + "; " + this.discardableInputOps + "};";
        }
    }
}

