/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.CountCollectorTestOperator;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowCollectorTestOperator;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowCollectorTestOperatorBase;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowVectorCollectorTestOperator;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjectsMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestConfig;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestData;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestDescription;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorBatchGenerateStream;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Test;

public class TestMapJoinOperator {
    private static KeyConfig[] longKeyConfigs = new KeyConfig[]{new KeyConfig(234882L, TypeInfoFactory.longTypeInfo), new KeyConfig(4600L, TypeInfoFactory.intTypeInfo), new KeyConfig(98743L, TypeInfoFactory.shortTypeInfo)};

    @Test
    public void testLong() throws Exception {
        for (KeyConfig longKeyConfig : longKeyConfigs) {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                if (vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.NONE) continue;
                this.doTestLong(longKeyConfig.seed, (TypeInfo)longKeyConfig.primitiveTypeInfo, vectorMapJoinVariation);
            }
        }
    }

    public void doTestLong(long seed, TypeInfo numberTypeInfo, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation) throws Exception {
        int rowCount = 10000;
        HiveConf hiveConf = new HiveConf();
        String[] bigTableColumnNames = new String[]{"number1"};
        TypeInfo[] bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.longTypeInfo};
        int[] bigTableKeyColumnNums = new int[]{0};
        String[] smallTableValueColumnNames = new String[]{"sv1", "sv2"};
        TypeInfo[] smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.dateTypeInfo, TypeInfoFactory.stringTypeInfo};
        int[] bigTableRetainColumnNums = new int[]{0};
        int[] smallTableRetainKeyColumnNums = new int[]{};
        int[] smallTableRetainValueColumnNums = new int[]{0, 1};
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableColumnNames, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueColumnNames, smallTableValueTypeInfos, bigTableRetainColumnNums, smallTableRetainKeyColumnNums, smallTableRetainValueColumnNums, smallTableGenerationParameters);
        MapJoinTestData testData = new MapJoinTestData(rowCount, testDesc, seed, seed * 10L);
        this.executeTest(testDesc, testData);
    }

    @Test
    public void testMultiKey() throws Exception {
        long seed = 87543L;
        for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
            if (vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.NONE) continue;
            this.doTestMultiKey(seed, vectorMapJoinVariation);
        }
    }

    public void doTestMultiKey(long seed, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation) throws Exception {
        int rowCount = 10000;
        HiveConf hiveConf = new HiveConf();
        String[] bigTableColumnNames = new String[]{"b1", "b2", "b3"};
        TypeInfo[] bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.intTypeInfo, TypeInfoFactory.longTypeInfo, TypeInfoFactory.stringTypeInfo};
        int[] bigTableKeyColumnNums = new int[]{0, 1, 2};
        String[] smallTableValueColumnNames = new String[]{"sv1"};
        TypeInfo[] smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
        int[] bigTableRetainColumnNums = new int[]{0, 1, 2};
        int[] smallTableRetainKeyColumnNums = new int[]{};
        int[] smallTableRetainValueColumnNums = new int[]{0};
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableColumnNames, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueColumnNames, smallTableValueTypeInfos, bigTableRetainColumnNums, smallTableRetainKeyColumnNums, smallTableRetainValueColumnNums, smallTableGenerationParameters);
        MapJoinTestData testData = new MapJoinTestData(rowCount, testDesc, seed, seed * 10L);
        this.executeTest(testDesc, testData);
    }

    @Test
    public void testString() throws Exception {
        long seed = 87543L;
        for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
            if (vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.NONE) continue;
            this.doTestString(seed, vectorMapJoinVariation);
        }
    }

    public void doTestString(long seed, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation) throws Exception {
        int rowCount = 10000;
        HiveConf hiveConf = new HiveConf();
        String[] bigTableColumnNames = new String[]{"b1"};
        TypeInfo[] bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
        int[] bigTableKeyColumnNums = new int[]{0};
        String[] smallTableValueColumnNames = new String[]{"sv1", "sv2"};
        TypeInfo[] smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.dateTypeInfo, TypeInfoFactory.timestampTypeInfo};
        int[] bigTableRetainColumnNums = new int[]{0};
        int[] smallTableRetainKeyColumnNums = new int[]{};
        int[] smallTableRetainValueColumnNums = new int[]{0, 1};
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableColumnNames, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueColumnNames, smallTableValueTypeInfos, bigTableRetainColumnNums, smallTableRetainKeyColumnNums, smallTableRetainValueColumnNums, smallTableGenerationParameters);
        MapJoinTestData testData = new MapJoinTestData(rowCount, testDesc, seed, seed * 10L);
        this.executeTest(testDesc, testData);
    }

    private void addBigTableRetained(MapJoinTestDescription testDesc, Object[] bigTableRowObjects, Object[] outputObjects) {
        int bigTableRetainColumnNumsLength = testDesc.bigTableRetainColumnNums.length;
        for (int o = 0; o < bigTableRetainColumnNumsLength; ++o) {
            outputObjects[o] = bigTableRowObjects[testDesc.bigTableRetainColumnNums[o]];
        }
    }

    private void addToOutput(MapJoinTestDescription testDesc, RowTestObjectsMultiSet expectedTestRowMultiSet, Object[] outputObjects) {
        for (int c = 0; c < outputObjects.length; ++c) {
            PrimitiveObjectInspector primitiveObjInsp = (PrimitiveObjectInspector)testDesc.outputObjectInspectors[c];
            Object outputObject = outputObjects[c];
            outputObjects[c] = primitiveObjInsp.copyObject(outputObject);
        }
        expectedTestRowMultiSet.add(new RowTestObjects(outputObjects));
    }

    private RowTestObjectsMultiSet createExpectedTestRowMultiSet(MapJoinTestDescription testDesc, MapJoinTestData testData) throws HiveException {
        RowTestObjectsMultiSet expectedTestRowMultiSet = new RowTestObjectsMultiSet();
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(testDesc.bigTableKeyTypeInfos);
        int bigTableColumnCount = testDesc.bigTableTypeInfos.length;
        Object[] bigTableRowObjects = new Object[bigTableColumnCount];
        int bigTableKeyColumnCount = testDesc.bigTableKeyTypeInfos.length;
        Object[] bigTableKeyObjects = new Object[bigTableKeyColumnCount];
        VectorBatchGenerateStream bigTableBatchStream = testData.getBigTableBatchStream();
        VectorizedRowBatch batch = testData.getBigTableBatch();
        bigTableBatchStream.reset();
        while (bigTableBatchStream.isNext()) {
            batch.reset();
            bigTableBatchStream.fillNext(batch);
            int size = testData.bigTableBatch.size;
            block6: for (int r = 0; r < size; ++r) {
                vectorExtractRow.extractRow(testData.bigTableBatch, r, bigTableRowObjects);
                for (int k = 0; k < bigTableKeyColumnCount; ++k) {
                    int keyColumnNum = testDesc.bigTableKeyColumnNums[k];
                    bigTableKeyObjects[k] = bigTableRowObjects[keyColumnNum];
                    bigTableKeyObjects[k] = ((PrimitiveObjectInspector)testDesc.bigTableObjectInspectors[keyColumnNum]).copyObject(bigTableKeyObjects[k]);
                }
                RowTestObjects testKey = new RowTestObjects(bigTableKeyObjects);
                if (testData.smallTableKeyHashMap.containsKey(testKey)) {
                    int smallTableKeyIndex = testData.smallTableKeyHashMap.get(testKey);
                    switch (testDesc.vectorMapJoinVariation) {
                        case INNER: 
                        case OUTER: {
                            ArrayList<RowTestObjects> valueList = testData.smallTableValues.get(smallTableKeyIndex);
                            int valueCount = valueList.size();
                            for (int v = 0; v < valueCount; ++v) {
                                Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                                this.addBigTableRetained(testDesc, bigTableRowObjects, outputObjects);
                                Object[] valueRow = valueList.get(v).getRow();
                                int bigTableRetainColumnNumsLength = testDesc.bigTableRetainColumnNums.length;
                                int smallTableRetainValueColumnNumsLength = testDesc.smallTableRetainValueColumnNums.length;
                                for (int o = 0; o < smallTableRetainValueColumnNumsLength; ++o) {
                                    outputObjects[bigTableRetainColumnNumsLength + o] = valueRow[testDesc.smallTableRetainValueColumnNums[o]];
                                }
                                this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects);
                            }
                            continue block6;
                        }
                        case INNER_BIG_ONLY: {
                            int valueCount = testData.smallTableValueCounts.get(smallTableKeyIndex);
                            for (int v = 0; v < valueCount; ++v) {
                                Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                                this.addBigTableRetained(testDesc, bigTableRowObjects, outputObjects);
                                this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects);
                            }
                            continue block6;
                        }
                        case LEFT_SEMI: {
                            Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                            this.addBigTableRetained(testDesc, bigTableRowObjects, outputObjects);
                            this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown operator variation " + testDesc.vectorMapJoinVariation);
                        }
                    }
                    continue;
                }
                if (testDesc.vectorMapJoinVariation != VectorMapJoinDesc.VectorMapJoinVariation.OUTER) continue;
                Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                this.addBigTableRetained(testDesc, bigTableRowObjects, outputObjects);
                int bigTableRetainColumnNumsLength = testDesc.bigTableRetainColumnNums.length;
                int smallTableRetainValueColumnNumsLength = testDesc.smallTableRetainValueColumnNums.length;
                for (int o = 0; o < smallTableRetainValueColumnNumsLength; ++o) {
                    outputObjects[bigTableRetainColumnNumsLength + o] = null;
                }
                this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects);
            }
        }
        return expectedTestRowMultiSet;
    }

    private void executeTest(MapJoinTestDescription testDesc, MapJoinTestData testData) throws Exception {
        RowTestObjectsMultiSet expectedTestRowMultiSet = this.createExpectedTestRowMultiSet(testDesc, testData);
        System.out.println("*BENCHMARK* expectedTestRowMultiSet rowCount " + expectedTestRowMultiSet.getRowCount() + " totalCount " + expectedTestRowMultiSet.getTotalCount());
        for (MapJoinTestConfig.MapJoinTestImplementation mapJoinImplementation : MapJoinTestConfig.MapJoinTestImplementation.values()) {
            this.executeTestImplementation(mapJoinImplementation, testDesc, testData, expectedTestRowMultiSet);
        }
    }

    private boolean isVectorOutput(MapJoinTestConfig.MapJoinTestImplementation mapJoinImplementation) {
        return mapJoinImplementation != MapJoinTestConfig.MapJoinTestImplementation.ROW_MODE_HASH_MAP && mapJoinImplementation != MapJoinTestConfig.MapJoinTestImplementation.ROW_MODE_OPTIMIZED;
    }

    private void executeTestImplementation(MapJoinTestConfig.MapJoinTestImplementation mapJoinImplementation, MapJoinTestDescription testDesc, MapJoinTestData testData, RowTestObjectsMultiSet expectedTestRowMultiSet) throws Exception {
        System.out.println("*BENCHMARK* Starting " + mapJoinImplementation + " test");
        MapJoinDesc mapJoinDesc = MapJoinTestConfig.createMapJoinDesc(testDesc);
        boolean isVectorOutput = this.isVectorOutput(mapJoinImplementation);
        RowTestObjectsMultiSet outputTestRowMultiSet = new RowTestObjectsMultiSet();
        RowCollectorTestOperatorBase testCollectorOperator = !isVectorOutput ? new TestMultiSetCollectorOperator(testDesc.outputObjectInspectors, outputTestRowMultiSet) : new TestMultiSetVectorCollectorOperator(testDesc.outputTypeInfos, testDesc.outputObjectInspectors, outputTestRowMultiSet);
        MapJoinOperator operator = MapJoinTestConfig.createMapJoinImplementation(mapJoinImplementation, testDesc, testCollectorOperator, testData, mapJoinDesc);
        if (!isVectorOutput) {
            MapJoinTestData.driveBigTableData(testDesc, testData, operator);
        } else {
            MapJoinTestData.driveVectorBigTableData(testDesc, testData, operator);
        }
        System.out.println("*BENCHMARK* executeTestImplementation row count " + ((CountCollectorTestOperator)testCollectorOperator).getRowCount());
        if (!expectedTestRowMultiSet.verify(outputTestRowMultiSet)) {
            System.out.println("*BENCHMARK* verify failed for " + mapJoinImplementation);
        } else {
            System.out.println("*BENCHMARK* verify succeeded for " + mapJoinImplementation);
        }
    }

    private static class KeyConfig {
        long seed;
        PrimitiveTypeInfo primitiveTypeInfo;

        KeyConfig(long seed, PrimitiveTypeInfo primitiveTypeInfo) {
            this.seed = seed;
            this.primitiveTypeInfo = primitiveTypeInfo;
        }
    }

    private class TestMultiSetVectorCollectorOperator
    extends RowVectorCollectorTestOperator {
        private final RowTestObjectsMultiSet testRowMultiSet;

        public RowTestObjectsMultiSet getTestRowMultiSet() {
            return this.testRowMultiSet;
        }

        public TestMultiSetVectorCollectorOperator(TypeInfo[] outputTypeInfos, ObjectInspector[] outputObjectInspectors, RowTestObjectsMultiSet testRowMultiSet) throws HiveException {
            super(outputTypeInfos, outputObjectInspectors);
            this.testRowMultiSet = testRowMultiSet;
        }

        @Override
        public void nextTestRow(RowTestObjects testRow) {
            this.testRowMultiSet.add(testRow);
        }

        @Override
        public String getName() {
            return TestMultiSetVectorCollectorOperator.class.getSimpleName();
        }
    }

    private class TestMultiSetCollectorOperator
    extends RowCollectorTestOperator {
        private final RowTestObjectsMultiSet testRowMultiSet;

        public TestMultiSetCollectorOperator(ObjectInspector[] outputObjectInspectors, RowTestObjectsMultiSet testRowMultiSet) {
            super(outputObjectInspectors);
            this.testRowMultiSet = testRowMultiSet;
        }

        public RowTestObjectsMultiSet getTestRowMultiSet() {
            return this.testRowMultiSet;
        }

        @Override
        public void nextTestRow(RowTestObjects testRow) {
            this.testRowMultiSet.add(testRow);
        }

        @Override
        public String getName() {
            return TestMultiSetCollectorOperator.class.getSimpleName();
        }
    }
}

