/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.tez.HostAffinitySplitLocationProvider;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHostAffinitySplitLocationProvider {
    private final Logger LOG = LoggerFactory.getLogger(TestHostAffinitySplitLocationProvider.class);
    private static final List<String> locations;
    private static final Set<String> locationsSet;
    private static final List<String> executorLocations;
    private static final Set<String> executorLocationsSet;

    @Test(timeout=5000L)
    public void testNonFileSplits() throws IOException {
        HostAffinitySplitLocationProvider locationProvider = new HostAffinitySplitLocationProvider(executorLocations);
        InputSplit inputSplit1 = this.createMockInputSplit(new String[]{locations.get(0), locations.get(1)});
        InputSplit inputSplit2 = this.createMockInputSplit(new String[]{locations.get(2), locations.get(3)});
        Assert.assertArrayEquals((Object[])new String[]{locations.get(0), locations.get(1)}, (Object[])locationProvider.getLocations(inputSplit1));
        Assert.assertArrayEquals((Object[])new String[]{locations.get(2), locations.get(3)}, (Object[])locationProvider.getLocations(inputSplit2));
    }

    @Test(timeout=5000L)
    public void testOrcSplitsBasic() throws IOException {
        HostAffinitySplitLocationProvider locationProvider = new HostAffinitySplitLocationProvider(executorLocations);
        FileSplit os1 = this.createMockFileSplit(true, "path1", 0L, 1000L, new String[]{locations.get(0), locations.get(1)});
        FileSplit os2 = this.createMockFileSplit(true, "path2", 0L, 2000L, new String[]{locations.get(2), locations.get(3)});
        FileSplit os3 = this.createMockFileSplit(true, "path3", 1000L, 2000L, new String[]{locations.get(0), locations.get(3)});
        String[] retLoc1 = locationProvider.getLocations((InputSplit)os1);
        String[] retLoc2 = locationProvider.getLocations((InputSplit)os2);
        String[] retLoc3 = locationProvider.getLocations((InputSplit)os3);
        Assert.assertEquals((long)1L, (long)retLoc1.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc1[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc1[0]));
        Assert.assertEquals((long)1L, (long)retLoc2.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc2[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc2[0]));
        Assert.assertEquals((long)1L, (long)retLoc3.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc3[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc3[0]));
    }

    @Test(timeout=10000L)
    public void testConsistentHashing() throws IOException {
        int LOC_COUNT = 20;
        int MIN_LOC_COUNT = 4;
        int SPLIT_COUNT = 100;
        List<String> locations = this.createLocations(20);
        FileSplit[] splits = this.createSplits(100);
        StringBuilder failBuilder = new StringBuilder("\n");
        String[] lastLocations = new String[splits.length];
        double movedRatioSum = 0.0;
        double newRatioSum = 0.0;
        double movedRatioWorst = 0.0;
        double newRatioWorst = Double.MAX_VALUE;
        for (int locs = 4; locs <= locations.size(); ++locs) {
            List<String> partLoc = locations.subList(0, locs);
            HostAffinitySplitLocationProvider lp = new HostAffinitySplitLocationProvider(partLoc);
            int moved = 0;
            int newLoc = 0;
            String newNode = partLoc.get(locs - 1);
            for (int splitIx = 0; splitIx < splits.length; ++splitIx) {
                String[] splitLocations = lp.getLocations((InputSplit)splits[splitIx]);
                Assert.assertEquals((long)1L, (long)splitLocations.length);
                String splitLocation = splitLocations[0];
                if (locs > 4 && !splitLocation.equals(lastLocations[splitIx])) {
                    ++moved;
                }
                if (newNode.equals(splitLocation)) {
                    ++newLoc;
                }
                lastLocations[splitIx] = splitLocation;
            }
            if (locs == 4) continue;
            String msgTail = " when going to " + locs + " locations";
            String movedMsg = moved + " splits moved";
            String newMsg = newLoc + " splits went to the new node";
            this.LOG.info(movedMsg + " and " + newMsg + msgTail);
            double maxMoved = 1.0f * (float)splits.length / (float)locs;
            double minNew = 1.0f * (float)splits.length / (float)locs;
            movedRatioSum += (double)moved / maxMoved;
            movedRatioWorst = Math.max((double)moved / maxMoved, movedRatioWorst);
            newRatioSum += (double)newLoc / minNew;
            newRatioWorst = Math.min((double)newLoc / minNew, newRatioWorst);
            this.logBadRatios(failBuilder, moved, newLoc, msgTail, movedMsg, newMsg, maxMoved, minNew);
        }
        int count = locations.size() - 4;
        double moveRatioAvg = movedRatioSum / (double)count;
        double newRatioAvg = newRatioSum / (double)count;
        String errorMsg = "Move counts: average " + moveRatioAvg + ", worst " + movedRatioWorst + "; assigned to new node: average " + newRatioAvg + ", worst " + newRatioWorst;
        this.LOG.info(errorMsg);
        if (moveRatioAvg > (double)1.2f || newRatioAvg < (double)0.8f || movedRatioWorst > (double)1.67f || newRatioWorst < 0.5) {
            Assert.fail((String)(errorMsg + "; example failures: " + failBuilder.toString()));
        }
    }

    public FileSplit[] createSplits(int splitCount) throws IOException {
        FileSplit[] splits = new FileSplit[splitCount];
        for (int i = 0; i < splits.length; ++i) {
            splits[i] = this.createMockFileSplit(true, "path" + i, 0L, 1000L, new String[0]);
        }
        return splits;
    }

    public List<String> createLocations(int locCount) {
        ArrayList<String> locations = new ArrayList<String>(locCount);
        for (int i = 0; i < locCount; ++i) {
            locations.add(String.valueOf(i));
        }
        return locations;
    }

    @Test(timeout=20000L)
    public void testConsistentHashingFallback() throws IOException {
        int LOC_COUNT_TO = 20;
        int SPLIT_COUNT = 500;
        int MAX_MISS_COUNT = 4;
        int LOC_COUNT_FROM = 5;
        FileSplit[] splits = this.createSplits(500);
        AtomicInteger errorCount = new AtomicInteger(0);
        int cvErrorCount = 0;
        for (int locs = 5; locs <= 20; ++locs) {
            int aboveAvgCount = 0;
            double sum = 0.0;
            double[] cvs = new double[5];
            for (int missCount = 0; missCount <= 4; ++missCount) {
                double cv = cvs[missCount] = this.testHashDistribution(locs, missCount, splits, errorCount);
                sum += cv;
                if (missCount <= 0 || !(cv > sum / (double)(missCount + 1))) continue;
                ++aboveAvgCount;
            }
            if (aboveAvgCount <= 2) continue;
            this.LOG.info("CVs for " + locs + " locations aren't to our liking: " + Arrays.toString(cvs));
            ++cvErrorCount;
        }
        Assert.assertTrue((String)("Found " + errorCount.get() + " abnormalities"), (errorCount.get() < 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Found " + cvErrorCount + " abnormalities"), (cvErrorCount < 7 ? 1 : 0) != 0);
    }

    private double testHashDistribution(int locs, final int missCount, FileSplit[] splits, AtomicInteger errorCount) {
        List partLocs = (List)Mockito.mock(List.class);
        Mockito.when((Object)partLocs.size()).thenReturn((Object)locs);
        final AtomicInteger state = new AtomicInteger(0);
        Mockito.when((Object)((String)partLocs.get(Mockito.anyInt()))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return state.getAndIncrement() == missCount ? "not-null" : null;
            }
        });
        int[] hitCounts = new int[locs];
        for (int splitIx = 0; splitIx < splits.length; ++splitIx) {
            int index;
            state.set(0);
            int n = index = HostAffinitySplitLocationProvider.determineLocation((List)partLocs, (String)splits[splitIx].getPath().toString(), (long)splits[splitIx].getStart(), null);
            hitCounts[n] = hitCounts[n] + 1;
        }
        SummaryStatistics ss = new SummaryStatistics();
        for (int hitCount : hitCounts) {
            ss.addValue((double)hitCount);
        }
        double avg = ss.getSum() / (double)ss.getN();
        double stdev = ss.getStandardDeviation();
        double cv = stdev / avg;
        double allowedMin = avg - 2.5 * stdev;
        double allowedMax = avg + 2.5 * stdev;
        if (allowedMin > ss.getMin() || allowedMax < ss.getMax() || cv > 0.22) {
            this.LOG.info("The distribution for " + locs + " locations, " + missCount + " misses isn't to our liking: avg " + avg + ", stdev " + stdev + ", cv " + cv + ", min " + ss.getMin() + ", max " + ss.getMax());
            errorCount.incrementAndGet();
        }
        return cv;
    }

    private void logBadRatios(StringBuilder failBuilder, int moved, int newLoc, String msgTail, String movedMsg, String newMsg, double maxMoved, double minNew) {
        boolean logged = false;
        if ((double)moved > maxMoved * (double)1.33f) {
            failBuilder.append(movedMsg).append(" (threshold ").append(maxMoved).append(") ");
            logged = true;
        }
        if ((double)newLoc < minNew * 0.75) {
            failBuilder.append(newMsg).append(" (threshold ").append(minNew).append(") ");
            logged = true;
        }
        if (logged) {
            failBuilder.append(msgTail).append(";\n");
        }
    }

    @Test(timeout=5000L)
    public void testOrcSplitsLocationAffinity() throws IOException {
        HostAffinitySplitLocationProvider locationProvider = new HostAffinitySplitLocationProvider(executorLocations);
        FileSplit os11 = this.createMockFileSplit(true, "path1", 0L, 15000L, new String[]{locations.get(0), locations.get(1)});
        FileSplit os12 = this.createMockFileSplit(true, "path1", 0L, 30000L, new String[]{locations.get(0), locations.get(1)});
        FileSplit os13 = this.createMockFileSplit(true, "path1", 15000L, 30000L, new String[]{locations.get(0), locations.get(1)});
        Object[] retLoc11 = locationProvider.getLocations((InputSplit)os11);
        Object[] retLoc12 = locationProvider.getLocations((InputSplit)os12);
        Object[] retLoc13 = locationProvider.getLocations((InputSplit)os13);
        Assert.assertEquals((long)1L, (long)retLoc11.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc11[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc11[0]));
        Assert.assertEquals((long)1L, (long)retLoc12.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc12[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc12[0]));
        Assert.assertEquals((long)1L, (long)retLoc13.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc13[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc13[0]));
        Assert.assertEquals((Object)retLoc11[0], (Object)retLoc12[0]);
        Assert.assertNotEquals((Object)retLoc11[0], (Object)retLoc13[0]);
        Object[] retLoc112 = locationProvider.getLocations((InputSplit)os11);
        Object[] retLoc122 = locationProvider.getLocations((InputSplit)os12);
        Object[] retLoc132 = locationProvider.getLocations((InputSplit)os13);
        Assert.assertArrayEquals((Object[])retLoc11, (Object[])retLoc112);
        Assert.assertArrayEquals((Object[])retLoc12, (Object[])retLoc122);
        Assert.assertArrayEquals((Object[])retLoc13, (Object[])retLoc132);
    }

    private InputSplit createMockInputSplit(String[] locations) throws IOException {
        InputSplit inputSplit = (InputSplit)Mockito.mock(InputSplit.class);
        ((InputSplit)Mockito.doReturn((Object)locations).when((Object)inputSplit)).getLocations();
        return inputSplit;
    }

    private FileSplit createMockFileSplit(boolean createOrcSplit, String fakePathString, long start, long length, String[] locations) throws IOException {
        FileSplit fileSplit = createOrcSplit ? (FileSplit)Mockito.mock(OrcSplit.class) : (FileSplit)Mockito.mock(FileSplit.class);
        ((FileSplit)Mockito.doReturn((Object)start).when((Object)fileSplit)).getStart();
        ((FileSplit)Mockito.doReturn((Object)length).when((Object)fileSplit)).getLength();
        ((FileSplit)Mockito.doReturn((Object)new Path(fakePathString)).when((Object)fileSplit)).getPath();
        ((FileSplit)Mockito.doReturn((Object)locations).when((Object)fileSplit)).getLocations();
        ((FileSplit)Mockito.doReturn((Object)locations).when((Object)fileSplit)).getLocations();
        return fileSplit;
    }

    static {
        int i;
        locations = new ArrayList<String>();
        locationsSet = new HashSet<String>();
        executorLocations = new ArrayList<String>();
        executorLocationsSet = new HashSet<String>();
        for (i = 0; i < 5; ++i) {
            locations.add("location" + i);
            locationsSet.add(locations.get(i));
        }
        for (i = 0; i < 9; ++i) {
            executorLocations.add("execLocation" + i);
            executorLocationsSet.add(executorLocations.get(i));
        }
    }
}

