/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.stats.StatsUtils;

public class LineageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<DependencyKey, Dependency> index = Collections.synchronizedMap(new LinkedHashMap());

    public Dependency getDependency(DataContainer dc, FieldSchema col) {
        return this.index.get(new DependencyKey(dc, col));
    }

    public void putDependency(DataContainer dc, FieldSchema col, Dependency dep) {
        this.index.put(new DependencyKey(dc, col), dep);
    }

    public Set<Map.Entry<DependencyKey, Dependency>> entrySet() {
        return this.index.entrySet();
    }

    public void clear() {
        this.index.clear();
    }

    public static class Predicate
    implements Serializable {
        private String expr;
        private Set<BaseColumnInfo> baseCols = new LinkedHashSet<BaseColumnInfo>();

        public String getExpr() {
            return this.expr;
        }

        public void setExpr(String expr) {
            this.expr = expr;
        }

        public Set<BaseColumnInfo> getBaseCols() {
            return this.baseCols;
        }

        public int hashCode() {
            return this.baseCols.hashCode() + (this.expr != null ? this.expr.hashCode() : 11);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Predicate)) {
                return false;
            }
            Predicate cond = (Predicate)obj;
            return StringUtils.equals((String)cond.expr, (String)this.expr) && SetUtils.isEqualSet(cond.baseCols, this.baseCols);
        }
    }

    public static class Dependency
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DependencyType type;
        private String expr;
        private Set<BaseColumnInfo> baseCols;

        public DependencyType getType() {
            return this.type;
        }

        public void setType(DependencyType type) {
            this.type = type;
        }

        public String getExpr() {
            return this.expr;
        }

        public void setExpr(String expr) {
            this.expr = StringInternUtils.internIfNotNull((String)expr);
        }

        public Set<BaseColumnInfo> getBaseCols() {
            return this.baseCols;
        }

        public void setBaseCols(Set<BaseColumnInfo> baseCols) {
            this.baseCols = baseCols;
        }

        public String toString() {
            return "[" + this.type + "]" + this.baseCols;
        }
    }

    public static class TableAliasInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String alias;
        private Table table;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Table getTable() {
            return this.table;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public String toString() {
            return Warehouse.getQualifiedName((Table)this.table) + "(" + this.alias + ")";
        }

        public int hashCode() {
            return (this.alias != null ? this.alias.hashCode() : 7) + (this.table != null ? this.table.hashCode() : 11);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TableAliasInfo)) {
                return false;
            }
            TableAliasInfo tabAlias = (TableAliasInfo)obj;
            return StringUtils.equals((String)this.alias, (String)tabAlias.alias) && (this.table == null ? tabAlias.table == null : this.table.equals(tabAlias.table));
        }
    }

    public static class BaseColumnInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private TableAliasInfo tabAlias;
        private FieldSchema column;

        public TableAliasInfo getTabAlias() {
            return this.tabAlias;
        }

        public void setTabAlias(TableAliasInfo tabAlias) {
            this.tabAlias = tabAlias;
        }

        public FieldSchema getColumn() {
            return this.column;
        }

        public void setColumn(FieldSchema column) {
            this.column = column;
        }

        public String toString() {
            return this.tabAlias + ":" + this.column;
        }

        public int hashCode() {
            return (this.column != null ? this.column.hashCode() : 7) + (this.tabAlias != null ? this.tabAlias.hashCode() : 11);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseColumnInfo)) {
                return false;
            }
            BaseColumnInfo ci = (BaseColumnInfo)obj;
            return (this.column == null ? ci.column == null : this.column.equals(ci.column)) && (this.tabAlias == null ? ci.tabAlias == null : this.tabAlias.equals(ci.tabAlias));
        }
    }

    public static class DependencyKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DataContainer dc;
        private final FieldSchema fld;

        public DependencyKey(DataContainer dc, FieldSchema fld) {
            this.dc = dc;
            this.fld = fld;
        }

        public DataContainer getDataContainer() {
            return this.dc;
        }

        public FieldSchema getFieldSchema() {
            return this.fld;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dc == null ? 0 : this.dc.hashCode());
            result = 31 * result + (this.fld == null ? 0 : this.fld.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyKey other = (DependencyKey)obj;
            if (this.dc != other.dc) {
                return false;
            }
            return this.fld == other.fld;
        }

        public String toString() {
            return this.dc + ":" + this.fld;
        }
    }

    public static class DataContainer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Table tab;
        private final Partition part;

        public DataContainer(Table tab) {
            this.tab = tab;
            this.part = null;
        }

        public DataContainer(Table tab, Partition part) {
            this.tab = tab;
            this.part = part;
        }

        public boolean isPartition() {
            return this.part != null;
        }

        public Table getTable() {
            return this.tab;
        }

        public Partition getPartition() {
            return this.part;
        }

        public String toString() {
            return this.isPartition() ? StatsUtils.getFullyQualifiedTableName(this.part.getDbName(), this.part.getTableName()) + "@" + this.part.getValues() : Warehouse.getQualifiedName((Table)this.tab);
        }
    }

    public static enum DependencyType {
        SIMPLE,
        EXPRESSION,
        SCRIPT;

    }
}

