/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SparkJobMonitor {
    protected static final String CLASS_NAME = SparkJobMonitor.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected final transient SessionState.LogHelper console;
    protected final PerfLogger perfLogger = SessionState.getPerfLogger();
    protected final int checkInterval = 1000;
    protected final long monitorTimeoutInterval;
    private final Set<String> completed = new HashSet<String>();
    private final int printInterval = 3000;
    private long lastPrintTime;
    protected long startTime;
    protected final boolean inPlaceUpdate;
    private int lines = 0;
    private final PrintStream out;
    private static final int COLUMN_1_WIDTH = 16;
    private static final String HEADER_FORMAT = "%16s%10s %13s  %5s  %9s  %7s  %7s  %6s  ";
    private static final String STAGE_FORMAT = "%-16s%10s %13s  %5s  %9s  %7s  %7s  %6s  ";
    private static final String HEADER = String.format("%16s%10s %13s  %5s  %9s  %7s  %7s  %6s  ", "STAGES", "ATTEMPT", "STATUS", "TOTAL", "COMPLETED", "RUNNING", "PENDING", "FAILED");
    private static final int SEPARATOR_WIDTH = 86;
    private static final String SEPARATOR = new String(new char[86]).replace("\u0000", "-");
    private static final String FOOTER_FORMAT = "%-15s  %-30s %-4s  %-25s";
    private static final int progressBarChars = 30;
    private final NumberFormat secondsFormat = new DecimalFormat("#0.00");

    protected SparkJobMonitor(HiveConf hiveConf) {
        this.monitorTimeoutInterval = hiveConf.getTimeVar(HiveConf.ConfVars.SPARK_JOB_MONITOR_TIMEOUT, TimeUnit.SECONDS);
        this.inPlaceUpdate = InPlaceUpdate.canRenderInPlace((HiveConf)hiveConf) && !SessionState.getConsole().getIsSilent();
        this.console = new SessionState.LogHelper(LOG);
        this.out = SessionState.LogHelper.getInfoStream();
    }

    public abstract int startMonitor();

    private void printStatusInPlace(Map<String, SparkStageProgress> progressMap) {
        StringBuilder reportBuffer = new StringBuilder();
        int sumTotal = 0;
        int sumComplete = 0;
        this.repositionCursor();
        this.reprintLine(SEPARATOR);
        this.reprintLineWithColorAsBold(HEADER, Ansi.Color.CYAN);
        this.reprintLine(SEPARATOR);
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        int idx = 0;
        int numKey = keys.size();
        for (String s : keys) {
            int div;
            StageState state;
            SparkStageProgress progress = progressMap.get(s);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskCount();
            sumTotal += total;
            sumComplete += complete;
            StageState stageState = state = total > 0 ? StageState.PENDING : StageState.FINISHED;
            if (complete > 0 || running > 0 || failed > 0) {
                if (!this.perfLogger.startTimeHasMethod("SparkRunStage." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunStage." + s);
                }
                if (complete < total) {
                    state = StageState.RUNNING;
                } else {
                    state = StageState.FINISHED;
                    this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkRunStage." + s);
                    this.completed.add(s);
                }
            }
            String attempt = (div = s.indexOf(95)) > 0 ? s.substring(div + 1) : "-";
            String stageName = "Stage-" + (div > 0 ? s.substring(0, div) : s);
            String nameWithProgress = this.getNameWithProgress(stageName, complete, total);
            int pending = total - complete - running;
            String stageStr = String.format(STAGE_FORMAT, new Object[]{nameWithProgress, attempt, state, total, complete, running, pending, failed});
            reportBuffer.append(stageStr);
            if (idx++ == numKey - 1) continue;
            reportBuffer.append("\n");
        }
        this.reprintMultiLine(reportBuffer.toString());
        this.reprintLine(SEPARATOR);
        float progress = sumTotal == 0 ? 1.0f : (float)sumComplete / (float)sumTotal;
        String footer = this.getFooter(numKey, this.completed.size(), progress, this.startTime);
        this.reprintLineWithColorAsBold(footer, Ansi.Color.RED);
        this.reprintLine(SEPARATOR);
    }

    protected void printStatus(Map<String, SparkStageProgress> progressMap, Map<String, SparkStageProgress> lastProgressMap) {
        boolean withinInterval;
        boolean isDuplicateState = this.isSameAsPreviousProgress(progressMap, lastProgressMap);
        boolean bl = withinInterval = System.currentTimeMillis() <= this.lastPrintTime + 3000L;
        if (isDuplicateState && withinInterval) {
            return;
        }
        String report = this.getReport(progressMap);
        if (this.inPlaceUpdate) {
            this.printStatusInPlace(progressMap);
            this.console.logInfo(report);
        } else {
            this.console.printInfo(report);
        }
        this.lastPrintTime = System.currentTimeMillis();
    }

    protected int getTotalTaskCount(Map<String, SparkStageProgress> progressMap) {
        int totalTasks = 0;
        for (SparkStageProgress progress : progressMap.values()) {
            totalTasks += progress.getTotalTaskCount();
        }
        return totalTasks;
    }

    protected int getStageMaxTaskCount(Map<String, SparkStageProgress> progressMap) {
        int stageMaxTasks = 0;
        for (SparkStageProgress progress : progressMap.values()) {
            int tasks = progress.getTotalTaskCount();
            if (tasks <= stageMaxTasks) continue;
            stageMaxTasks = tasks;
        }
        return stageMaxTasks;
    }

    private String getReport(Map<String, SparkStageProgress> progressMap) {
        StringBuilder reportBuffer = new StringBuilder();
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        String currentDate = dt.format(new Date());
        reportBuffer.append(currentDate + "\t");
        int sumTotal = 0;
        int sumComplete = 0;
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        for (String s : keys) {
            SparkStageProgress progress = progressMap.get(s);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskCount();
            sumTotal += total;
            sumComplete += complete;
            String stageName = "Stage-" + s;
            if (total <= 0) {
                reportBuffer.append(String.format("%s: -/-\t", stageName));
                continue;
            }
            if (complete == total && !this.completed.contains(s)) {
                this.completed.add(s);
                if (!this.perfLogger.startTimeHasMethod("SparkRunStage." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunStage." + s);
                }
                this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkRunStage." + s);
            }
            if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                if (!this.perfLogger.startTimeHasMethod("SparkRunStage." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunStage." + s);
                }
                if (failed > 0) {
                    reportBuffer.append(String.format("%s: %d(+%d,-%d)/%d\t", stageName, complete, running, failed, total));
                    continue;
                }
                reportBuffer.append(String.format("%s: %d(+%d)/%d\t", stageName, complete, running, total));
                continue;
            }
            if (failed > 0) {
                reportBuffer.append(String.format("%s: %d(-%d)/%d Finished with failed tasks\t", stageName, complete, failed, total));
                continue;
            }
            if (complete == total) {
                reportBuffer.append(String.format("%s: %d/%d Finished\t", stageName, complete, total));
                continue;
            }
            reportBuffer.append(String.format("%s: %d/%d\t", stageName, complete, total));
        }
        if (SessionState.get() != null) {
            float progress = sumTotal == 0 ? 1.0f : (float)sumComplete / (float)sumTotal;
            SessionState.get().updateProgressedPercentage(progress);
        }
        return reportBuffer.toString();
    }

    private boolean isSameAsPreviousProgress(Map<String, SparkStageProgress> progressMap, Map<String, SparkStageProgress> lastProgressMap) {
        if (lastProgressMap == null) {
            return false;
        }
        if (progressMap.isEmpty()) {
            return lastProgressMap.isEmpty();
        }
        if (lastProgressMap.isEmpty()) {
            return false;
        }
        if (progressMap.size() != lastProgressMap.size()) {
            return false;
        }
        for (String key : progressMap.keySet()) {
            if (lastProgressMap.containsKey(key) && progressMap.get(key).equals(lastProgressMap.get(key))) continue;
            return false;
        }
        return true;
    }

    private void repositionCursor() {
        if (this.lines > 0) {
            this.out.print(Ansi.ansi().cursorUp(this.lines).toString());
            this.out.flush();
            this.lines = 0;
        }
    }

    private void reprintLine(String line) {
        InPlaceUpdate.reprintLine((PrintStream)this.out, (String)line);
        ++this.lines;
    }

    private void reprintLineWithColorAsBold(String line, Ansi.Color color) {
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).fg(color).bold().a(line).a('\n').boldOff().reset().toString());
        this.out.flush();
        ++this.lines;
    }

    private String getNameWithProgress(String s, int complete, int total) {
        Object result = "";
        if (s != null) {
            float percent = total == 0 ? 1.0f : (float)complete / (float)total;
            int spaceRemaining = 16 - s.length() - 1;
            String trimmedVName = s;
            if (s.length() > 16) {
                trimmedVName = s.substring(0, 14);
                result = trimmedVName + "..";
            } else {
                result = trimmedVName + " ";
            }
            int toFill = (int)((float)spaceRemaining * percent);
            for (int i = 0; i < toFill; ++i) {
                result = (String)result + ".";
            }
        }
        return result;
    }

    private String getFooter(int keySize, int completedSize, float progress, long startTime) {
        String verticesSummary = String.format("STAGES: %02d/%02d", completedSize, keySize);
        String progressBar = this.getInPlaceProgressBar(progress);
        int progressPercent = (int)(progress * 100.0f);
        String progressStr = progressPercent + "%";
        float et = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        String elapsedTime = "ELAPSED TIME: " + this.secondsFormat.format(et) + " s";
        String footer = String.format(FOOTER_FORMAT, verticesSummary, progressBar, progressStr, elapsedTime);
        return footer;
    }

    private String getInPlaceProgressBar(float percent) {
        int i;
        StringBuilder bar = new StringBuilder("[");
        int remainingChars = 26;
        int completed = (int)((float)remainingChars * percent);
        int pending = remainingChars - completed;
        for (i = 0; i < completed; ++i) {
            bar.append("=");
        }
        bar.append(">>");
        for (i = 0; i < pending; ++i) {
            bar.append("-");
        }
        bar.append("]");
        return bar.toString();
    }

    private void reprintMultiLine(String line) {
        int numLines = line.split("\r\n|\r|\n").length;
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        this.out.flush();
        this.lines += numLines;
    }

    protected static enum StageState {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

