/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udaf;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udaf.TestStreamingSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Test;

public class TestStreamingAvg {
    public void avgDouble(Iterator<Double> inVals, int inSz, int numPreceding, int numFollowing, Iterator<Double> outVals) throws HiveException {
        GenericUDAFAverage fnR = new GenericUDAFAverage();
        TypeInfo[] inputTypes = new TypeInfo[]{TypeInfoFactory.doubleTypeInfo};
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector};
        DoubleWritable[] in = new DoubleWritable[]{new DoubleWritable()};
        TestStreamingSum._agg((GenericUDAFResolver)fnR, inputTypes, inVals, TestStreamingSum.TypeHandler.DoubleHandler, in, inputOIs, inSz, numPreceding, numFollowing, outVals);
    }

    public void avgHiveDecimal(Iterator<HiveDecimal> inVals, int inSz, int numPreceding, int numFollowing, Iterator<HiveDecimal> outVals) throws HiveException {
        GenericUDAFAverage fnR = new GenericUDAFAverage();
        TypeInfo[] inputTypes = new TypeInfo[]{TypeInfoFactory.decimalTypeInfo};
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector};
        HiveDecimalWritable[] in = new HiveDecimalWritable[]{new HiveDecimalWritable()};
        TestStreamingSum._agg((GenericUDAFResolver)fnR, inputTypes, inVals, TestStreamingSum.TypeHandler.HiveDecimalHandler, in, inputOIs, inSz, numPreceding, numFollowing, outVals);
    }

    @Test
    public void testDouble_3_4() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(3.0, 3.5, 4.0, 4.5, 5.5, 6.5, 7.0, 7.5, 8.0, 8.5);
        this.avgDouble(inVals.iterator(), 10, 3, 4, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_3_4() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((BigDecimal)new BigDecimal(3.0)), HiveDecimal.create((BigDecimal)new BigDecimal(3.5)), HiveDecimal.create((BigDecimal)new BigDecimal(4.0)), HiveDecimal.create((BigDecimal)new BigDecimal(4.5)), HiveDecimal.create((BigDecimal)new BigDecimal(5.5)), HiveDecimal.create((BigDecimal)new BigDecimal(6.5)), HiveDecimal.create((BigDecimal)new BigDecimal(7.0)), HiveDecimal.create((BigDecimal)new BigDecimal(7.5)), HiveDecimal.create((BigDecimal)new BigDecimal(8.0)), HiveDecimal.create((BigDecimal)new BigDecimal(8.5)));
        this.avgHiveDecimal(inVals.iterator(), 10, 3, 4, outVals.iterator());
    }

    @Test
    public void testDouble_3_0() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(1.0, 1.5, 2.0, 2.5, 3.5, 4.5, 5.5, 6.5, 7.5, 8.5);
        this.avgDouble(inVals.iterator(), 10, 3, 0, outVals.iterator());
    }

    @Test
    public void testDouble_unb_0() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5);
        this.avgDouble(inVals.iterator(), 10, Integer.MAX_VALUE, 0, outVals.iterator());
    }

    @Test
    public void testDouble_0_5() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(3.5, 4.5, 5.5, 6.5, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0);
        this.avgDouble(inVals.iterator(), 10, 0, 5, outVals.iterator());
    }

    @Test
    public void testDouble_unb_5() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(3.5, 4.0, 4.5, 5.0, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5);
        this.avgDouble(inVals.iterator(), 10, Integer.MAX_VALUE, 5, outVals.iterator());
    }

    @Test
    public void testDouble_7_2() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5);
        this.avgDouble(inVals.iterator(), 10, 7, 2, outVals.iterator());
    }

    @Test
    public void testDouble_15_15() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5);
        this.avgDouble(inVals.iterator(), 10, 15, 15, outVals.iterator());
    }
}

