/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FakeVectorRowBatchFromObjectIterables
extends FakeVectorRowBatchBase {
    private final String[] types;
    private final List<Iterator<Object>> iterators;
    private final VectorizedRowBatch batch;
    private boolean eof;
    private final int batchSize;
    private final ColumnVectorAssign[] columnAssign;

    public String[] getTypes() {
        return this.types;
    }

    public FakeVectorRowBatchFromObjectIterables(int batchSize, String[] types, Iterable<Object> ... iterables) throws HiveException {
        this.types = types;
        this.batchSize = batchSize;
        this.iterators = new ArrayList<Iterator<Object>>(types.length);
        this.columnAssign = new ColumnVectorAssign[types.length];
        this.batch = new VectorizedRowBatch(types.length, batchSize);
        for (int i = 0; i < types.length; ++i) {
            if (types[i].equalsIgnoreCase("tinyint") || types[i].equalsIgnoreCase("smallint") || types[i].equalsIgnoreCase("int") || types[i].equalsIgnoreCase("bigint") || types[i].equalsIgnoreCase("long")) {
                this.batch.cols[i] = new LongColumnVector(batchSize);
                this.columnAssign[i] = new ColumnVectorAssign(){

                    @Override
                    public void assign(ColumnVector columnVector, int row, Object value) {
                        LongColumnVector lcv = (LongColumnVector)columnVector;
                        lcv.vector[row] = Long.valueOf(value.toString());
                    }
                };
            } else if (types[i].equalsIgnoreCase("boolean")) {
                this.batch.cols[i] = new LongColumnVector(batchSize);
                this.columnAssign[i] = new ColumnVectorAssign(){

                    @Override
                    public void assign(ColumnVector columnVector, int row, Object value) {
                        LongColumnVector lcv = (LongColumnVector)columnVector;
                        lcv.vector[row] = (Boolean)value != false ? 1L : 0L;
                    }
                };
            } else if (types[i].equalsIgnoreCase("timestamp")) {
                this.batch.cols[i] = new TimestampColumnVector(batchSize);
                this.columnAssign[i] = new ColumnVectorAssign(){

                    @Override
                    public void assign(ColumnVector columnVector, int row, Object value) {
                        TimestampColumnVector lcv = (TimestampColumnVector)columnVector;
                        Timestamp t = (Timestamp)value;
                        lcv.set(row, t);
                    }
                };
            } else if (types[i].equalsIgnoreCase("string")) {
                this.batch.cols[i] = new BytesColumnVector(batchSize);
                this.columnAssign[i] = new ColumnVectorAssign(){

                    @Override
                    public void assign(ColumnVector columnVector, int row, Object value) {
                        BytesColumnVector bcv = (BytesColumnVector)columnVector;
                        String s = (String)value;
                        byte[] bytes = s.getBytes();
                        bcv.vector[row] = bytes;
                        bcv.start[row] = 0;
                        bcv.length[row] = bytes.length;
                    }
                };
            } else if (types[i].equalsIgnoreCase("double") || types[i].equalsIgnoreCase("float")) {
                this.batch.cols[i] = new DoubleColumnVector(batchSize);
                this.columnAssign[i] = new ColumnVectorAssign(){

                    @Override
                    public void assign(ColumnVector columnVector, int row, Object value) {
                        DoubleColumnVector dcv = (DoubleColumnVector)columnVector;
                        dcv.vector[row] = Double.valueOf(value.toString());
                    }
                };
            } else if (types[i].toLowerCase().startsWith("decimal")) {
                Pattern decimalPattern = Pattern.compile("decimal(?:\\((\\d+)(?:\\,(\\d+))?\\))?", 2);
                Matcher mr = decimalPattern.matcher(types[i]);
                int precission = 38;
                int scale = 0;
                if (mr.matches()) {
                    String typeScale;
                    String typePrecission = mr.group(1);
                    if (typePrecission != null) {
                        precission = Integer.parseInt(typePrecission);
                    }
                    if ((typeScale = mr.group(2)) != null) {
                        scale = Integer.parseInt(typeScale);
                    }
                }
                this.batch.cols[i] = new DecimalColumnVector(batchSize, precission, scale);
                this.columnAssign[i] = new ColumnVectorAssign(){

                    @Override
                    public void assign(ColumnVector columnVector, int row, Object value) {
                        DecimalColumnVector dcv = (DecimalColumnVector)columnVector;
                        dcv.set(row, (HiveDecimal)value);
                    }
                };
            } else {
                throw new HiveException("Unimplemented type " + types[i]);
            }
            this.iterators.add(iterables[i].iterator());
        }
    }

    @Override
    public VectorizedRowBatch produceNextBatch() {
        this.batch.size = 0;
        this.batch.selectedInUse = false;
        for (int i = 0; i < this.types.length; ++i) {
            ColumnVector col = this.batch.cols[i];
            col.noNulls = true;
            col.isRepeating = false;
        }
        while (!this.eof && this.batch.size < this.batchSize) {
            int r = this.batch.size;
            for (int i = 0; i < this.types.length; ++i) {
                Iterator<Object> it = this.iterators.get(i);
                if (!it.hasNext()) {
                    this.eof = true;
                    break;
                }
                Object value = it.next();
                if (null == value) {
                    this.batch.cols[i].isNull[this.batch.size] = true;
                    this.batch.cols[i].noNulls = false;
                    continue;
                }
                this.batch.cols[i].isNull[this.batch.size] = false;
                this.columnAssign[i].assign(this.batch.cols[i], this.batch.size, value);
            }
            if (this.eof) continue;
            ++this.batch.size;
        }
        return this.batch;
    }

    private static interface ColumnVectorAssign {
        public void assign(ColumnVector var1, int var2, Object var3);
    }
}

