/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomByteArrayStream {
    private Random random;
    private int min;
    private List<byte[]> byteArrays;

    public RandomByteArrayStream(Random random) {
        this.random = random;
        this.byteArrays = new ArrayList<byte[]>();
        this.min = 1;
    }

    public RandomByteArrayStream(Random random, int min) {
        this.random = random;
        this.byteArrays = new ArrayList<byte[]>();
        this.min = min;
    }

    public byte[] next() {
        int category = this.random.nextInt(100);
        int count = 0;
        if (category < 98) {
            count = this.min + this.random.nextInt(10);
        } else {
            switch (category - 98) {
                case 0: {
                    count = Math.max(this.min, 10) + this.random.nextInt(90);
                    break;
                }
                case 1: {
                    count = Math.max(this.min, 100) + this.random.nextInt(900);
                }
            }
        }
        byte[] bytes = new byte[count];
        this.random.nextBytes(bytes);
        this.byteArrays.add(bytes);
        return bytes;
    }

    public int size() {
        return this.byteArrays.size();
    }

    public byte[] get(int i) {
        return this.byteArrays.get(i);
    }

    public boolean contains(byte[] bytes) {
        int length = bytes.length;
        for (int i = 0; i < this.byteArrays.size(); ++i) {
            byte[] streamBytes = this.byteArrays.get(i);
            if (streamBytes.length != length) continue;
            boolean match = true;
            for (int j = 0; j < length; ++j) {
                if (streamBytes[j] == bytes[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }
}

