/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.GenTezWork;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGenTezWork {
    GenTezProcContext ctx;
    GenTezWork proc;
    ReduceSinkOperator rs;
    FileSinkOperator fs;
    TableScanOperator ts;

    @Before
    public void setUp() throws Exception {
        HiveConf conf = new HiveConf(SemanticAnalyzer.class);
        conf.set("fs.defaultFS", "file:///");
        SessionState.start((HiveConf)conf);
        ParseContext pctx = new ParseContext();
        pctx.setContext(new Context((Configuration)conf));
        this.ctx = new GenTezProcContext(conf, pctx, Collections.EMPTY_LIST, new ArrayList(), Collections.EMPTY_SET, Collections.EMPTY_SET);
        this.proc = new GenTezWork(new GenTezUtils(){

            protected void setupMapWork(MapWork mapWork, GenTezProcContext context, PrunedPartitionList partitions, TableScanOperator root, String alias) throws SemanticException {
                LinkedHashMap<String, TableScanOperator> map = new LinkedHashMap<String, TableScanOperator>();
                map.put("foo", root);
                mapWork.setAliasToWork(map);
            }
        });
        CompilationOpContext cCtx = new CompilationOpContext();
        this.fs = new FileSinkOperator(cCtx);
        this.fs.setConf((OperatorDesc)new FileSinkDesc());
        this.rs = new ReduceSinkOperator(cCtx);
        this.rs.setConf((OperatorDesc)new ReduceSinkDesc());
        TableDesc tableDesc = new TableDesc();
        tableDesc.setProperties(new Properties());
        ((ReduceSinkDesc)this.rs.getConf()).setKeySerializeInfo(tableDesc);
        this.ts = new TableScanOperator(cCtx);
        this.ts.setConf((OperatorDesc)new TableScanDesc(null));
        this.ts.getChildOperators().add(this.rs);
        this.rs.getParentOperators().add(this.ts);
        this.rs.getChildOperators().add(this.fs);
        this.fs.getParentOperators().add(this.rs);
        this.ctx.preceedingWork = null;
        this.ctx.currentRootOperator = this.ts;
    }

    @After
    public void tearDown() throws Exception {
        this.ctx = null;
        this.proc = null;
        this.ts = null;
        this.rs = null;
        this.fs = null;
    }

    @Test
    public void testCreateMap() throws SemanticException {
        this.proc.process((Node)this.rs, null, (NodeProcessorCtx)this.ctx, (Object[])null);
        Assert.assertNotNull((Object)this.ctx.currentTask);
        Assert.assertTrue((boolean)this.ctx.rootTasks.contains(this.ctx.currentTask));
        TezWork work = (TezWork)this.ctx.currentTask.getWork();
        Assert.assertEquals((long)work.getAllWork().size(), (long)1L);
        BaseWork w = (BaseWork)work.getAllWork().get(0);
        Assert.assertTrue((boolean)(w instanceof MapWork));
        MapWork mw = (MapWork)w;
        Assert.assertNotNull((Object)w.getName());
        Assert.assertSame(mw.getAliasToWork().entrySet().iterator().next().getValue(), (Object)this.ts);
        Assert.assertSame((Object)this.ctx.preceedingWork, (Object)mw);
        Assert.assertSame((Object)this.ctx.currentRootOperator, (Object)this.fs);
    }

    @Test
    public void testCreateReduce() throws SemanticException {
        this.proc.process((Node)this.rs, null, (NodeProcessorCtx)this.ctx, (Object[])null);
        this.proc.process((Node)this.fs, null, (NodeProcessorCtx)this.ctx, (Object[])null);
        TezWork work = (TezWork)this.ctx.currentTask.getWork();
        Assert.assertEquals((long)work.getAllWork().size(), (long)2L);
        BaseWork w = (BaseWork)work.getAllWork().get(1);
        Assert.assertTrue((boolean)(w instanceof ReduceWork));
        Assert.assertTrue((boolean)work.getParents(w).contains(work.getAllWork().get(0)));
        ReduceWork rw = (ReduceWork)w;
        Assert.assertNotNull((Object)w.getName());
        Assert.assertSame((Object)rw.getReducer(), (Object)this.fs);
        Assert.assertEquals((long)this.fs.getParentOperators().size(), (long)0L);
    }
}

