/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprTimestampColumnColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int arg1Column;
    private final int arg2Column;
    private final int arg3Column;

    public IfExprTimestampColumnColumn(int arg1Column, int arg2Column, int arg3Column, int outputColumnNum) {
        super(outputColumnNum);
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Column = arg3Column;
    }

    public IfExprTimestampColumnColumn() {
        this.arg1Column = -1;
        this.arg2Column = -1;
        this.arg3Column = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        TimestampColumnVector arg2ColVector = (TimestampColumnVector)batch.cols[this.arg2Column];
        boolean[] arg2IsNull = arg2ColVector.isNull;
        TimestampColumnVector arg3ColVector = (TimestampColumnVector)batch.cols[this.arg3Column];
        boolean[] arg3IsNull = arg3ColVector.isNull;
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        if (!arg2IsNull[i]) {
                            outputIsNull[i] = false;
                            outputColVector.set(i, arg2ColVector.asScratchTimestamp(i));
                            continue;
                        }
                        outputIsNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    if (!arg3IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg3ColVector.asScratchTimestamp(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        if (!arg2IsNull[i]) {
                            outputIsNull[i] = false;
                            outputColVector.set(i, arg2ColVector.asScratchTimestamp(i));
                            continue;
                        }
                        outputIsNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    if (!arg3IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg3ColVector.asScratchTimestamp(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg2ColVector.asScratchTimestamp(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                if (!arg3IsNull[i]) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, arg3ColVector.asScratchTimestamp(i));
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg2ColVector.asScratchTimestamp(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                if (!arg3IsNull[i]) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, arg3ColVector.asScratchTimestamp(i));
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
        arg2ColVector.unFlatten();
        arg3ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", " + this.getColumnParamString(1, this.arg2Column) + this.getColumnParamString(2, this.arg3Column);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("int_family"), VectorExpressionDescriptor.ArgumentType.getType("timestamp"), VectorExpressionDescriptor.ArgumentType.getType("timestamp")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

