/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserPoolMapping {
    private static final Logger LOG = LoggerFactory.getLogger(UserPoolMapping.class);
    private final Map<String, Mapping> userMappings = new HashMap<String, Mapping>();
    private final Map<String, Mapping> groupMappings = new HashMap<String, Mapping>();
    private final Map<String, Mapping> appMappings = new HashMap<String, Mapping>();
    private final String defaultPoolPath;

    public UserPoolMapping(List<WMMapping> mappings, String defaultPoolPath) {
        if (mappings != null) {
            block5: for (WMMapping mapping : mappings) {
                MappingType type = MappingType.valueOf(mapping.getEntityType().toUpperCase());
                switch (type) {
                    case USER: {
                        UserPoolMapping.addMapping(mapping, this.userMappings, "user");
                        continue block5;
                    }
                    case GROUP: {
                        UserPoolMapping.addMapping(mapping, this.groupMappings, "group");
                        continue block5;
                    }
                    case APPLICATION: {
                        UserPoolMapping.addMapping(mapping, this.appMappings, "application");
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unknown type " + type));
            }
        }
        this.defaultPoolPath = defaultPoolPath;
    }

    private static void addMapping(WMMapping mapping, Map<String, Mapping> map, String text) {
        Mapping val = new Mapping(mapping.getPoolPath(), mapping.getOrdering());
        Mapping oldValue = map.put(mapping.getEntityName(), val);
        if (oldValue != null) {
            throw new AssertionError((Object)("Duplicate mapping for " + text + " " + mapping.getEntityName() + "; " + oldValue + " and " + val));
        }
    }

    public String mapSessionToPoolName(MappingInput input, boolean allowAnyPool, Set<String> pools) {
        if (allowAnyPool && input.wmPool != null) {
            return pools == null || pools.contains(input.wmPool) ? input.wmPool : null;
        }
        Mapping mapping = this.userMappings.get(input.getUserName());
        boolean isExplicitMatch = false;
        if (mapping != null && (isExplicitMatch = UserPoolMapping.isExplicitPoolMatch(input, mapping))) {
            return mapping.fullPoolName;
        }
        if (mapping == null && input.getAppName() != null) {
            mapping = this.appMappings.get(input.getAppName());
        }
        for (String group : input.getGroups()) {
            Mapping candidate = this.groupMappings.get(group);
            if (candidate == null) continue;
            isExplicitMatch = UserPoolMapping.isExplicitPoolMatch(input, candidate);
            if (isExplicitMatch) {
                return candidate.fullPoolName;
            }
            if (mapping != null && candidate.priority >= mapping.priority) continue;
            mapping = candidate;
        }
        if (input.wmPool != null && !isExplicitMatch) {
            return null;
        }
        if (mapping != null) {
            return mapping.fullPoolName;
        }
        return this.defaultPoolPath;
    }

    private static boolean isExplicitPoolMatch(MappingInput input, Mapping mapping) {
        return input.wmPool != null && input.wmPool.equals(mapping.fullPoolName);
    }

    public static final class MappingInput {
        private final String userName;
        private final String wmPool;
        private final String appName;
        private final List<String> groups;

        public MappingInput(String userName, List<String> groups, String wmPool, String appName) {
            this.userName = userName;
            this.groups = groups;
            this.appName = appName;
            this.wmPool = wmPool;
        }

        public List<String> getGroups() {
            return this.groups == null ? Lists.newArrayList() : this.groups;
        }

        private String getUserName() {
            return this.userName;
        }

        public String toString() {
            return "{" + this.userName + "; app " + this.appName + "; pool " + this.wmPool + "; groups " + this.groups + "}";
        }

        public String getAppName() {
            return this.appName;
        }
    }

    private static final class Mapping {
        int priority;
        String fullPoolName;

        public Mapping(String poolName, int priority) {
            this.fullPoolName = poolName;
            this.priority = priority;
        }

        public String toString() {
            return "[" + (this.fullPoolName == null ? "unmanaged" : this.fullPoolName) + ", priority=" + this.priority + "]";
        }
    }

    public static enum MappingType {
        USER,
        GROUP,
        APPLICATION;

    }
}

