/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;

class CreateDatabaseHandler
extends AbstractEventHandler {
    CreateDatabaseHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} CREATE_DATABASE message : {}", (Object)this.fromEventId(), (Object)this.event.getMessage());
        CreateDatabaseMessage createDatabaseMsg = this.deserializer.getCreateDatabaseMessage(this.event.getMessage());
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        FileSystem fileSystem = metaDataPath.getFileSystem((Configuration)withinContext.hiveConf);
        EximUtil.createDbExportDump(fileSystem, metaDataPath, createDatabaseMsg.getDatabaseObject(), withinContext.replicationSpec);
        withinContext.createDmd(this).write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_CREATE_DATABASE;
    }
}

