/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.net.NetUtils;

public final class JobTrackerURLResolver {
    public static String getURL(JobConf conf) throws IOException {
        String infoAddr = ShimLoader.getHadoopShims().getJobLauncherHttpAddress((Configuration)conf);
        if (infoAddr == null) {
            throw new IOException("Unable to find job tracker info port.");
        }
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)infoAddr);
        int infoPort = infoSocAddr.getPort();
        String jobTrackerStr = ShimLoader.getHadoopShims().getJobLauncherRpcAddress((Configuration)conf);
        InetSocketAddress jobTrackerSocAddr = NetUtils.createSocketAddr((String)jobTrackerStr);
        String tracker = "http://" + jobTrackerSocAddr.getHostName() + ":" + infoPort;
        return tracker;
    }

    private JobTrackerURLResolver() {
    }
}

