/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.com.zaxxer.hikari.metrics.dropwizard;

import java.util.concurrent.TimeUnit;
import org.apache.hive.com.codahale.metrics.Gauge;
import org.apache.hive.com.codahale.metrics.Histogram;
import org.apache.hive.com.codahale.metrics.Meter;
import org.apache.hive.com.codahale.metrics.MetricRegistry;
import org.apache.hive.com.codahale.metrics.Timer;
import org.apache.hive.com.zaxxer.hikari.metrics.IMetricsTracker;
import org.apache.hive.com.zaxxer.hikari.metrics.PoolStats;

public final class CodaHaleMetricsTracker
implements IMetricsTracker {
    private final String poolName;
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final Histogram connectionCreation;
    private final Meter connectionTimeoutMeter;
    private final MetricRegistry registry;
    private static final String METRIC_CATEGORY = "pool";
    private static final String METRIC_NAME_WAIT = "Wait";
    private static final String METRIC_NAME_USAGE = "Usage";
    private static final String METRIC_NAME_CONNECT = "ConnectionCreation";
    private static final String METRIC_NAME_TIMEOUT_RATE = "ConnectionTimeoutRate";
    private static final String METRIC_NAME_TOTAL_CONNECTIONS = "TotalConnections";
    private static final String METRIC_NAME_IDLE_CONNECTIONS = "IdleConnections";
    private static final String METRIC_NAME_ACTIVE_CONNECTIONS = "ActiveConnections";
    private static final String METRIC_NAME_PENDING_CONNECTIONS = "PendingConnections";

    public CodaHaleMetricsTracker(String poolName, final PoolStats poolStats, MetricRegistry registry) {
        this.poolName = poolName;
        this.registry = registry;
        this.connectionObtainTimer = registry.timer(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_WAIT));
        this.connectionUsage = registry.histogram(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_USAGE));
        this.connectionCreation = registry.histogram(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_CONNECT));
        this.connectionTimeoutMeter = registry.meter(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE));
        registry.register(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return poolStats.getTotalConnections();
            }
        });
        registry.register(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return poolStats.getIdleConnections();
            }
        });
        registry.register(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return poolStats.getActiveConnections();
            }
        });
        registry.register(MetricRegistry.name(poolName, METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return poolStats.getPendingThreads();
            }
        });
    }

    @Override
    public void close() {
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_WAIT));
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_USAGE));
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_CONNECT));
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE));
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS));
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS));
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS));
        this.registry.remove(MetricRegistry.name(this.poolName, METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS));
    }

    @Override
    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.connectionObtainTimer.update(elapsedAcquiredNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.connectionUsage.update(elapsedBorrowedMillis);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutMeter.mark();
    }

    @Override
    public void recordConnectionCreatedMillis(long connectionCreatedMillis) {
        this.connectionCreation.update(connectionCreatedMillis);
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public Histogram getConnectionCreationHistogram() {
        return this.connectionCreation;
    }
}

