/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNullif;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyPrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFNullif {
    @Test
    public void testByteTypeEq() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableByteObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4)), new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.byteTypeInfo, (Object)oi.getTypeInfo());
        ByteWritable res = (ByteWritable)udf.evaluate(args);
        Assert.assertEquals(null, (Object)res);
    }

    @Test
    public void testByteNeq() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableByteObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4)), new GenericUDF.DeferredJavaObject((Object)new ByteWritable(1))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.byteTypeInfo, (Object)oi.getTypeInfo());
        ByteWritable res = (ByteWritable)udf.evaluate(args);
        Assert.assertEquals((long)4L, (long)res.get());
    }

    @Test(expected=UDFArgumentException.class)
    public void testConversionIsPrevented1() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableByteObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new Text("4")), new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
    }

    @Test
    public void testConversionInSameGroup() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableByteObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new DoubleWritable(4.0)), new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
    }

    @Test(expected=UDFArgumentException.class)
    public void testConversionIsPrevented2() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4)), new GenericUDF.DeferredJavaObject((Object)new Text("4"))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
    }

    @Test(expected=UDFArgumentException.class)
    public void testNotSupportedArgumentMix() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableByteObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(4)), new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4))};
        udf.initialize(inputOIs);
    }

    @Test
    public void testDateCompareEq() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(4)), new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(4))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.dateTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals(null, (Object)udf.evaluate(args));
    }

    @Test
    public void testLazy() throws HiveException {
        GenericUDFNullif udf = new GenericUDFNullif();
        ObjectInspector[] inputOIs = new ObjectInspector[]{LazyPrimitiveObjectInspectorFactory.LAZY_INT_OBJECT_INSPECTOR, LazyPrimitiveObjectInspectorFactory.LAZY_INT_OBJECT_INSPECTOR};
        LazyInteger a1 = new LazyInteger(LazyPrimitiveObjectInspectorFactory.LAZY_INT_OBJECT_INSPECTOR);
        LazyInteger a2 = new LazyInteger(LazyPrimitiveObjectInspectorFactory.LAZY_INT_OBJECT_INSPECTOR);
        ((IntWritable)a1.getWritableObject()).set(1);
        ((IntWritable)a2.getWritableObject()).set(1);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)a1), new GenericUDF.DeferredJavaObject((Object)a2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.intTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals(null, (Object)udf.evaluate(args));
    }
}

