/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

@Description(name="variance", value="_FUNC_(expr) - Returns the average value of expr (vectorized, type: <ValueType>)")
public class VectorUDAFVarFinal
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private transient GenericUDAFVariance.VarianceKind varianceKind = GenericUDAFVariance.VarianceKind.NONE;

    public VectorUDAFVarFinal() {
    }

    public VectorUDAFVarFinal(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        Preconditions.checkState((this.mode == GenericUDAFEvaluator.Mode.FINAL ? 1 : 0) != 0);
        this.init();
    }

    private void init() {
        String aggregateName = this.vecAggrDesc.getAggrDesc().getGenericUDAFName();
        this.varianceKind = GenericUDAFVariance.VarianceKind.nameMap.get(aggregateName);
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(bufferIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        StructColumnVector inputStructColVector = (StructColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        ColumnVector[] fields = inputStructColVector.fields;
        long[] countVector = ((LongColumnVector)fields[0]).vector;
        double[] sumVector = ((DoubleColumnVector)fields[1]).vector;
        double[] varianceVector = ((DoubleColumnVector)fields[2]).vector;
        if (inputStructColVector.noNulls) {
            if (inputStructColVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector[0], sumVector[0], varianceVector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, varianceVector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, varianceVector, batchSize);
            }
        } else if (inputStructColVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector[0], sumVector[0], varianceVector[0], batchSize, batch.selected, inputStructColVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector[0], sumVector[0], varianceVector[0], batchSize, inputStructColVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, varianceVector, batchSize, batch.selected, inputStructColVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, varianceVector, batchSize, inputStructColVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long count, double sum, double variance, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(count, sum, variance);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, double[] sumVector, double[] varianceVector, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            int batchIndex = selection[i];
            myagg.merge(countVector[batchIndex], sumVector[batchIndex], varianceVector[batchIndex]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, double[] sumVector, double[] varianceVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(countVector[i], sumVector[i], varianceVector[i]);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long count, double sum, double variance, int batchSize, int[] selection, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(count, sum, variance);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long count, double sum, double variance, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(count, sum, variance);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, double[] sumVector, double[] varianceVector, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            int batchIndex = selection[i];
            if (isNull[batchIndex]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(countVector[batchIndex], sumVector[batchIndex], varianceVector[batchIndex]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, double[] sumVector, double[] varianceVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(countVector[i], sumVector[i], varianceVector[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        StructColumnVector inputStructColVector = (StructColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        ColumnVector[] fields = inputStructColVector.fields;
        long[] countVector = ((LongColumnVector)fields[0]).vector;
        double[] sumVector = ((DoubleColumnVector)fields[1]).vector;
        double[] varianceVector = ((DoubleColumnVector)fields[2]).vector;
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputStructColVector.isRepeating) {
            if (inputStructColVector.noNulls || !inputStructColVector.isNull[0]) {
                long count = countVector[0];
                double sum = sumVector[0];
                double variance = varianceVector[0];
                for (int i = 0; i < batchSize; ++i) {
                    myagg.merge(count, sum, variance);
                }
            }
            return;
        }
        if (!batch.selectedInUse && inputStructColVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, countVector, sumVector, varianceVector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, countVector, sumVector, varianceVector, batchSize, inputStructColVector.isNull);
        } else if (inputStructColVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, countVector, sumVector, varianceVector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, countVector, sumVector, varianceVector, batchSize, inputStructColVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, long[] countVector, double[] sumVector, double[] varianceVector, int batchSize, boolean[] isNull, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            int batchIndex = selected[i];
            if (isNull[batchIndex]) continue;
            myagg.merge(countVector[batchIndex], sumVector[batchIndex], varianceVector[batchIndex]);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, long[] countVector, double[] sumVector, double[] varianceVector, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            int batchIndex = selected[i];
            myagg.merge(countVector[batchIndex], sumVector[batchIndex], varianceVector[batchIndex]);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, long[] countVector, double[] sumVector, double[] varianceVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            myagg.merge(countVector[i], sumVector[i], varianceVector[i]);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, long[] countVector, double[] sumVector, double[] varianceVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            myagg.merge(countVector[i], sumVector[i], varianceVector[i]);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((long)(model.object() + model.primitive2() * 2), (long)model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return false;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (GenericUDAFVariance.isVarianceNull(myagg.mergeCount, this.varianceKind)) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        outputColVector.isNull[batchIndex] = false;
        double result = myagg.mergeCount > 1L ? GenericUDAFVariance.calculateVarianceFamilyResult(myagg.mergeVariance, myagg.mergeCount, this.varianceKind) : 0.0;
        outputColVector.vector[batchIndex] = result;
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient long mergeCount;
        private transient double mergeSum;
        private transient double mergeVariance;
        private transient boolean isNull = true;

        Aggregation() {
        }

        public void merge(long partialCount, double partialSum, double partialVariance) {
            if (this.isNull || this.mergeCount == 0L) {
                this.mergeCount = partialCount;
                this.mergeSum = partialSum;
                this.mergeVariance = partialVariance;
                this.isNull = false;
                return;
            }
            if (partialCount > 0L && this.mergeCount > 0L) {
                this.mergeVariance += GenericUDAFVariance.calculateMerge(partialCount, this.mergeCount, partialSum, this.mergeSum, partialVariance, this.mergeVariance);
                this.mergeCount += partialCount;
                this.mergeSum += partialSum;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.mergeCount = 0L;
            this.mergeSum = 0.0;
            this.mergeVariance = 0.0;
        }
    }
}

