/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.com.zaxxer.hikari.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import org.apache.hive.com.zaxxer.hikari.metrics.IMetricsTracker;

class PrometheusMetricsTracker
implements IMetricsTracker {
    private final Counter.Child connectionTimeoutCounter;
    private final Summary.Child elapsedAcquiredSummary;
    private final Summary.Child elapsedBorrowedSummary;
    private final Summary.Child elapsedCreationSummary;
    private final Counter ctCounter;
    private final Summary eaSummary;
    private final Summary ebSummary;
    private final Summary ecSummary;
    private final Collector collector;

    PrometheusMetricsTracker(String poolName, Collector collector) {
        this.collector = collector;
        this.ctCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_count")).labelNames(new String[]{"pool"})).help("Connection timeout count")).register();
        this.connectionTimeoutCounter = (Counter.Child)this.ctCounter.labels(new String[]{poolName});
        this.eaSummary = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("hikaricp_connection_acquired_nanos")).labelNames(new String[]{"pool"})).help("Connection acquired time (ns)")).register();
        this.elapsedAcquiredSummary = (Summary.Child)this.eaSummary.labels(new String[]{poolName});
        this.ebSummary = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("hikaricp_connection_usage_millis")).labelNames(new String[]{"pool"})).help("Connection usage (ms)")).register();
        this.elapsedBorrowedSummary = (Summary.Child)this.ebSummary.labels(new String[]{poolName});
        this.ecSummary = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("hikaricp_connection_creation_millis")).labelNames(new String[]{"pool"})).help("Connection creation (ms)")).register();
        this.elapsedCreationSummary = (Summary.Child)this.ecSummary.labels(new String[]{poolName});
    }

    @Override
    public void close() {
        CollectorRegistry.defaultRegistry.unregister((Collector)this.ctCounter);
        CollectorRegistry.defaultRegistry.unregister((Collector)this.eaSummary);
        CollectorRegistry.defaultRegistry.unregister((Collector)this.ebSummary);
        CollectorRegistry.defaultRegistry.unregister((Collector)this.ecSummary);
        CollectorRegistry.defaultRegistry.unregister(this.collector);
    }

    @Override
    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.elapsedAcquiredSummary.observe((double)elapsedAcquiredNanos);
    }

    @Override
    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.elapsedBorrowedSummary.observe((double)elapsedBorrowedMillis);
    }

    @Override
    public void recordConnectionCreatedMillis(long connectionCreatedMillis) {
        this.elapsedCreationSummary.observe((double)connectionCreatedMillis);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutCounter.inc();
    }
}

