/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.events.PreCreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFunctionEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(CreateFunctionEvent.class);
    private String COMMAND_STR = "create function";

    public CreateFunctionEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.CREATEFUNCTION, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        return Collections.emptyList();
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> CreateFunctionEvent.getOutputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreCreateFunctionEvent event = (PreCreateFunctionEvent)this.preEventContext;
        Function function = event.getFunction();
        List<ResourceUri> uris = function.getResourceUris();
        ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, function.getDbName(), null, null, null, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, null));
        ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.FUNCTION, function.getDbName(), function.getFunctionName(), null, null, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, function.getClassName()));
        if (uris != null && !uris.isEmpty()) {
            for (ResourceUri uri : uris) {
                ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI, null, uri.getUri()));
            }
        }
        this.COMMAND_STR = this.buildCommandString(function);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== CreateFunctionEvent.getOutputHObjs(): ret=" + ret);
        }
        return ret;
    }

    private String buildCommandString(Function function) {
        Object ret = this.COMMAND_STR;
        if (function != null) {
            String functionName = function.getFunctionName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty(functionName) ? " " + functionName : "");
        }
        return ret;
    }
}

