/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertAstToSearchArg {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertAstToSearchArg.class);
    private final SearchArgument.Builder builder;
    private final Configuration conf;
    public static final String SARG_PUSHDOWN = "sarg.pushdown";
    private static volatile Cache<String, SearchArgument> sargsCache = null;
    private static final ThreadLocal<Kryo> kryo = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return new Kryo();
        }
    };

    ConvertAstToSearchArg(Configuration conf, ExprNodeGenericFuncDesc expression) {
        this.conf = conf;
        this.builder = SearchArgumentFactory.newBuilder(conf);
        this.parse(expression);
    }

    public SearchArgument buildSearchArgument() {
        return this.builder.build();
    }

    private static BoxType getType(ExprNodeDesc expr) {
        TypeInfo type = expr.getTypeInfo();
        if (type.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            switch (((PrimitiveTypeInfo)type).getPrimitiveCategory()) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    return BoxType.LONG;
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    return BoxType.STRING;
                }
                case FLOAT: {
                    return BoxType.FLOAT;
                }
                case DOUBLE: {
                    return BoxType.DOUBLE;
                }
                case DATE: {
                    return BoxType.DATE;
                }
                case TIMESTAMP: {
                    return BoxType.TIMESTAMP;
                }
                case DECIMAL: {
                    return BoxType.DECIMAL;
                }
                case BOOLEAN: {
                    return BoxType.BOOLEAN;
                }
            }
        }
        return null;
    }

    private static String getColumnName(ExprNodeGenericFuncDesc expr, int variable) {
        List<ExprNodeDesc> children = expr.getChildren();
        if (variable < 0 || variable >= children.size()) {
            return null;
        }
        ExprNodeDesc child = children.get(variable);
        if (child instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)child).getColumn();
        }
        return null;
    }

    private static Object boxLiteral(ExprNodeConstantDesc constantDesc, BoxType boxType) {
        Object lit = constantDesc.getValue();
        if (lit == null) {
            return null;
        }
        switch (boxType) {
            case LONG: {
                if (lit instanceof HiveDecimal) {
                    HiveDecimal dec = (HiveDecimal)lit;
                    if (!dec.isLong()) {
                        throw new ArithmeticException("Overflow");
                    }
                    return dec.longValue();
                }
                return ((Number)lit).longValue();
            }
            case STRING: {
                if (lit instanceof HiveChar) {
                    return ((HiveChar)lit).getPaddedValue();
                }
                if (lit instanceof String) {
                    return lit;
                }
                return lit.toString();
            }
            case DOUBLE: {
                Number dbl = lit instanceof HiveDecimal ? (Number)((HiveDecimal)lit).doubleValue() : (Number)((Number)lit);
                return dbl.doubleValue();
            }
            case FLOAT: {
                Number fl = lit instanceof HiveDecimal ? (Number)Float.valueOf(((HiveDecimal)lit).floatValue()) : (Number)((Number)lit);
                return fl.doubleValue();
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(lit.toString());
            }
            case DATE: {
                return Date.valueOf(lit.toString());
            }
            case DECIMAL: {
                return new HiveDecimalWritable(lit.toString());
            }
            case BOOLEAN: {
                return lit;
            }
        }
        throw new IllegalArgumentException("Unknown literal " + boxType);
    }

    private static Object findLiteral(Configuration conf, ExprNodeGenericFuncDesc expr, BoxType boxType) {
        List<ExprNodeDesc> children = expr.getChildren();
        if (children.size() != 2) {
            return null;
        }
        Object result = null;
        for (ExprNodeDesc child : children) {
            Object currentResult = ConvertAstToSearchArg.getLiteral(conf, child, boxType);
            if (currentResult == null) continue;
            if (result != null) {
                return null;
            }
            result = currentResult;
        }
        return result;
    }

    private static Object getLiteral(Configuration conf, ExprNodeDesc child, BoxType boxType) {
        if (child instanceof ExprNodeConstantDesc) {
            return ConvertAstToSearchArg.boxLiteral((ExprNodeConstantDesc)child, boxType);
        }
        if (child instanceof ExprNodeDynamicValueDesc) {
            DynamicValue value = ((ExprNodeDynamicValueDesc)child).getDynamicValue();
            value.setConf(conf);
            return value;
        }
        return null;
    }

    private static Object getLiteral(Configuration conf, ExprNodeGenericFuncDesc expr, BoxType boxType, int position) {
        List<ExprNodeDesc> children = expr.getChildren();
        ExprNodeDesc child = children.get(position);
        return ConvertAstToSearchArg.getLiteral(conf, child, boxType);
    }

    private static Object[] getLiteralList(ExprNodeGenericFuncDesc expr, BoxType boxType, int start) {
        List<ExprNodeDesc> children = expr.getChildren();
        Object[] result = new Object[children.size() - start];
        int posn = 0;
        for (ExprNodeDesc child : children.subList(start, children.size())) {
            if (child instanceof ExprNodeConstantDesc) {
                result[posn++] = ConvertAstToSearchArg.boxLiteral((ExprNodeConstantDesc)child, boxType);
                continue;
            }
            return null;
        }
        return result;
    }

    private void createLeaf(PredicateLeaf.Operator operator, ExprNodeGenericFuncDesc expression, int variable) {
        String columnName = ConvertAstToSearchArg.getColumnName(expression, variable);
        if (columnName == null) {
            this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
            return;
        }
        BoxType boxType = ConvertAstToSearchArg.getType(expression.getChildren().get(variable));
        if (boxType == null) {
            this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
            return;
        }
        boolean needSwap = false;
        if (variable != 0) {
            if (operator == PredicateLeaf.Operator.LESS_THAN) {
                needSwap = true;
                operator = PredicateLeaf.Operator.LESS_THAN_EQUALS;
            } else if (operator == PredicateLeaf.Operator.LESS_THAN_EQUALS) {
                needSwap = true;
                operator = PredicateLeaf.Operator.LESS_THAN;
            }
        }
        if (needSwap) {
            this.builder.startNot();
        }
        try {
            switch (operator) {
                case IS_NULL: {
                    this.builder.isNull(columnName, boxType.type);
                    break;
                }
                case EQUALS: {
                    this.builder.equals(columnName, boxType.type, ConvertAstToSearchArg.findLiteral(this.conf, expression, boxType));
                    break;
                }
                case NULL_SAFE_EQUALS: {
                    this.builder.nullSafeEquals(columnName, boxType.type, ConvertAstToSearchArg.findLiteral(this.conf, expression, boxType));
                    break;
                }
                case LESS_THAN: {
                    this.builder.lessThan(columnName, boxType.type, ConvertAstToSearchArg.findLiteral(this.conf, expression, boxType));
                    break;
                }
                case LESS_THAN_EQUALS: {
                    this.builder.lessThanEquals(columnName, boxType.type, ConvertAstToSearchArg.findLiteral(this.conf, expression, boxType));
                    break;
                }
                case IN: {
                    this.builder.in(columnName, boxType.type, ConvertAstToSearchArg.getLiteralList(expression, boxType, variable + 1));
                    break;
                }
                case BETWEEN: {
                    this.builder.between(columnName, boxType.type, ConvertAstToSearchArg.getLiteral(this.conf, expression, boxType, variable + 1), ConvertAstToSearchArg.getLiteral(this.conf, expression, boxType, variable + 2));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception thrown during SARG creation. Returning YES_NO_NULL. Exception: " + e.getMessage());
            this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
        }
        if (needSwap) {
            this.builder.end();
        }
    }

    private int findVariable(ExprNodeDesc expr) {
        int result = -1;
        List<ExprNodeDesc> children = expr.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ExprNodeDesc child = children.get(i);
            if (!(child instanceof ExprNodeColumnDesc)) continue;
            if (result != -1) {
                return -1;
            }
            result = i;
        }
        return result;
    }

    private void createLeaf(PredicateLeaf.Operator operator, ExprNodeGenericFuncDesc expression) {
        this.createLeaf(operator, expression, this.findVariable(expression));
    }

    private void addChildren(ExprNodeGenericFuncDesc node) {
        for (ExprNodeDesc child : node.getChildren()) {
            this.parse(child);
        }
    }

    private void parse(ExprNodeDesc expression) {
        if (expression.getClass() != ExprNodeGenericFuncDesc.class) {
            ExprNodeColumnDesc columnDesc;
            if (expression instanceof ExprNodeColumnDesc && (columnDesc = (ExprNodeColumnDesc)expression).getTypeString().equals("boolean")) {
                this.builder.equals(columnDesc.getColumn(), PredicateLeaf.Type.BOOLEAN, true);
                return;
            }
            this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
            return;
        }
        ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)expression;
        Class<?> op = expr.getGenericUDF().getClass();
        if (op == GenericUDFOPOr.class) {
            this.builder.startOr();
            this.addChildren(expr);
            this.builder.end();
        } else if (op == GenericUDFOPAnd.class) {
            this.builder.startAnd();
            this.addChildren(expr);
            this.builder.end();
        } else if (op == GenericUDFOPNot.class) {
            this.builder.startNot();
            this.addChildren(expr);
            this.builder.end();
        } else if (op == GenericUDFOPEqual.class) {
            this.createLeaf(PredicateLeaf.Operator.EQUALS, expr);
        } else if (op == GenericUDFOPNotEqual.class) {
            this.builder.startNot();
            this.createLeaf(PredicateLeaf.Operator.EQUALS, expr);
            this.builder.end();
        } else if (op == GenericUDFOPEqualNS.class) {
            this.createLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, expr);
        } else if (op == GenericUDFOPGreaterThan.class) {
            this.builder.startNot();
            this.createLeaf(PredicateLeaf.Operator.LESS_THAN_EQUALS, expr);
            this.builder.end();
        } else if (op == GenericUDFOPEqualOrGreaterThan.class) {
            this.builder.startNot();
            this.createLeaf(PredicateLeaf.Operator.LESS_THAN, expr);
            this.builder.end();
        } else if (op == GenericUDFOPLessThan.class) {
            this.createLeaf(PredicateLeaf.Operator.LESS_THAN, expr);
        } else if (op == GenericUDFOPEqualOrLessThan.class) {
            this.createLeaf(PredicateLeaf.Operator.LESS_THAN_EQUALS, expr);
        } else if (op == GenericUDFIn.class) {
            this.createLeaf(PredicateLeaf.Operator.IN, expr, 0);
        } else if (op == GenericUDFBetween.class) {
            this.createLeaf(PredicateLeaf.Operator.BETWEEN, expr, 1);
        } else if (op == GenericUDFOPNull.class) {
            this.createLeaf(PredicateLeaf.Operator.IS_NULL, expr, 0);
        } else if (op == GenericUDFOPNotNull.class) {
            this.builder.startNot();
            this.createLeaf(PredicateLeaf.Operator.IS_NULL, expr, 0);
            this.builder.end();
        } else {
            this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
        }
    }

    private static synchronized Cache<String, SearchArgument> initializeAndGetSargsCache(Configuration conf) {
        if (sargsCache == null) {
            sargsCache = CacheBuilder.newBuilder().weigher((key, value) -> key.length()).maximumWeight(HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_IO_SARG_CACHE_MAX_WEIGHT_MB) * 1024 * 1024).build();
        }
        return sargsCache;
    }

    private static Cache<String, SearchArgument> getSargsCache(Configuration conf) {
        return sargsCache == null ? ConvertAstToSearchArg.initializeAndGetSargsCache(conf) : sargsCache;
    }

    private static boolean isSargsCacheEnabled(Configuration conf) {
        return HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_IO_SARG_CACHE_MAX_WEIGHT_MB) > 0;
    }

    private static SearchArgument getSearchArgumentFromString(Configuration conf, String sargString) {
        try {
            return ConvertAstToSearchArg.isSargsCacheEnabled(conf) ? ConvertAstToSearchArg.getSargsCache(conf).get(sargString, () -> ConvertAstToSearchArg.create(sargString)) : ConvertAstToSearchArg.create(sargString);
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static SearchArgument getSearchArgumentFromExpression(Configuration conf, String sargString) {
        try {
            return ConvertAstToSearchArg.isSargsCacheEnabled(conf) ? ConvertAstToSearchArg.getSargsCache(conf).get(sargString, () -> ConvertAstToSearchArg.create(conf, SerializationUtilities.deserializeExpression(sargString))) : ConvertAstToSearchArg.create(conf, SerializationUtilities.deserializeExpression(sargString));
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SearchArgument create(Configuration conf, ExprNodeGenericFuncDesc expression) {
        return new ConvertAstToSearchArg(conf, expression).buildSearchArgument();
    }

    public static SearchArgument create(String kryo) {
        return ConvertAstToSearchArg.create(Base64.decodeBase64((String)kryo));
    }

    public static SearchArgument create(byte[] kryoBytes) {
        return kryo.get().readObject(new Input(kryoBytes), SearchArgumentImpl.class);
    }

    public static SearchArgument createFromConf(Configuration conf) {
        String sargString = conf.get("hive.io.filter.expr.serialized");
        if (sargString != null) {
            return ConvertAstToSearchArg.getSearchArgumentFromExpression(conf, sargString);
        }
        sargString = conf.get(SARG_PUSHDOWN);
        if (sargString != null) {
            return ConvertAstToSearchArg.getSearchArgumentFromString(conf, sargString);
        }
        return null;
    }

    public static boolean canCreateFromConf(Configuration conf) {
        return conf.get("hive.io.filter.expr.serialized") != null || conf.get(SARG_PUSHDOWN) != null;
    }

    private static enum BoxType {
        LONG(PredicateLeaf.Type.LONG),
        FLOAT(PredicateLeaf.Type.FLOAT),
        DOUBLE(PredicateLeaf.Type.FLOAT),
        STRING(PredicateLeaf.Type.STRING),
        DATE(PredicateLeaf.Type.DATE),
        DECIMAL(PredicateLeaf.Type.DECIMAL),
        TIMESTAMP(PredicateLeaf.Type.TIMESTAMP),
        BOOLEAN(PredicateLeaf.Type.BOOLEAN);

        public final PredicateLeaf.Type type;

        private BoxType(PredicateLeaf.Type type) {
            this.type = type;
        }
    }
}

