/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;

public class EnforceReadOnlyTables
implements ExecuteWithHookContext {
    @Override
    public void run(HookContext hookContext) throws Exception {
        SessionState ss = SessionState.get();
        Set<ReadEntity> inputs = hookContext.getInputs();
        Set<WriteEntity> outputs = hookContext.getOutputs();
        UserGroupInformation ugi = hookContext.getUgi();
        boolean isExplain = hookContext.getQueryPlan().isExplain();
        this.run(ss, inputs, outputs, ugi, isExplain);
    }

    public void run(SessionState sess, Set<ReadEntity> inputs, Set<WriteEntity> outputs, UserGroupInformation ugi, boolean isExplain) throws Exception {
        if (sess.getConf().getBoolean("hive.test.init.phase", false) || sess.getConf().getBoolean("hive.test.shutdown.phase", false)) {
            return;
        }
        List<String> readOnlyTables = Arrays.asList(System.getProperty("test.src.tables").split(","));
        for (WriteEntity w : outputs) {
            Table t;
            if (w.getTyp() != Entity.Type.TABLE && w.getTyp() != Entity.Type.PARTITION || !"default".equalsIgnoreCase((t = w.getTable()).getDbName()) || !readOnlyTables.contains(t.getTableName()) || isExplain) continue;
            throw new RuntimeException("Cannot overwrite read-only table: " + t.getTableName());
        }
    }
}

