/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TimestampToStringUnaryUDF;

public class CastTimestampToString
extends TimestampToStringUnaryUDF {
    private static final long serialVersionUID = 1L;
    protected transient Timestamp dt = new Timestamp(0L);
    private static final DateTimeFormatter PRINT_FORMATTER;

    public CastTimestampToString() {
    }

    public CastTimestampToString(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    protected void assign(BytesColumnVector outV, int i, byte[] bytes, int length) {
        outV.setVal(i, bytes, 0, length);
    }

    @Override
    protected void func(BytesColumnVector outV, TimestampColumnVector inV, int i) {
        this.dt.setTime(inV.time[i]);
        this.dt.setNanos(inV.nanos[i]);
        byte[] temp = LocalDateTime.ofInstant(Instant.ofEpochMilli(inV.time[i]), ZoneOffset.UTC).withNano(inV.nanos[i]).format(PRINT_FORMATTER).getBytes();
        this.assign(outV, i, temp, temp.length);
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        builder.optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd();
        PRINT_FORMATTER = builder.toFormatter();
    }
}

