/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.CollectOperator;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.DemuxOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MuxOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OrcFileMergeOperator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.RCFileMergeOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.SparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorAppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorFileSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorFilterOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorGroupByOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorLimitOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorSMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorSelectOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorSparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorSparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.CollectDesc;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.DemuxDesc;
import org.apache.hadoop.hive.ql.plan.DummyStoreDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.ForwardDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HashTableDummyDesc;
import org.apache.hadoop.hive.ql.plan.HashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewForwardDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MuxDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UDTFDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OperatorFactory {
    protected static final transient Logger LOG = LoggerFactory.getLogger(OperatorFactory.class);
    private static final IdentityHashMap<Class<? extends OperatorDesc>, Class<? extends Operator<? extends OperatorDesc>>> opvec = new IdentityHashMap();
    private static final IdentityHashMap<Class<? extends OperatorDesc>, Class<? extends Operator<? extends OperatorDesc>>> vectorOpvec = new IdentityHashMap();

    public static <T extends OperatorDesc> Operator<T> getVectorOperator(Class<? extends Operator<?>> opClass, CompilationOpContext cContext, T conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        Constructor<Operator<?>> constructor;
        try {
            constructor = opClass.getDeclaredConstructor(CompilationOpContext.class, OperatorDesc.class, VectorizationContext.class, VectorDesc.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException("Constructor " + opClass.getSimpleName() + "(CompilationOpContext, OperatorDesc, VectorizationContext, VectorDesc) not found", e);
        }
        try {
            vectorDesc.setVectorOp(opClass);
            Operator<?> op = constructor.newInstance(cContext, conf, vContext, vectorDesc);
            return op;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException("Error encountered calling constructor " + opClass.getSimpleName() + "(CompilationOpContext, OperatorDesc, VectorizationContext, VectorDesc)", e);
        }
    }

    public static <T extends OperatorDesc> Operator<T> getVectorOperator(CompilationOpContext cContext, T conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        Class<?> descClass = conf.getClass();
        Class<? extends Operator<? extends OperatorDesc>> opClass = vectorOpvec.get(descClass);
        if (opClass != null) {
            return OperatorFactory.getVectorOperator(vectorOpvec.get(descClass), cContext, conf, vContext, vectorDesc);
        }
        throw new HiveException("No vector operator for descriptor class " + descClass.getName());
    }

    public static <T extends OperatorDesc> Operator<T> get(CompilationOpContext cContext, Class<T> descClass) {
        Preconditions.checkNotNull(cContext);
        Class<? extends Operator<? extends OperatorDesc>> opClass = opvec.get(descClass);
        if (opClass != null) {
            try {
                return opClass.getDeclaredConstructor(CompilationOpContext.class).newInstance(cContext);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No operator for descriptor class " + descClass.getName());
    }

    public static <T extends OperatorDesc> Operator<T> get(CompilationOpContext cContext, T conf) {
        Operator<Class<?>> ret = OperatorFactory.get(cContext, conf.getClass());
        ret.setConf((Class<?>)((Object)conf));
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> get(T conf, Operator<? extends OperatorDesc> oplist0, Operator<? extends OperatorDesc> ... oplist) {
        Operator<Class<?>> ret = OperatorFactory.get(oplist0.getCompilationOpContext(), conf.getClass());
        ret.setConf((Class<?>)((Object)conf));
        OperatorFactory.makeChild(ret, oplist0);
        OperatorFactory.makeChild(ret, oplist);
        return ret;
    }

    public static void makeChild(Operator<? extends OperatorDesc> ret, Operator<? extends OperatorDesc> ... oplist) {
        if (oplist.length == 0) {
            return;
        }
        ArrayList<Operator<? extends OperatorDesc>> clist = new ArrayList<Operator<? extends OperatorDesc>>();
        for (Operator<? extends OperatorDesc> op : oplist) {
            clist.add(op);
        }
        ret.setChildOperators(clist);
        for (Operator<? extends OperatorDesc> op : oplist) {
            List<Operator<? extends OperatorDesc>> parents = op.getParentOperators();
            parents.add(ret);
            op.setParentOperators(parents);
        }
    }

    public static <T extends OperatorDesc> Operator<T> get(CompilationOpContext cContext, T conf, RowSchema rwsch) {
        Operator<T> ret = OperatorFactory.get(cContext, conf);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(T conf, Operator oplist0, Operator ... oplist) {
        Operator<Class<?>> ret = OperatorFactory.get(oplist0.getCompilationOpContext(), conf.getClass());
        ret.setConf((Class<?>)((Object)conf));
        ret.setBucketingVersion(oplist0.getBucketingVersion());
        List<Operator<? extends OperatorDesc>> children = oplist0.getChildOperators();
        children.add(ret);
        oplist0.setChildOperators(children);
        for (Operator op : oplist) {
            children = op.getChildOperators();
            children.add(ret);
            op.setChildOperators(children);
        }
        ArrayList<Operator<? extends OperatorDesc>> parent = new ArrayList<Operator<? extends OperatorDesc>>();
        parent.add(oplist0);
        for (Operator op : oplist) {
            parent.add(op);
        }
        ret.setParentOperators(parent);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(CompilationOpContext cContext, T conf, List<Operator<? extends OperatorDesc>> oplist) {
        Operator<Class<?>> ret = OperatorFactory.get(cContext, conf.getClass());
        ret.setConf((Class<?>)((Object)conf));
        if (oplist.size() == 0) {
            return ret;
        }
        for (Operator<? extends OperatorDesc> op : oplist) {
            List<Operator<OperatorDesc>> children = op.getChildOperators();
            children.add(ret);
        }
        ArrayList<Operator<? extends OperatorDesc>> parent = new ArrayList<Operator<? extends OperatorDesc>>();
        for (Operator<? extends OperatorDesc> op : oplist) {
            parent.add(op);
        }
        ret.setParentOperators(parent);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(CompilationOpContext cContext, T conf, RowSchema rwsch) {
        Operator<Class<?>> ret = OperatorFactory.get(cContext, conf.getClass());
        ret.setConf((Class<?>)((Object)conf));
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(CompilationOpContext ctx, T conf, RowSchema rwsch, Operator[] oplist) {
        Operator<Class<?>> ret = OperatorFactory.get(ctx, conf.getClass());
        ret.setConf((Class<?>)((Object)conf));
        ret.setSchema(rwsch);
        if (oplist.length == 0) {
            return ret;
        }
        for (Operator op : oplist) {
            List<Operator<? extends OperatorDesc>> children = op.getChildOperators();
            children.add(ret);
            op.setChildOperators(children);
        }
        ArrayList<Operator<? extends OperatorDesc>> parent = new ArrayList<Operator<? extends OperatorDesc>>();
        for (Operator op : oplist) {
            parent.add(op);
        }
        ret.setParentOperators(parent);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(T conf, RowSchema rwsch, Operator oplist0, Operator ... oplist) {
        Operator<T> ret = OperatorFactory.getAndMakeChild(conf, oplist0, oplist);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(T conf, RowSchema rwsch, Map<String, ExprNodeDesc> colExprMap, Operator oplist0, Operator ... oplist) {
        Operator<T> ret = OperatorFactory.getAndMakeChild(conf, rwsch, oplist0, oplist);
        ret.setColumnExprMap(colExprMap);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(CompilationOpContext cContext, T conf, RowSchema rwsch, List<Operator<? extends OperatorDesc>> oplist) {
        Operator<T> ret = OperatorFactory.getAndMakeChild(cContext, conf, oplist);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends OperatorDesc> Operator<T> getAndMakeChild(CompilationOpContext cContext, T conf, RowSchema rwsch, Map<String, ExprNodeDesc> colExprMap, List<Operator<? extends OperatorDesc>> oplist) {
        Operator<T> ret = OperatorFactory.getAndMakeChild(cContext, conf, rwsch, oplist);
        ret.setColumnExprMap(colExprMap);
        return ret;
    }

    private OperatorFactory() {
    }

    static {
        opvec.put(FilterDesc.class, FilterOperator.class);
        opvec.put(SelectDesc.class, SelectOperator.class);
        opvec.put(ForwardDesc.class, ForwardOperator.class);
        opvec.put(FileSinkDesc.class, FileSinkOperator.class);
        opvec.put(CollectDesc.class, CollectOperator.class);
        opvec.put(ScriptDesc.class, ScriptOperator.class);
        opvec.put(PTFDesc.class, PTFOperator.class);
        opvec.put(ReduceSinkDesc.class, ReduceSinkOperator.class);
        opvec.put(GroupByDesc.class, GroupByOperator.class);
        opvec.put(JoinDesc.class, JoinOperator.class);
        opvec.put(MapJoinDesc.class, MapJoinOperator.class);
        opvec.put(SMBJoinDesc.class, SMBMapJoinOperator.class);
        opvec.put(LimitDesc.class, LimitOperator.class);
        opvec.put(TableScanDesc.class, TableScanOperator.class);
        opvec.put(UnionDesc.class, UnionOperator.class);
        opvec.put(UDTFDesc.class, UDTFOperator.class);
        opvec.put(LateralViewJoinDesc.class, LateralViewJoinOperator.class);
        opvec.put(LateralViewForwardDesc.class, LateralViewForwardOperator.class);
        opvec.put(HashTableDummyDesc.class, HashTableDummyOperator.class);
        opvec.put(HashTableSinkDesc.class, HashTableSinkOperator.class);
        opvec.put(SparkHashTableSinkDesc.class, SparkHashTableSinkOperator.class);
        opvec.put(DummyStoreDesc.class, DummyStoreOperator.class);
        opvec.put(DemuxDesc.class, DemuxOperator.class);
        opvec.put(MuxDesc.class, MuxOperator.class);
        opvec.put(AppMasterEventDesc.class, AppMasterEventOperator.class);
        opvec.put(DynamicPruningEventDesc.class, AppMasterEventOperator.class);
        opvec.put(SparkPartitionPruningSinkDesc.class, SparkPartitionPruningSinkOperator.class);
        opvec.put(RCFileMergeDesc.class, RCFileMergeOperator.class);
        opvec.put(OrcFileMergeDesc.class, OrcFileMergeOperator.class);
        opvec.put(CommonMergeJoinDesc.class, CommonMergeJoinOperator.class);
        opvec.put(ListSinkDesc.class, ListSinkOperator.class);
        vectorOpvec.put(AppMasterEventDesc.class, VectorAppMasterEventOperator.class);
        vectorOpvec.put(DynamicPruningEventDesc.class, VectorAppMasterEventOperator.class);
        vectorOpvec.put(SparkPartitionPruningSinkDesc.class, VectorSparkPartitionPruningSinkOperator.class);
        vectorOpvec.put(SelectDesc.class, VectorSelectOperator.class);
        vectorOpvec.put(GroupByDesc.class, VectorGroupByOperator.class);
        vectorOpvec.put(MapJoinDesc.class, VectorMapJoinOperator.class);
        vectorOpvec.put(SMBJoinDesc.class, VectorSMBMapJoinOperator.class);
        vectorOpvec.put(ReduceSinkDesc.class, VectorReduceSinkOperator.class);
        vectorOpvec.put(FileSinkDesc.class, VectorFileSinkOperator.class);
        vectorOpvec.put(FilterDesc.class, VectorFilterOperator.class);
        vectorOpvec.put(LimitDesc.class, VectorLimitOperator.class);
        vectorOpvec.put(PTFDesc.class, VectorPTFOperator.class);
        vectorOpvec.put(SparkHashTableSinkDesc.class, VectorSparkHashTableSinkOperator.class);
    }
}

