/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LlapUtil.class);
    private static final Pattern hostsRe = Pattern.compile("[^A-Za-z0-9_-]");
    private static final String BASE_PREFIX = "base_";
    private static final String DELTA_PREFIX = "delta_";
    private static final String DELETE_DELTA_PREFIX = "delete_delta_";
    private static final String BUCKET_PREFIX = "bucket_";
    private static final String DATABASE_PATH_SUFFIX = ".db";
    private static final String UNION_SUDBIR_PREFIX = "HIVE_UNION_SUBDIR_";
    public static final char DERIVED_ENTITY_PARTITION_SEPARATOR = '/';

    public static String getDaemonLocalDirString(Configuration conf, String workDirsEnvString) {
        String localDirList = HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_DAEMON_WORK_DIRS);
        if (localDirList != null && !localDirList.isEmpty()) {
            LOG.info("Local dirs from Configuration: {}", (Object)localDirList);
            if (!localDirList.equalsIgnoreCase("useYarnEnvDirs") && !StringUtils.isBlank(localDirList)) {
                LOG.info("Using local dirs from Configuration");
                return localDirList;
            }
        }
        if (StringUtils.isNotBlank(workDirsEnvString)) {
            LOG.info("Using local dirs from environment: {}", (Object)workDirsEnvString);
            return workDirsEnvString;
        }
        throw new RuntimeException("Cannot determined local dirs from specified configuration and env. ValueFromConf=" + localDirList + ", ValueFromEnv=" + workDirsEnvString);
    }

    public static UserGroupInformation loginWithKerberos(String principal, String keytabFile) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return null;
        }
        if (principal == null || principal.isEmpty() || keytabFile == null || keytabFile.isEmpty()) {
            throw new RuntimeException("Kerberos principal and/or keytab are null or empty");
        }
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        LOG.info("Logging in as " + serverPrincipal + " via " + keytabFile);
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)serverPrincipal, (String)keytabFile);
    }

    public static void loginWithKerberosAndUpdateCurrentUser(String principal, String keytabFile) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (principal == null || principal.isEmpty() || keytabFile == null || keytabFile.isEmpty()) {
            throw new RuntimeException("Kerberos principal and/or keytab is null or empty");
        }
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        LOG.info("Logging in as " + serverPrincipal + " via " + keytabFile + " and updating current logged in user");
        UserGroupInformation.loginUserFromKeytab((String)serverPrincipal, (String)keytabFile);
    }

    public static String generateClusterName(Configuration conf) {
        String hosts = HiveConf.getTrimmedVar(conf, HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        return hostsRe.matcher(hosts.startsWith("@") ? hosts.substring(1) : hosts).replaceAll("_");
    }

    public static String getUserNameFromPrincipal(String principal) {
        if (principal == null) {
            return null;
        }
        String[] components = principal.split("[/@]");
        return components == null || components.length != 3 ? principal : components[0];
    }

    public static List<StatisticsData> getStatisticsForScheme(String scheme, List<StatisticsData> stats) {
        ArrayList<StatisticsData> result = new ArrayList<StatisticsData>();
        if (stats != null && scheme != null) {
            for (StatisticsData s : stats) {
                if (!s.getScheme().equalsIgnoreCase(scheme)) continue;
                result.add(s);
            }
        }
        return result;
    }

    public static Map<String, FileSystem.Statistics> getCombinedFileSystemStatistics() {
        List allStats = FileSystem.getAllStatistics();
        HashMap<String, FileSystem.Statistics> result = new HashMap<String, FileSystem.Statistics>();
        for (FileSystem.Statistics statistics : allStats) {
            String scheme = statistics.getScheme();
            if (result.containsKey(scheme)) {
                FileSystem.Statistics existing = (FileSystem.Statistics)result.get(scheme);
                FileSystem.Statistics combined = LlapUtil.combineFileSystemStatistics(existing, statistics);
                result.put(scheme, combined);
                continue;
            }
            result.put(scheme, statistics);
        }
        return result;
    }

    private static FileSystem.Statistics combineFileSystemStatistics(FileSystem.Statistics s1, FileSystem.Statistics s2) {
        FileSystem.Statistics result = new FileSystem.Statistics(s1);
        result.incrementReadOps(s2.getReadOps());
        result.incrementLargeReadOps(s2.getLargeReadOps());
        result.incrementWriteOps(s2.getWriteOps());
        result.incrementBytesRead(s2.getBytesRead());
        result.incrementBytesWritten(s2.getBytesWritten());
        return result;
    }

    public static List<StatisticsData> cloneThreadLocalFileSystemStatistics() {
        ArrayList<StatisticsData> result = new ArrayList<StatisticsData>();
        for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
            result.add(new StatisticsData(statistics.getScheme(), statistics.getThreadStatistics()));
        }
        return result;
    }

    public static String getAmHostNameFromAddress(InetSocketAddress address, Configuration conf) {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_DAEMON_AM_USE_FQDN)) {
            return address.getHostName();
        }
        InetAddress ia = address.getAddress();
        return ia == null ? address.getHostName() : ia.getCanonicalHostName();
    }

    public static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String suffix = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.2f%sB", (double)bytes / Math.pow(unit, exp), suffix);
    }

    public static RPC.Server createRpcServer(Class<?> pbProtocol, InetSocketAddress addr, Configuration conf, int numHandlers, BlockingService blockingService, SecretManager<?> secretManager, PolicyProvider provider, HiveConf.ConfVars ... aclVars) throws IOException {
        Configuration serverConf = conf;
        boolean isSecurityEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (isSecurityEnabled) {
            for (HiveConf.ConfVars acl : aclVars) {
                if (conf.get(acl.varname) != null) continue;
                if (serverConf == conf) {
                    serverConf = new Configuration(conf);
                }
                serverConf.set(acl.varname, HiveConf.getVar(serverConf, acl));
            }
        }
        RPC.setProtocolEngine((Configuration)serverConf, pbProtocol, ProtobufRpcEngine.class);
        RPC.Builder builder = new RPC.Builder(serverConf).setProtocol(pbProtocol).setInstance((Object)blockingService).setBindAddress(addr.getHostName()).setPort(addr.getPort()).setNumHandlers(numHandlers);
        if (secretManager != null) {
            builder = builder.setSecretManager(secretManager);
        }
        RPC.Server server = builder.build();
        if (isSecurityEnabled) {
            server.refreshServiceAcl(serverConf, provider);
        }
        return server;
    }

    public static RPC.Server startProtocolServer(int srvPort, int numHandlers, AtomicReference<InetSocketAddress> bindAddress, Configuration conf, BlockingService impl, Class<?> protocolClass, SecretManager<?> secretManager, PolicyProvider provider, HiveConf.ConfVars ... aclVars) {
        RPC.Server server;
        InetSocketAddress addr = new InetSocketAddress(srvPort);
        try {
            server = LlapUtil.createRpcServer(protocolClass, addr, conf, numHandlers, impl, secretManager, provider, aclVars);
            server.start();
        }
        catch (IOException e) {
            LOG.error("Failed to run RPC Server on port: " + srvPort, (Throwable)e);
            throw new RuntimeException(e);
        }
        InetSocketAddress serverBindAddress = NetUtils.getConnectAddress((Server)server);
        InetSocketAddress bindAddressVal = NetUtils.createSocketAddrForHost((String)serverBindAddress.getAddress().getCanonicalHostName(), (int)serverBindAddress.getPort());
        if (bindAddress != null) {
            bindAddress.set(bindAddressVal);
        }
        LOG.info("Instantiated " + protocolClass.getSimpleName() + " at " + bindAddressVal);
        return server;
    }

    public static String getDbAndTableNameForMetrics(Path path, boolean includeParts) {
        String[] parts = path.toUri().getPath().toString().split("/");
        int dbIx = -1;
        for (int i = 0; i < parts.length - 2; ++i) {
            if (!parts[i].endsWith(DATABASE_PATH_SUFFIX)) continue;
            if (dbIx >= 0) {
                dbIx = -1;
                break;
            }
            dbIx = i;
        }
        if (dbIx >= 0) {
            String dbAndTable = parts[dbIx].substring(0, parts[dbIx].length() - 3) + "." + parts[dbIx + 1];
            if (!includeParts) {
                return dbAndTable;
            }
            for (int i = dbIx + 2; i < parts.length && parts[i].contains("="); ++i) {
                dbAndTable = dbAndTable + "/" + parts[i];
            }
            return dbAndTable;
        }
        boolean isInPartFields = false;
        for (int i = parts.length - 2; i >= 0; --i) {
            String p = parts[i];
            boolean isPartField = p.contains("=");
            if (isInPartFields && !isPartField || !isPartField && !LlapUtil.isSomeHiveDir(p)) {
                dbIx = i - 1;
                break;
            }
            isInPartFields = isPartField;
        }
        if (dbIx >= 0) {
            String dbName = parts[dbIx];
            if (dbName.endsWith(DATABASE_PATH_SUFFIX)) {
                dbName = dbName.substring(0, dbName.length() - 3);
            }
            String dbAndTable = dbName + "." + parts[dbIx + 1];
            if (!includeParts) {
                return dbAndTable;
            }
            for (int i = dbIx + 2; i < parts.length && parts[i].contains("="); ++i) {
                dbAndTable = dbAndTable + "/" + parts[i];
            }
            return dbAndTable;
        }
        return "unknown";
    }

    private static boolean isSomeHiveDir(String p) {
        return p.startsWith(BASE_PREFIX) || p.startsWith(DELTA_PREFIX) || p.startsWith(BUCKET_PREFIX) || p.startsWith(UNION_SUDBIR_PREFIX) || p.startsWith(DELETE_DELTA_PREFIX);
    }

    public static class StatisticsData {
        long bytesRead;
        long bytesWritten;
        int readOps;
        int largeReadOps;
        int writeOps;
        String scheme;

        public StatisticsData(String scheme, FileSystem.Statistics.StatisticsData fsStats) {
            this.scheme = scheme;
            this.bytesRead = fsStats.getBytesRead();
            this.bytesWritten = fsStats.getBytesWritten();
            this.readOps = fsStats.getReadOps();
            this.largeReadOps = fsStats.getLargeReadOps();
            this.writeOps = fsStats.getWriteOps();
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public int getReadOps() {
            return this.readOps;
        }

        public int getLargeReadOps() {
            return this.largeReadOps;
        }

        public int getWriteOps() {
            return this.writeOps;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" scheme: ").append(this.scheme);
            sb.append(" bytesRead: ").append(this.bytesRead);
            sb.append(" bytesWritten: ").append(this.bytesWritten);
            sb.append(" readOps: ").append(this.readOps);
            sb.append(" largeReadOps: ").append(this.largeReadOps);
            sb.append(" writeOps: ").append(this.writeOps);
            return sb.toString();
        }
    }
}

