/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchBase;

public class FakeVectorRowBatchFromRepeats
extends FakeVectorRowBatchBase {
    private Long[] values;
    private int count;
    private int batchSize;
    private VectorizedRowBatch vrg;
    private final int numCols;

    public FakeVectorRowBatchFromRepeats(Long[] values, int count, int batchSize) {
        this.values = values;
        this.count = count;
        this.batchSize = batchSize;
        this.numCols = values.length;
        this.vrg = new VectorizedRowBatch(this.numCols, batchSize);
        for (int i = 0; i < this.numCols; ++i) {
            this.vrg.cols[i] = new LongColumnVector(batchSize);
        }
    }

    @Override
    public VectorizedRowBatch produceNextBatch() {
        this.vrg.size = 0;
        this.vrg.selectedInUse = false;
        if (this.count > 0) {
            this.vrg.size = this.batchSize < this.count ? this.batchSize : this.count;
            this.count -= this.vrg.size;
            for (int i = 0; i < this.numCols; ++i) {
                LongColumnVector col = (LongColumnVector)this.vrg.cols[i];
                col.isRepeating = true;
                Long value = this.values[i];
                if (value == null) {
                    col.isNull[0] = true;
                    col.noNulls = false;
                    continue;
                }
                col.noNulls = true;
                col.vector[0] = value;
            }
        }
        return this.vrg;
    }
}

