/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTestGenericUDFOPNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPMod
extends AbstractTestGenericUDFOPNumeric {
    @Test
    public void testModByZero1() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        ByteWritable b1 = new ByteWritable(4);
        ByteWritable b2 = new ByteWritable(0);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableByteObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)b1), new GenericUDF.DeferredJavaObject((Object)b2)};
        udf.initialize(inputOIs);
        ByteWritable b3 = (ByteWritable)udf.evaluate(args);
        Assert.assertNull((Object)b3);
    }

    @Test
    public void testModByZero2() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        ShortWritable s1 = new ShortWritable(4);
        ShortWritable s2 = new ShortWritable(0);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableShortObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)s1), new GenericUDF.DeferredJavaObject((Object)s2)};
        udf.initialize(inputOIs);
        ShortWritable s3 = (ShortWritable)udf.evaluate(args);
        Assert.assertNull((Object)s3);
    }

    @Test
    public void testModByZero3() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        IntWritable i1 = new IntWritable(4);
        IntWritable i2 = new IntWritable(0);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)i1), new GenericUDF.DeferredJavaObject((Object)i2)};
        udf.initialize(inputOIs);
        IntWritable i3 = (IntWritable)udf.evaluate(args);
        Assert.assertNull((Object)i3);
    }

    @Test
    public void testModByZero4() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        LongWritable l1 = new LongWritable(4L);
        LongWritable l2 = new LongWritable(0L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)l1), new GenericUDF.DeferredJavaObject((Object)l2)};
        udf.initialize(inputOIs);
        LongWritable l3 = (LongWritable)udf.evaluate(args);
        Assert.assertNull((Object)l3);
    }

    @Test
    public void testModByZero5() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        FloatWritable f1 = new FloatWritable(4.5f);
        FloatWritable f2 = new FloatWritable(0.0f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)f1), new GenericUDF.DeferredJavaObject((Object)f2)};
        udf.initialize(inputOIs);
        DoubleWritable f3 = (DoubleWritable)udf.evaluate(args);
        Assert.assertNull((Object)f3);
    }

    @Test
    public void testModByZero6() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        DoubleWritable d1 = new DoubleWritable(4.5);
        DoubleWritable d2 = new DoubleWritable(0.0);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableDoubleObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)d1), new GenericUDF.DeferredJavaObject((Object)d2)};
        udf.initialize(inputOIs);
        DoubleWritable d3 = (DoubleWritable)udf.evaluate(args);
        Assert.assertNull((Object)d3);
    }

    @Test
    public void testModByZero8() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        HiveDecimalWritable dec1 = new HiveDecimalWritable(HiveDecimal.create((String)"4.5"));
        HiveDecimalWritable dec2 = new HiveDecimalWritable(HiveDecimal.create((String)"0"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)2, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)1, (int)0))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)dec1), new GenericUDF.DeferredJavaObject((Object)dec2)};
        udf.initialize(inputOIs);
        HiveDecimalWritable dec3 = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertNull((Object)dec3);
    }

    @Test
    public void testDecimalModDecimal() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)4, (int)2), (Object)oi.getTypeInfo());
    }

    @Test
    public void testDecimalModDecimalSameParams() throws HiveException {
        GenericUDFOPMod udf = new GenericUDFOPMod();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2), (Object)oi.getTypeInfo());
    }
}

