/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public abstract class HiveMetaStoreAuthorizableEvent {
    protected final PreEventContext preEventContext;

    protected HiveMetaStoreAuthorizableEvent(PreEventContext preEventContext) {
        this.preEventContext = preEventContext;
    }

    public abstract HiveMetaStoreAuthzInfo getAuthzContext();

    protected String getSdLocation(StorageDescriptor sd) {
        return sd == null ? "" : sd.getLocation();
    }

    protected List<String> getCommandParams(String cmdStr, String objectName) {
        String commandString = objectName != null ? cmdStr + " " + objectName : cmdStr;
        return Collections.singletonList(commandString);
    }

    protected HivePrivilegeObject getHivePrivilegeObject(Database database) {
        return new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, database.getName(), null);
    }

    protected HivePrivilegeObject getHivePrivilegeObject(Table table) {
        return new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, table.getDbName(), table.getTableName());
    }

    protected HivePrivilegeObject getHivePrivilegeObjectDfsUri(String uri) {
        return new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI, null, uri);
    }

    protected HivePrivilegeObject getHivePrivilegeObjectLocalUri(String uri) {
        return new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI, null, uri);
    }
}

