/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.MapRDbJsonUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MapRDbJsonUpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MaterializedViewRebuildSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemanticAnalyzerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticAnalyzerFactory.class);
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.getInternal(queryState, tree);
        if (queryState.getHiveOperation() == null) {
            String query = queryState.getQueryString();
            if (query != null && query.length() > 30) {
                query = query.substring(0, 30);
            }
            String msg = "Unknown HiveOperation for query='" + query + "' queryId=" + queryState.getQueryId();
            LOG.debug(msg);
        }
        return sem;
    }

    private static BaseSemanticAnalyzer getInternal(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 832: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 833: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 890: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 835: {
                if (UpdateDeleteSemanticAnalyzer.isAcidExport(tree)) {
                    return new UpdateDeleteSemanticAnalyzer(queryState);
                }
                return new ExportSemanticAnalyzer(queryState);
            }
            case 859: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 968: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 969: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 970: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 720: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 721: 
                    case 722: 
                    case 723: 
                    case 724: 
                    case 729: 
                    case 730: 
                    case 731: 
                    case 732: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 739: 
                    case 740: 
                    case 742: 
                    case 745: 
                    case 747: 
                    case 748: 
                    case 750: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 752: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 753: 
                    case 754: 
                    case 755: 
                    case 756: 
                    case 757: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 956);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 759: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 761: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                    case 760: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new MaterializedViewRebuildSemanticAnalyzer(queryState);
                    }
                }
                queryState.setCommandType(null);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 710: 
            case 717: 
            case 718: 
            case 719: 
            case 727: 
            case 758: 
            case 762: 
            case 763: 
            case 764: 
            case 771: 
            case 781: 
            case 784: 
            case 787: 
            case 789: 
            case 790: 
            case 791: 
            case 809: 
            case 810: 
            case 811: 
            case 818: 
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: 
            case 827: 
            case 828: 
            case 847: 
            case 849: 
            case 880: 
            case 891: 
            case 892: 
            case 897: 
            case 975: 
            case 976: 
            case 995: 
            case 996: 
            case 997: 
            case 998: 
            case 999: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1034: 
            case 1080: 
            case 1089: 
            case 1090: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 782: 
            case 819: 
            case 961: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 765: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 783: 
            case 820: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 808: 
            case 895: 
            case 1093: {
                HiveConf hiveConf = queryState.getConf();
                if (MapRDbJsonUtils.isMapRDbJsonTable(tree, hiveConf)) {
                    return new MapRDbJsonUpdateDeleteSemanticAnalyzer(queryState);
                }
                if (AcidUtils.isAcidTable(tree, hiveConf)) {
                    return new UpdateDeleteSemanticAnalyzer(queryState);
                }
                throw new SemanticException(ErrorMsg.OPERATION_IS_NOT_SUPPORTED, new String[0]);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(832, HiveOperation.EXPLAIN);
        commandType.put(890, HiveOperation.LOAD);
        commandType.put(835, HiveOperation.EXPORT);
        commandType.put(859, HiveOperation.IMPORT);
        commandType.put(781, HiveOperation.CREATEDATABASE);
        commandType.put(818, HiveOperation.DROPDATABASE);
        commandType.put(1034, HiveOperation.SWITCHDATABASE);
        commandType.put(785, HiveOperation.CREATETABLE);
        commandType.put(1080, HiveOperation.TRUNCATETABLE);
        commandType.put(822, HiveOperation.DROPTABLE);
        commandType.put(811, HiveOperation.DESCTABLE);
        commandType.put(810, HiveOperation.DESCFUNCTION);
        commandType.put(897, HiveOperation.MSCK);
        commandType.put(721, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(742, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(740, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(739, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(730, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(723, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(747, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(724, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(748, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(738, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(731, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(732, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(729, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(722, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(750, HiveOperation.ALTERTABLE_UPDATECOLUMNS);
        commandType.put(997, HiveOperation.SHOWDATABASES);
        commandType.put(1003, HiveOperation.SHOWTABLES);
        commandType.put(995, HiveOperation.SHOWCOLUMNS);
        commandType.put(1014, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(1015, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(1006, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(1007, HiveOperation.SHOW_CREATETABLE);
        commandType.put(999, HiveOperation.SHOWFUNCTIONS);
        commandType.put(1002, HiveOperation.SHOWPARTITIONS);
        commandType.put(1000, HiveOperation.SHOWLOCKS);
        commandType.put(998, HiveOperation.SHOWLOCKS);
        commandType.put(996, HiveOperation.SHOWCONF);
        commandType.put(1004, HiveOperation.SHOWVIEWS);
        commandType.put(1001, HiveOperation.SHOWMATERIALIZEDVIEWS);
        commandType.put(782, HiveOperation.CREATEFUNCTION);
        commandType.put(819, HiveOperation.DROPFUNCTION);
        commandType.put(961, HiveOperation.RELOADFUNCTION);
        commandType.put(783, HiveOperation.CREATEMACRO);
        commandType.put(820, HiveOperation.DROPMACRO);
        commandType.put(786, HiveOperation.CREATEVIEW);
        commandType.put(788, HiveOperation.CREATE_MATERIALIZED_VIEW);
        commandType.put(823, HiveOperation.DROPVIEW);
        commandType.put(825, HiveOperation.DROP_MATERIALIZED_VIEW);
        commandType.put(756, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(755, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(753, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(754, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(736, HiveOperation.ALTERTABLE_OWNER);
        commandType.put(757, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(752, HiveOperation.ALTERVIEW_AS);
        commandType.put(761, HiveOperation.ALTER_MATERIALIZED_VIEW_REWRITE);
        commandType.put(956, HiveOperation.QUERY);
        commandType.put(892, HiveOperation.LOCKTABLE);
        commandType.put(1090, HiveOperation.UNLOCKTABLE);
        commandType.put(891, HiveOperation.LOCKDB);
        commandType.put(1089, HiveOperation.UNLOCKDB);
        commandType.put(784, HiveOperation.CREATEROLE);
        commandType.put(821, HiveOperation.DROPROLE);
        commandType.put(847, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(975, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(1008, HiveOperation.SHOW_GRANT);
        commandType.put(849, HiveOperation.GRANT_ROLE);
        commandType.put(976, HiveOperation.REVOKE_ROLE);
        commandType.put(1009, HiveOperation.SHOW_ROLES);
        commandType.put(1013, HiveOperation.SHOW_ROLES);
        commandType.put(1011, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(1010, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(719, HiveOperation.ALTERDATABASE);
        commandType.put(718, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(717, HiveOperation.ALTERDATABASE_LOCATION);
        commandType.put(809, HiveOperation.DESCDATABASE);
        commandType.put(745, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(765, HiveOperation.ANALYZE_TABLE);
        commandType.put(771, HiveOperation.CACHE_METADATA);
        commandType.put(737, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(1005, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(1016, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(710, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(1022, HiveOperation.START_TRANSACTION);
        commandType.put(779, HiveOperation.COMMIT);
        commandType.put(981, HiveOperation.ROLLBACK);
        commandType.put(993, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(968, HiveOperation.REPLDUMP);
        commandType.put(969, HiveOperation.REPLLOAD);
        commandType.put(970, HiveOperation.REPLSTATUS);
        commandType.put(880, HiveOperation.KILL_QUERY);
        commandType.put(790, HiveOperation.CREATE_RESOURCEPLAN);
        commandType.put(1012, HiveOperation.SHOW_RESOURCEPLAN);
        commandType.put(763, HiveOperation.ALTER_RESOURCEPLAN);
        commandType.put(827, HiveOperation.DROP_RESOURCEPLAN);
        commandType.put(791, HiveOperation.CREATE_TRIGGER);
        commandType.put(764, HiveOperation.ALTER_TRIGGER);
        commandType.put(828, HiveOperation.DROP_TRIGGER);
        commandType.put(789, HiveOperation.CREATE_POOL);
        commandType.put(762, HiveOperation.ALTER_POOL);
        commandType.put(826, HiveOperation.DROP_POOL);
        commandType.put(787, HiveOperation.CREATE_MAPPING);
        commandType.put(758, HiveOperation.ALTER_MAPPING);
        commandType.put(824, HiveOperation.DROP_MAPPING);
        commandType.put(808, HiveOperation.DELETE);
        tablePartitionCommandType.put(733, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(734, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(735, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(744, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(743, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(741, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(728, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(746, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(725, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(727, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(749, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(751, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

