/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.util;

import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.ojai.store.QueryCondition;

public final class MapRDbJsonParseUtil {
    private MapRDbJsonParseUtil() {
    }

    public static QueryCondition buildQueryCondition(Set<String> values) {
        ConditionImpl queryCondition = MapRDBImpl.newCondition();
        boolean first = true;
        for (String value : values) {
            if (first) {
                queryCondition = queryCondition.and().is("_id", QueryCondition.Op.NOT_EQUAL, value);
                first = false;
                continue;
            }
            queryCondition = queryCondition.is("_id", QueryCondition.Op.NOT_EQUAL, value);
        }
        return queryCondition.close().build();
    }

    public static Set<String> buildSingleValueSetToDelete(List<? extends Node> children) {
        HashSet<String> singleValueSetToDelete = new HashSet<String>();
        ASTNode whereNode = (ASTNode)children.get(1);
        ASTNode equalsNode = (ASTNode)((ArrayList)whereNode.getChildren()).get(0);
        ASTNode valueNode = (ASTNode)((ArrayList)equalsNode.getChildren()).get(1);
        singleValueSetToDelete.add(MapRDbJsonParseUtil.removeQuotes(valueNode.getText()));
        return Collections.unmodifiableSet(singleValueSetToDelete);
    }

    public static boolean isSingeEqualsClause(List<? extends Node> children, String columnId) throws SemanticException {
        if (children == null || children.size() < 2) {
            return false;
        }
        if (((ASTNode)children.get(1)).getToken().getType() != 1101) {
            return false;
        }
        ASTNode whereNode = (ASTNode)children.get(1);
        if (((ArrayList)whereNode.getChildren()).size() > 1) {
            return false;
        }
        ASTNode equalsNode = (ASTNode)((ArrayList)whereNode.getChildren()).get(0);
        if (!"=".equals(equalsNode.getText()) && !"==".equals(equalsNode.getText())) {
            return false;
        }
        if (((ArrayList)equalsNode.getChildren()).size() != 2) {
            return false;
        }
        ASTNode tabOrColNode = (ASTNode)((ArrayList)equalsNode.getChildren()).get(0);
        String deleteColumn = ((ASTNode)((ArrayList)tabOrColNode.getChildren()).get(0)).getToken().getText();
        if (!columnId.equalsIgnoreCase(deleteColumn)) {
            throw new SemanticException(ErrorMsg.DELETION_OVER_COLUMN_IS_FORBIDDEN, deleteColumn, columnId);
        }
        return true;
    }

    public static boolean isDeleteAllClause(List<? extends Node> children) {
        return children != null && children.size() == 1 && ((ASTNode)children.get(0)).getToken().getType() == 1063;
    }

    public static Set<String> buildSetToPreserve(List<? extends Node> children) {
        HashSet<String> valuesToPreserve = new HashSet<String>();
        ASTNode whereNode = (ASTNode)children.get(1);
        ASTNode notNode = (ASTNode)((ArrayList)whereNode.getChildren()).get(0);
        ASTNode functionNode = (ASTNode)((ArrayList)notNode.getChildren()).get(0);
        boolean first = true;
        boolean second = true;
        for (Node node : functionNode.getChildren()) {
            if (first) {
                first = false;
                continue;
            }
            if (second) {
                second = false;
                continue;
            }
            valuesToPreserve.add(MapRDbJsonParseUtil.removeQuotes(((ASTNode)node).getText()));
        }
        return Collections.unmodifiableSet(valuesToPreserve);
    }

    public static Set<String> buildSetToDelete(List<? extends Node> children) {
        HashSet<String> valuesToDelete = new HashSet<String>();
        ASTNode whereNode = (ASTNode)children.get(1);
        ASTNode functionNode = (ASTNode)((ArrayList)whereNode.getChildren()).get(0);
        boolean first = true;
        boolean second = true;
        for (Node node : functionNode.getChildren()) {
            if (first) {
                first = false;
                continue;
            }
            if (second) {
                second = false;
                continue;
            }
            valuesToDelete.add(MapRDbJsonParseUtil.removeQuotes(((ASTNode)node).getText()));
        }
        return Collections.unmodifiableSet(valuesToDelete);
    }

    public static boolean isNotInListClause(List<? extends Node> children, String columnId) throws SemanticException {
        if (children == null || children.size() < 2) {
            return false;
        }
        if (((ASTNode)children.get(1)).getToken().getType() != 1101) {
            return false;
        }
        ASTNode whereNode = (ASTNode)children.get(1);
        if (((ArrayList)whereNode.getChildren()).isEmpty() || ((ArrayList)whereNode.getChildren()).size() != 1) {
            return false;
        }
        ASTNode notNode = (ASTNode)((ArrayList)whereNode.getChildren()).get(0);
        if (!"not".equalsIgnoreCase(notNode.getText())) {
            return false;
        }
        if (((ASTNode)((ArrayList)notNode.getChildren()).get(0)).getToken().getType() != 844) {
            return false;
        }
        ASTNode functionNode = (ASTNode)((ArrayList)notNode.getChildren()).get(0);
        if (((ArrayList)functionNode.getChildren()).size() < 3) {
            return false;
        }
        if (((ASTNode)((ArrayList)functionNode.getChildren()).get(1)).getToken().getType() != 1060) {
            return false;
        }
        ASTNode inNode = (ASTNode)((ArrayList)functionNode.getChildren()).get(0);
        if (!"in".equalsIgnoreCase(inNode.getToken().getText())) {
            return false;
        }
        ASTNode tabOrColNode = (ASTNode)((ArrayList)functionNode.getChildren()).get(1);
        String deleteColumn = ((ASTNode)((ArrayList)tabOrColNode.getChildren()).get(0)).getToken().getText();
        if (!columnId.equalsIgnoreCase(deleteColumn)) {
            throw new SemanticException(ErrorMsg.DELETION_OVER_COLUMN_IS_FORBIDDEN, deleteColumn, columnId);
        }
        return true;
    }

    public static boolean isInListClause(List<? extends Node> children, String columnId) throws SemanticException {
        if (children == null || children.size() < 2) {
            return false;
        }
        if (((ASTNode)children.get(1)).getToken().getType() != 1101) {
            return false;
        }
        ASTNode whereNode = (ASTNode)children.get(1);
        if (((ArrayList)whereNode.getChildren()).isEmpty() || ((ArrayList)whereNode.getChildren()).size() != 1) {
            return false;
        }
        if (((ASTNode)((ArrayList)whereNode.getChildren()).get(0)).getToken().getType() != 844) {
            return false;
        }
        ASTNode functionNode = (ASTNode)((ArrayList)whereNode.getChildren()).get(0);
        if (((ArrayList)functionNode.getChildren()).size() < 3) {
            return false;
        }
        if (((ASTNode)((ArrayList)functionNode.getChildren()).get(1)).getToken().getType() != 1060) {
            return false;
        }
        ASTNode inNode = (ASTNode)((ArrayList)functionNode.getChildren()).get(0);
        if (!"in".equalsIgnoreCase(inNode.getToken().getText())) {
            return false;
        }
        ASTNode tabOrColNode = (ASTNode)((ArrayList)functionNode.getChildren()).get(1);
        String deleteColumn = ((ASTNode)((ArrayList)tabOrColNode.getChildren()).get(0)).getToken().getText();
        if (!columnId.equalsIgnoreCase(deleteColumn)) {
            throw new SemanticException(ErrorMsg.DELETION_OVER_COLUMN_IS_FORBIDDEN, deleteColumn, columnId);
        }
        return true;
    }

    public static boolean isWhenMatchedDeleteClause(ASTNode node) {
        List children = node.getChildren();
        if (children.isEmpty()) {
            return false;
        }
        ASTNode deleteNode = (ASTNode)children.get(0);
        if (deleteNode.getType() != 807) {
            return false;
        }
        return children.size() == 1;
    }

    public static boolean isSubQuery(ASTNode node) {
        return node.getType() == 1028;
    }

    private static String removeQuotes(String value) {
        return value.replace("\"", "").replace("'", "");
    }
}

