/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.ChronoField;

@Description(name="from_utc_timestamp_new", value="from_utc_timestamp_new(timestamp, string timezone) - Assumes given timestamp is UTC and converts to given timezone")
public class GenericUDFFromUtcTimestampNew
extends GenericUDF {
    static final Logger LOG = LoggerFactory.getLogger(GenericUDFFromUtcTimestamp.class);
    private transient PrimitiveObjectInspector[] argumentOIs;
    private transient PrimitiveObjectInspectorConverter.TextConverter textConverter;
    private transient ZoneId tzUTC = ZoneId.of("UTC");

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function " + this.getName() + " requires two argument, got " + arguments.length);
        }
        try {
            this.argumentOIs = new PrimitiveObjectInspector[2];
            this.argumentOIs[0] = (PrimitiveObjectInspector)arguments[0];
            this.argumentOIs[1] = (PrimitiveObjectInspector)arguments[1];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function " + this.getName() + " takes only primitive types");
        }
        this.textConverter = new PrimitiveObjectInspectorConverter.TextConverter(this.argumentOIs[1]);
        return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        ZoneId toTz;
        ZoneId fromTz;
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        Object o1 = arguments[1].get();
        if (o1 == null) {
            return null;
        }
        String converted0 = this.getLocalDateTime(o0, this.argumentOIs[0]).toString();
        if (converted0 == null) {
            return null;
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").appendLiteral("T").appendPattern("HH:mm[:ss]").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();
        LocalDateTime inputDateTime = LocalDateTime.from(formatter.parse(converted0));
        String tzStr = this.textConverter.convert(o1).toString();
        ZoneId timezone = ZoneId.of(tzStr);
        if (this.invert()) {
            fromTz = timezone;
            toTz = this.tzUTC;
        } else {
            fromTz = this.tzUTC;
            toTz = timezone;
        }
        ZonedDateTime dateTimeInTz = ZonedDateTime.of(inputDateTime, fromTz);
        ZonedDateTime resultDateTimeInTz = dateTimeInTz.withZoneSameInstant(toTz);
        return Timestamp.valueOf(resultDateTimeInTz.format(formatter).replace("T", " "));
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("Converting field ");
        sb.append(children[0]);
        sb.append(" from UTC to timezone: ");
        if (children.length > 1) {
            sb.append(children[1]);
        }
        return sb.toString();
    }

    public String getName() {
        return "from_utc_timestamp_new";
    }

    protected boolean invert() {
        return false;
    }

    private LocalDateTime getLocalDateTime(Object o, PrimitiveObjectInspector inputOI) {
        LocalDateTime result;
        if (o == null) {
            return null;
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").appendLiteral(" ").appendPattern("HH:mm[:ss]").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();
        long longValue = 0L;
        switch (inputOI.getPrimitiveCategory()) {
            case VOID: {
                result = null;
                break;
            }
            case BOOLEAN: {
                longValue = ((BooleanObjectInspector)inputOI).get(o) ? 1L : 0L;
                Instant instant = Instant.ofEpochMilli(longValue);
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case BYTE: {
                longValue = ((ByteObjectInspector)inputOI).get(o);
                Instant instant = Instant.ofEpochMilli(longValue);
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case SHORT: {
                longValue = ((ShortObjectInspector)inputOI).get(o);
                Instant instant = Instant.ofEpochMilli(longValue);
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case INT: {
                longValue = ((IntObjectInspector)inputOI).get(o);
                Instant instant = Instant.ofEpochMilli(longValue);
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case LONG: {
                longValue = ((LongObjectInspector)inputOI).get(o);
                Instant instant = Instant.ofEpochMilli(longValue);
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case FLOAT: {
                Instant instant = this.doubleToInstant(((FloatObjectInspector)inputOI).get(o));
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case DOUBLE: {
                Instant instant = this.doubleToInstant(((DoubleObjectInspector)inputOI).get(o));
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case DECIMAL: {
                Instant instant = this.decimalToInstant(((HiveDecimalObjectInspector)inputOI).getPrimitiveJavaObject(o));
                result = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)inputOI;
                String stringValue = soi.getPrimitiveJavaObject(o);
                result = LocalDateTime.from(formatter.parse(stringValue));
                break;
            }
            case CHAR: 
            case VARCHAR: {
                String stringValue = PrimitiveObjectInspectorUtils.getString(o, inputOI);
                result = LocalDateTime.from(formatter.parse(stringValue));
                break;
            }
            case DATE: {
                Timestamp ts = new Timestamp(((DateObjectInspector)inputOI).getPrimitiveWritableObject(o).get().getTime());
                result = LocalDateTime.from(formatter.parse(ts.toString()));
                break;
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampObjectInspector)inputOI).getPrimitiveWritableObject(o).getTimestamp();
                result = LocalDateTime.from(formatter.parse(ts.toString()));
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + inputOI.getTypeName());
            }
        }
        return result;
    }

    private Instant decimalToInstant(HiveDecimal dec) {
        HiveDecimalWritable nanosWritable = new HiveDecimalWritable(dec);
        nanosWritable.mutateFractionPortion();
        nanosWritable.mutateScaleByPowerOfTen(9);
        if (!nanosWritable.isSet() || !nanosWritable.isInt()) {
            return null;
        }
        int nanos = nanosWritable.intValue();
        if (nanos < 0) {
            nanos += 1000000000;
        }
        nanosWritable.setFromLong(nanos);
        HiveDecimalWritable nanoInstant = new HiveDecimalWritable(dec);
        nanoInstant.mutateScaleByPowerOfTen(9);
        nanoInstant.mutateSubtract(nanosWritable);
        nanoInstant.mutateScaleByPowerOfTen(-9);
        if (!nanoInstant.isSet() || !nanoInstant.isLong()) {
            return null;
        }
        long seconds = nanoInstant.longValue();
        Instant t = Instant.ofEpochMilli(seconds * 1000L);
        t = t.plusNanos(nanos);
        return t;
    }

    private Instant doubleToInstant(double doubleValue) {
        long seconds = (long)doubleValue;
        BigDecimal bd = new BigDecimal(String.valueOf(doubleValue));
        bd = bd.subtract(new BigDecimal(seconds)).multiply(new BigDecimal(1000000000));
        int nanos = bd.intValue();
        long millis = seconds * 1000L;
        if (nanos < 0) {
            millis -= 1000L;
            nanos += 1000000000;
        }
        Instant t = Instant.ofEpochMilli(millis);
        t = t.plusNanos(nanos);
        return t;
    }
}

