/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TaskHandle;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task<T extends Serializable>
implements Serializable,
Node {
    private static final long serialVersionUID = 1L;
    public transient HashMap<String, Long> taskCounters;
    public transient TaskHandle taskHandle;
    protected transient HiveConf conf;
    protected transient QueryState queryState;
    protected transient SessionState.LogHelper console;
    protected transient QueryPlan queryPlan;
    protected transient DriverContext driverContext;
    protected transient boolean clonedConf = false;
    protected transient String jobID;
    protected Task<? extends Serializable> backupTask;
    protected List<Task<? extends Serializable>> backupChildrenTasks = new ArrayList<Task<? extends Serializable>>();
    protected static transient Logger LOG = LoggerFactory.getLogger(Task.class);
    protected int taskTag = 0;
    private boolean isLocalMode = false;
    private boolean retryCmdWhenFail = false;
    public static final int NO_TAG = 0;
    public static final int COMMON_JOIN = 1;
    public static final int HINTED_MAPJOIN = 2;
    public static final int HINTED_MAPJOIN_LOCAL = 3;
    public static final int CONVERTED_MAPJOIN = 4;
    public static final int CONVERTED_MAPJOIN_LOCAL = 5;
    public static final int BACKUP_COMMON_JOIN = 6;
    public static final int MAPJOIN_ONLY_NOBACKUP = 7;
    public static final int CONVERTED_SORTMERGEJOIN = 8;
    public QueryDisplay queryDisplay = null;
    protected transient List<Task<? extends Serializable>> feedSubscribers;
    protected String id;
    protected T work;
    private TaskState taskState = TaskState.CREATED;
    private String statusMessage;
    private String diagnosticMesg;
    private transient boolean fetchSource;
    protected boolean rootTask;
    protected List<Task<? extends Serializable>> childTasks;
    protected List<Task<? extends Serializable>> parentTasks;
    private Throwable exception;

    public void setDiagnosticMessage(String diagnosticMesg) {
        this.diagnosticMesg = diagnosticMesg;
    }

    public String getDiagnosticsMessage() {
        return this.diagnosticMesg;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        this.updateStatusInQueryDisplay();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Task() {
        this.taskCounters = new HashMap();
    }

    public TaskHandle getTaskHandle() {
        return this.taskHandle;
    }

    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext driverContext, CompilationOpContext opContext) {
        this.queryPlan = queryPlan;
        this.setInitialized();
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.driverContext = driverContext;
        this.console = new SessionState.LogHelper(LOG);
    }

    public void setQueryDisplay(QueryDisplay queryDisplay) {
        this.queryDisplay = queryDisplay;
    }

    protected void updateStatusInQueryDisplay() {
        if (this.queryDisplay != null) {
            this.queryDisplay.updateTaskStatus(this);
        }
    }

    protected void setState(TaskState state) {
        this.taskState = state;
        this.updateStatusInQueryDisplay();
    }

    protected Hive getHive() {
        try {
            return Hive.getWithFastCheck(this.conf);
        }
        catch (HiveException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public int executeTask() {
        try {
            SessionState ss = SessionState.get();
            this.setStarted();
            if (ss != null) {
                ss.getHiveHistory().logPlanProgress(this.queryPlan);
            }
            int retval = this.execute(this.driverContext);
            this.setDone();
            if (ss != null) {
                ss.getHiveHistory().logPlanProgress(this.queryPlan);
            }
            return retval;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error: " + e.getMessage(), e);
        }
    }

    protected abstract int execute(DriverContext var1);

    public boolean isRootTask() {
        return this.rootTask;
    }

    public void setRootTask(boolean rootTask) {
        this.rootTask = rootTask;
    }

    public void setChildTasks(List<Task<? extends Serializable>> childTasks) {
        this.childTasks = childTasks;
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.getChildTasks();
    }

    public List<Task<? extends Serializable>> getChildTasks() {
        return this.childTasks;
    }

    public int getNumChild() {
        return this.childTasks == null ? 0 : this.childTasks.size();
    }

    public void setParentTasks(List<Task<? extends Serializable>> parentTasks) {
        this.parentTasks = parentTasks;
    }

    public List<Task<? extends Serializable>> getParentTasks() {
        return this.parentTasks;
    }

    public int getNumParent() {
        return this.parentTasks == null ? 0 : this.parentTasks.size();
    }

    public Task<? extends Serializable> getBackupTask() {
        return this.backupTask;
    }

    public void setBackupTask(Task<? extends Serializable> backupTask) {
        this.backupTask = backupTask;
    }

    public List<Task<? extends Serializable>> getBackupChildrenTasks() {
        return this.backupChildrenTasks;
    }

    public void setBackupChildrenTasks(List<Task<? extends Serializable>> backupChildrenTasks) {
        this.backupChildrenTasks = backupChildrenTasks;
    }

    public Task<? extends Serializable> getAndInitBackupTask() {
        if (this.backupTask != null) {
            if (this.backupChildrenTasks != null) {
                for (Task<? extends Serializable> backupChild : this.backupChildrenTasks) {
                    backupChild.getParentTasks().add(this.backupTask);
                }
            }
            this.removeFromChildrenTasks();
        }
        return this.backupTask;
    }

    public void removeFromChildrenTasks() {
        List<Task<Serializable>> childrenTasks = this.getChildTasks();
        if (childrenTasks == null) {
            return;
        }
        for (Task<Serializable> childTsk : childrenTasks) {
            childTsk.getParentTasks().remove(this);
            List<Task<Serializable>> siblingTasks = childTsk.getParentTasks();
            if (siblingTasks != null && siblingTasks.size() != 0) continue;
            childTsk.removeFromChildrenTasks();
        }
    }

    protected void saveJobIdToFile() throws IOException {
        SessionState ss = SessionState.get();
        if (ss != null) {
            Path path = ss.getActiveJobsPath();
            FileSystem fs = path.getFileSystem((Configuration)this.conf);
            FSDataOutputStream fsDataOutputStream = fs.create(new Path(path, this.jobID));
            fsDataOutputStream.close();
        }
    }

    protected void deleteFileWithJobId() throws IOException {
        Path jobIdPath;
        Path path;
        FileSystem fs;
        SessionState ss = SessionState.get();
        if (ss != null && (fs = (path = ss.getActiveJobsPath()).getFileSystem((Configuration)this.conf)).exists(jobIdPath = new Path(path, this.jobID))) {
            fs.delete(jobIdPath, true);
        }
    }

    public List<Task<? extends Serializable>> getDependentTasks() {
        return this.getChildTasks();
    }

    public boolean addDependentTask(Task<? extends Serializable> dependent) {
        boolean ret = false;
        if (this.getChildTasks() == null) {
            this.setChildTasks(new ArrayList<Task<? extends Serializable>>());
        }
        if (!this.getChildTasks().contains(dependent)) {
            ret = true;
            this.getChildTasks().add(dependent);
            if (dependent.getParentTasks() == null) {
                dependent.setParentTasks(new ArrayList<Task<? extends Serializable>>());
            }
            if (!dependent.getParentTasks().contains(this)) {
                dependent.getParentTasks().add(this);
            }
        }
        return ret;
    }

    public static List<Task<? extends Serializable>> findLeafs(List<Task<? extends Serializable>> rootTasks) {
        final ArrayList<Task<? extends Serializable>> leafTasks = new ArrayList<Task<? extends Serializable>>();
        NodeUtils.iterateTask(rootTasks, Task.class, new NodeUtils.Function<Task>(){

            @Override
            public void apply(Task task) {
                List<Task<Serializable>> dependents = task.getDependentTasks();
                if (dependents == null || dependents.isEmpty()) {
                    leafTasks.add(task);
                }
            }
        });
        return leafTasks;
    }

    public void removeDependentTask(Task<? extends Serializable> dependent) {
        if (this.getChildTasks() != null && this.getChildTasks().contains(dependent)) {
            this.getChildTasks().remove(dependent);
            if (dependent.getParentTasks() != null && dependent.getParentTasks().contains(this)) {
                dependent.getParentTasks().remove(this);
            }
        }
    }

    public void setStarted() {
        this.setState(TaskState.RUNNING);
    }

    public boolean started() {
        return this.taskState == TaskState.RUNNING;
    }

    public boolean done() {
        return this.taskState == TaskState.FINISHED;
    }

    public void setDone() {
        this.setState(TaskState.FINISHED);
    }

    public void setQueued() {
        this.setState(TaskState.QUEUED);
    }

    public boolean getQueued() {
        return this.taskState == TaskState.QUEUED;
    }

    public void setInitialized() {
        this.setState(TaskState.INITIALIZED);
    }

    public boolean getInitialized() {
        return this.taskState == TaskState.INITIALIZED;
    }

    public boolean isRunnable() {
        boolean isrunnable = true;
        if (this.parentTasks != null) {
            for (Task<? extends Serializable> parent : this.parentTasks) {
                if (parent.done()) continue;
                isrunnable = false;
                break;
            }
        }
        return isrunnable;
    }

    public void setWork(T work) {
        this.work = work;
    }

    public T getWork() {
        return this.work;
    }

    public Collection<MapWork> getMapWork() {
        return Collections.emptyList();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getExternalHandle() {
        return null;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public boolean isMapRedTask() {
        return false;
    }

    public boolean isMapRedLocalTask() {
        return false;
    }

    public Collection<Operator<? extends OperatorDesc>> getTopOperators() {
        return new LinkedList<Operator<? extends OperatorDesc>>();
    }

    public boolean hasReduce() {
        return false;
    }

    public Operator<? extends OperatorDesc> getReducer(MapWork work) {
        return null;
    }

    public HashMap<String, Long> getCounters() {
        return this.taskCounters;
    }

    public abstract StageType getType();

    public void subscribeFeed(Task<? extends Serializable> publisher) {
        if (publisher != this && super.ancestorOrSelf(this)) {
            if (publisher.getFeedSubscribers() == null) {
                publisher.setFeedSubscribers(new LinkedList<Task<? extends Serializable>>());
            }
            publisher.getFeedSubscribers().add(this);
        }
    }

    private boolean ancestorOrSelf(Task<? extends Serializable> desc) {
        if (this == desc) {
            return true;
        }
        List<Task<Serializable>> deps = this.getDependentTasks();
        if (deps != null) {
            for (Task<Serializable> d : deps) {
                if (!super.ancestorOrSelf(desc)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Task<? extends Serializable>> getFeedSubscribers() {
        return this.feedSubscribers;
    }

    public void setFeedSubscribers(List<Task<? extends Serializable>> s) {
        this.feedSubscribers = s;
    }

    protected void pushFeed(FeedType feedType, Object feedValue) {
        if (this.feedSubscribers != null) {
            for (Task<? extends Serializable> s : this.feedSubscribers) {
                s.receiveFeed(feedType, feedValue);
            }
        }
    }

    protected void receiveFeed(FeedType feedType, Object feedValue) {
    }

    protected void cloneConf() {
        if (!this.clonedConf) {
            this.clonedConf = true;
            this.conf = new HiveConf(this.conf);
        }
    }

    public void updateTaskMetrics(Metrics metrics) {
    }

    public int getTaskTag() {
        return this.taskTag;
    }

    public void setTaskTag(int taskTag) {
        this.taskTag = taskTag;
    }

    public boolean isLocalMode() {
        return this.isLocalMode;
    }

    public void setLocalMode(boolean isLocalMode) {
        this.isLocalMode = isLocalMode;
    }

    public boolean requireLock() {
        return false;
    }

    public boolean ifRetryCmdWhenFail() {
        return this.retryCmdWhenFail;
    }

    public void setRetryCmdWhenFail(boolean retryCmdWhenFail) {
        this.retryCmdWhenFail = retryCmdWhenFail;
    }

    public QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public void setDriverContext(DriverContext driverContext) {
        this.driverContext = driverContext;
    }

    public void setQueryPlan(QueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void shutdown() {
    }

    Throwable getException() {
        return this.exception;
    }

    protected void setException(Throwable ex) {
        this.exception = ex;
    }

    public void setConsole(SessionState.LogHelper console) {
        this.console = console;
    }

    public boolean isFetchSource() {
        return this.fetchSource;
    }

    public void setFetchSource(boolean fetchSource) {
        this.fetchSource = fetchSource;
    }

    public String toString() {
        return this.getId() + ":" + this.getType();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(String.valueOf(obj));
    }

    public static enum TaskState {
        INITIALIZED,
        QUEUED,
        RUNNING,
        FINISHED,
        CREATED,
        UNKNOWN;

    }

    public static enum FeedType {
        DYNAMIC_PARTITIONS;

    }
}

