/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hive.common.util.HiveVersionInfo;

public class MetaStoreSchemaInfo {
    private static final String SQL_FILE_EXTENSION = ".sql";
    private static final String UPGRADE_FILE_PREFIX = "upgrade-";
    private static final String INIT_FILE_PREFIX = "hive-schema-";
    private static final String VERSION_UPGRADE_LIST = "upgrade.order";
    private static final String PRE_UPGRADE_PREFIX = "pre-";
    private final String dbType;
    private final String[] hiveSchemaVersions;
    private final String hiveHome;
    private static final Map<String, String> EQUIVALENT_VERSIONS = ImmutableMap.builder().put("0.13.1", "0.13.0").put("1.0.0", "0.14.0").put("1.0.1", "1.0.0").put("1.1.1", "1.1.0").put("1.2.1", "1.2.0").put("2.3.6", "2.3.0").build();

    public MetaStoreSchemaInfo(String hiveHome, String dbType) throws HiveMetaException {
        this.hiveHome = hiveHome;
        this.dbType = dbType;
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try (FileReader fr = new FileReader(upgradeListFile);
             BufferedReader bfReader = new BufferedReader(fr);){
            String currSchemaVersion;
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new HiveMetaException("File " + upgradeListFile + "not found ", e);
        }
        catch (IOException e) {
            throw new HiveMetaException("Error reading " + upgradeListFile, e);
        }
        this.hiveSchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (MetaStoreSchemaInfo.getHiveSchemaVersion().equals(fromVersion)) {
            return upgradeScriptList;
        }
        int firstScript = this.hiveSchemaVersions.length;
        for (i = 0; i < this.hiveSchemaVersions.length; ++i) {
            if (!this.hiveSchemaVersions[i].startsWith(fromVersion)) continue;
            firstScript = i;
        }
        if (firstScript == this.hiveSchemaVersions.length) {
            throw new HiveMetaException("Unknown version specified for upgrade " + fromVersion + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.hiveSchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.hiveSchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = MetaStoreSchemaInfo.getHiveSchemaVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + toVersion + "." + this.dbType + SQL_FILE_EXTENSION;
        if (!new File(this.getMetaStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new HiveMetaException("Unknown version specified for initialization: " + toVersion);
        }
        return initScriptName;
    }

    public String getMetaStoreScriptDir() {
        return this.hiveHome + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + this.dbType;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return UPGRADE_FILE_PREFIX + fileVersion + "." + this.dbType + SQL_FILE_EXTENSION;
    }

    public static String getPreUpgradeScriptName(int index, String upgradeScriptName) {
        return PRE_UPGRADE_PREFIX + index + "-" + upgradeScriptName;
    }

    public static String getHiveSchemaVersion() {
        String hiveVersion = HiveVersionInfo.getShortVersion();
        String versionFromJar = HiveVersionInfo.getShortVersion();
        hiveVersion = versionFromJar.substring(0, versionFromJar.indexOf("-mapr"));
        return MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion);
    }

    private static String getEquivalentVersion(String hiveVersion) {
        String equivalentVersion = EQUIVALENT_VERSIONS.get(hiveVersion);
        if (equivalentVersion != null) {
            return equivalentVersion;
        }
        return hiveVersion;
    }

    public static boolean isVersionCompatible(String hiveVersion, String dbVersion) {
        if ((hiveVersion = MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion)).equals(dbVersion = MetaStoreSchemaInfo.getEquivalentVersion(dbVersion))) {
            return true;
        }
        String[] hiveVerParts = hiveVersion.split("\\.");
        String[] dbVerParts = dbVersion.split("\\.");
        if (hiveVerParts.length != 3 || dbVerParts.length != 3) {
            return false;
        }
        for (int i = 0; i < dbVerParts.length; ++i) {
            int hiveVerPart;
            int dbVerPart = Integer.parseInt(dbVerParts[i]);
            if (dbVerPart > (hiveVerPart = Integer.parseInt(hiveVerParts[i]))) {
                return true;
            }
            if (dbVerPart >= hiveVerPart) continue;
            return false;
        }
        return true;
    }
}

