/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFChr;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFChr {
    @Test
    public void testChr() throws HiveException {
        UDFChr udf = new UDFChr();
        double d = 48.0;
        float f = 48.0f;
        long l = 48L;
        int i = 48;
        short s = 48;
        this.runAndVerify(d, udf, "0");
        this.runAndVerify(f, udf, "0");
        this.runAndVerify(l, udf, "0");
        this.runAndVerify(i, udf, "0");
        this.runAndVerify(s, udf, "0");
        d = 65.123;
        f = 65.123f;
        l = 65L;
        i = 65;
        s = 65;
        this.runAndVerify(d, udf, "A");
        this.runAndVerify(f, udf, "A");
        this.runAndVerify(l, udf, "A");
        this.runAndVerify(i, udf, "A");
        this.runAndVerify(s, udf, "A");
        d = -65.123;
        f = -65.123f;
        l = -65L;
        i = -65;
        s = -65;
        this.runAndVerify(d, udf, "");
        this.runAndVerify(f, udf, "");
        this.runAndVerify(l, udf, "");
        this.runAndVerify(i, udf, "");
        this.runAndVerify(s, udf, "");
        d = 0.9;
        f = 0.9f;
        l = 0L;
        i = 0;
        s = 0;
        char nul = '\u0000';
        String nulString = String.valueOf(nul);
        this.runAndVerify(d, udf, nulString);
        this.runAndVerify(f, udf, nulString);
        this.runAndVerify(l, udf, nulString);
        this.runAndVerify(i, udf, nulString);
        this.runAndVerify(s, udf, nulString);
        d = 256.9;
        f = 256.9f;
        l = 256L;
        i = 256;
        s = 256;
        this.runAndVerify(d, udf, nulString);
        this.runAndVerify(f, udf, nulString);
        this.runAndVerify(l, udf, nulString);
        this.runAndVerify(i, udf, nulString);
        this.runAndVerify(s, udf, nulString);
        d = 321.9;
        f = 321.9f;
        l = 321L;
        i = 321;
        s = 321;
        this.runAndVerify(d, udf, "A");
        this.runAndVerify(f, udf, "A");
        this.runAndVerify(l, udf, "A");
        this.runAndVerify(i, udf, "A");
        this.runAndVerify(s, udf, "A");
        d = Double.MAX_VALUE;
        f = Float.MAX_VALUE;
        l = Long.MAX_VALUE;
        i = Integer.MAX_VALUE;
        s = Short.MAX_VALUE;
        this.runAndVerify(d, udf, "");
        this.runAndVerify(f, udf, "");
        this.runAndVerify(l, udf, "");
        this.runAndVerify(i, udf, "");
        this.runAndVerify(s, udf, "\u00ff");
    }

    private void runAndVerify(long v, UDFChr udf, String expV) throws HiveException {
        Text output = udf.evaluate(new LongWritable(v));
        this.verifyOutput(output, expV);
    }

    private void runAndVerify(int v, UDFChr udf, String expV) throws HiveException {
        Text output = udf.evaluate(new LongWritable((long)v));
        this.verifyOutput(output, expV);
    }

    private void runAndVerify(short v, UDFChr udf, String expV) throws HiveException {
        Text output = udf.evaluate(new LongWritable((long)v));
        this.verifyOutput(output, expV);
    }

    private void runAndVerify(double v, UDFChr udf, String expV) throws HiveException {
        Text output = udf.evaluate(new DoubleWritable(v));
        this.verifyOutput(output, expV);
    }

    private void runAndVerify(float v, UDFChr udf, String expV) throws HiveException {
        Text output = udf.evaluate(new DoubleWritable((double)v));
        this.verifyOutput(output, expV);
    }

    private void verifyOutput(Text output, String expV) {
        if (expV == null) {
            Assert.assertNull((Object)output);
        } else {
            Assert.assertNotNull((Object)output);
            Assert.assertEquals((String)"chr() test ", (Object)expV, (Object)output.toString());
        }
    }
}

