/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedColumnReaderTestBase;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedParquetRecordReader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestVectorizedColumnReader
extends VectorizedColumnReaderTestBase {
    static boolean isDictionaryEncoding = false;

    @BeforeClass
    public static void setup() throws IOException {
        TestVectorizedColumnReader.removeFile();
        TestVectorizedColumnReader.writeData(TestVectorizedColumnReader.initWriterFromFile(), isDictionaryEncoding);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        TestVectorizedColumnReader.removeFile();
    }

    @Test
    public void testIntRead() throws Exception {
        this.intRead(isDictionaryEncoding);
        this.longReadInt(isDictionaryEncoding);
        this.floatReadInt(isDictionaryEncoding);
        this.doubleReadInt(isDictionaryEncoding);
    }

    @Test
    public void testLongRead() throws Exception {
        this.longRead(isDictionaryEncoding);
        this.floatReadLong(isDictionaryEncoding);
        this.doubleReadLong(isDictionaryEncoding);
    }

    @Test
    public void testTimestamp() throws Exception {
        this.timestampRead(isDictionaryEncoding);
        this.stringReadTimestamp(isDictionaryEncoding);
    }

    @Test
    public void testDoubleRead() throws Exception {
        this.doubleRead(isDictionaryEncoding);
        this.stringReadDouble(isDictionaryEncoding);
    }

    @Test
    public void testFloatRead() throws Exception {
        this.floatRead(isDictionaryEncoding);
        this.doubleReadFloat(isDictionaryEncoding);
    }

    @Test
    public void testBooleanRead() throws Exception {
        this.booleanRead();
        this.stringReadBoolean();
    }

    @Test
    public void testBinaryRead() throws Exception {
        this.binaryRead(isDictionaryEncoding);
    }

    @Test
    public void testStructRead() throws Exception {
        this.structRead(isDictionaryEncoding);
    }

    @Test
    public void testNestedStructRead() throws Exception {
        this.nestedStructRead0(isDictionaryEncoding);
        this.nestedStructRead1(isDictionaryEncoding);
    }

    @Test
    public void structReadSomeNull() throws Exception {
        this.structReadSomeNull(isDictionaryEncoding);
    }

    @Test
    public void decimalRead() throws Exception {
        this.decimalRead(isDictionaryEncoding);
        this.stringReadDecimal(isDictionaryEncoding);
    }

    @Test
    public void testNullSplitForParquetReader() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        conf.set("columns", "int32_field");
        conf.set("columns.types", "int");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)true);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN, (String)"//tmp");
        TestVectorizedColumnReader.initialVectorizedRowBatchCtx(conf);
        VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader((InputSplit)null, new JobConf(conf));
        TestCase.assertFalse((boolean)reader.next(reader.createKey(), reader.createValue()));
    }
}

