/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.ClearScratchDirUtil;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearDanglingScratchDir
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ClearDanglingScratchDir.class);
    private boolean dryRun;
    private boolean verbose;
    private boolean useConsole;
    private String rootHDFSDir;
    private HiveConf conf;

    public static void main(String[] args) throws Exception {
        try {
            LogUtils.initHiveLog4j();
        }
        catch (LogUtils.LogInitializationException logInitializationException) {
            // empty catch block
        }
        Options opts = ClearDanglingScratchDir.createOptions();
        CommandLine cli = new GnuParser().parse(opts, args);
        if (cli.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("cleardanglingscratchdir (clear scratch dir left behind by dead HiveCli or HiveServer2)", opts);
            return;
        }
        boolean dryRun = false;
        boolean verbose = false;
        if (cli.hasOption("r")) {
            dryRun = true;
            SessionState.getConsole().printInfo("dry-run mode on");
        }
        if (cli.hasOption("v")) {
            verbose = true;
        }
        HiveConf conf = new HiveConf();
        String rootHDFSDir = cli.hasOption("s") ? cli.getOptionValue("s") : HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIR);
        ClearDanglingScratchDir clearDanglingScratchDirMain = new ClearDanglingScratchDir(dryRun, verbose, true, rootHDFSDir, conf);
        clearDanglingScratchDirMain.run();
    }

    public ClearDanglingScratchDir(boolean dryRun, boolean verbose, boolean useConsole, String rootHDFSDir, HiveConf conf) {
        this.dryRun = dryRun;
        this.verbose = verbose;
        this.useConsole = useConsole;
        this.rootHDFSDir = rootHDFSDir;
        this.conf = conf;
    }

    @Override
    public void run() {
        try {
            Path rootHDFSDirPath = new Path(this.rootHDFSDir);
            FileSystem fs = FileSystem.get((URI)rootHDFSDirPath.toUri(), (Configuration)this.conf);
            FileStatus[] userHDFSDirList = fs.listStatus(rootHDFSDirPath);
            ArrayList<Path> scratchDirToRemove = new ArrayList<Path>();
            for (FileStatus userHDFSDir : userHDFSDirList) {
                FileStatus[] scratchDirList;
                for (FileStatus scratchDir : scratchDirList = fs.listStatus(userHDFSDir.getPath())) {
                    long gracePeriodMs;
                    boolean inUse;
                    Path lockFilePath = new Path(scratchDir.getPath(), "inuse.lck");
                    Path activeJobsPath = new Path(scratchDir.getPath(), "active_jobs");
                    Path activeAppsPath = new Path(scratchDir.getPath(), "active_apps");
                    if (!fs.exists(lockFilePath)) {
                        String message = "Skipping " + scratchDir.getPath() + " since it does not contain " + "inuse.lck";
                        if (!this.verbose) continue;
                        this.consoleMessage(message);
                        continue;
                    }
                    boolean bl = inUse = ClearScratchDirUtil.hasActiveJobs(fs, activeJobsPath, this.conf) || ClearScratchDirUtil.hasActiveApps(fs, activeAppsPath, this.conf);
                    if (inUse) {
                        String message = scratchDir.getPath() + " is being used by live process";
                        if (!this.verbose) continue;
                        this.consoleMessage(message);
                        continue;
                    }
                    long lastModifiedTime = scratchDir.getModificationTime();
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastModifiedTime < (gracePeriodMs = HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SCRATCH_DIR_CLEANUP_GRACE_PERIOD, (TimeUnit)TimeUnit.MILLISECONDS))) {
                        if (!this.verbose) continue;
                        this.consoleMessage("Skipping " + scratchDir.getPath() + " because it was modified within the grace period.");
                        continue;
                    }
                    scratchDirToRemove.add(scratchDir.getPath());
                }
            }
            if (scratchDirToRemove.size() == 0) {
                this.consoleMessage("Cannot find any scratch directory to clear");
                return;
            }
            this.consoleMessage("Removing " + scratchDirToRemove.size() + " scratch directories");
            String localTmpDir = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCALSCRATCHDIR);
            for (Path scratchDir : scratchDirToRemove) {
                if (this.dryRun) {
                    System.out.println(scratchDir);
                } else {
                    boolean succ = fs.delete(scratchDir, true);
                    if (!succ) {
                        this.consoleMessage("Cannot remove " + scratchDir);
                    } else {
                        String message = scratchDir + " removed";
                        if (this.verbose) {
                            this.consoleMessage(message);
                        }
                    }
                }
                this.removeLocalTmpFiles(scratchDir.getName(), localTmpDir);
            }
        }
        catch (IOException | YarnException e) {
            this.consoleMessage("Unexpected exception " + e.getMessage());
        }
    }

    private void consoleMessage(String message) {
        if (this.useConsole) {
            SessionState.getConsole().printInfo(message);
        } else {
            LOG.info(message);
        }
    }

    private static Options createOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"dry-run");
        OptionBuilder.withDescription((String)"Generate a list of dangling scratch dir, printed on console");
        result.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"scratchdir");
        OptionBuilder.withDescription((String)"Specify a non-default location of the scratch dir");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.withDescription((String)"Print verbose message");
        result.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        result.addOption(OptionBuilder.create((char)'h'));
        return result;
    }

    private void removeLocalTmpFiles(String sessionName, String localTmpdir) {
        File[] files = new File(localTmpdir).listFiles();
        if (files != null) {
            for (File file : files) {
                boolean success = false;
                if (file.getName().startsWith(sessionName)) {
                    success = file.delete();
                }
                if (success) {
                    this.consoleMessage("While removing '" + sessionName + "' dangling scratch dir from MaprFS, local tmp session file '" + file.getPath() + "' has been cleaned as well.");
                    continue;
                }
                if (!file.getName().startsWith(sessionName)) continue;
                this.consoleMessage("Even though '" + sessionName + "' is marked as dangling session dir, local tmp session file '" + file.getPath() + "' could not be removed.");
            }
        }
    }
}

