/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class IfExprStringGroupColumnStringScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private int arg2Column;
    private byte[] arg3Scalar;
    private int outputColumn;

    public IfExprStringGroupColumnStringScalar(int arg1Column, int arg2Column, byte[] arg3Scalar, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Scalar = arg3Scalar;
        this.outputColumn = outputColumn;
    }

    public IfExprStringGroupColumnStringScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        BytesColumnVector arg2ColVector = (BytesColumnVector)batch.cols[this.arg2Column];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.initBuffer();
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        if (!arg2ColVector.isNull[i]) {
                            outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                        }
                    } else {
                        outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        if (!arg2ColVector.isNull[i]) {
                            outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                        }
                    } else {
                        outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                    }
                } else {
                    outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                    }
                } else {
                    outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        }
        arg2ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "String";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", col " + this.arg2Column + ", val " + IfExprStringGroupColumnStringScalar.displayUtf8Bytes(this.arg3Scalar);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

