/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import org.apache.hadoop.hive.ql.io.AcidOutputFormat;

public enum BucketCodec {
    V0(0){

        @Override
        public int decodeWriterId(int bucketProperty) {
            return bucketProperty;
        }

        @Override
        public int decodeStatementId(int bucketProperty) {
            return 0;
        }

        @Override
        public int encode(AcidOutputFormat.Options options) {
            return options.getBucket();
        }
    }
    ,
    V1(1){

        @Override
        public int decodeWriterId(int bucketProperty) {
            return (bucketProperty & 0xFFF0000) >>> 16;
        }

        @Override
        public int decodeStatementId(int bucketProperty) {
            return bucketProperty & 0xFFF;
        }

        @Override
        public int encode(AcidOutputFormat.Options options) {
            int statementId;
            int n = statementId = options.getStatementId() >= 0 ? options.getStatementId() : 0;
            assert (this.version >= 0 && this.version <= 7) : "Version out of range: " + this.version;
            if (options.getBucket() < 0 || options.getBucket() > 4095) {
                throw new IllegalArgumentException("bucketId out of range: " + options.getBucket());
            }
            if (statementId < 0 || statementId > 4095) {
                throw new IllegalArgumentException("statementId out of range: " + statementId);
            }
            return this.version << 29 | options.getBucket() << 16 | statementId;
        }
    };

    private static final int TOP3BITS_MASK = -536870912;
    private static final int NUM_VERSION_BITS = 3;
    private static final int NUM_BUCKET_ID_BITS = 12;
    private static final int NUM_STATEMENT_ID_BITS = 12;
    private static final int MAX_VERSION = 7;
    public static final int MAX_BUCKET_ID = 4095;
    private static final int MAX_STATEMENT_ID = 4095;
    final int version;

    public static BucketCodec determineVersion(int bucket) {
        try {
            return BucketCodec.getCodec((0xE0000000 & bucket) >>> 29);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage() + " Cannot decode version from " + bucket);
        }
    }

    public static BucketCodec getCodec(int version) {
        switch (version) {
            case 0: {
                return V0;
            }
            case 1: {
                return V1;
            }
        }
        throw new IllegalArgumentException("Illegal 'bucket' format. Version=" + version);
    }

    private BucketCodec(int version) {
        this.version = version;
    }

    public abstract int decodeWriterId(int var1);

    public abstract int decodeStatementId(int var1);

    public abstract int encode(AcidOutputFormat.Options var1);

    public int getVersion() {
        return this.version;
    }
}

