/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFExtractUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFExtractUnionValueConverter {
    private final StandardUnionObjectInspector unionObjectInspector = ObjectInspectorFactory.getStandardUnionObjectInspector(Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector));
    private final Object union = new StandardUnionObjectInspector.StandardUnion(0, (Object)"foo");
    private final GenericUDFExtractUnion.ValueConverter underTest = new GenericUDFExtractUnion.ValueConverter();

    @Test
    public void convertValue() {
        JavaStringObjectInspector inspector = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        String value = "foo";
        Object result = this.underTest.convert((Object)value, (ObjectInspector)inspector);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void convertList() {
        StandardListObjectInspector inspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.unionObjectInspector);
        List<Object> value = Arrays.asList(this.union);
        List result = (List)this.underTest.convert(value, (ObjectInspector)inspector);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result.get(0), (Matcher)CoreMatchers.is(Arrays.asList("foo", null)));
    }

    @Test
    public void convertMap() {
        StandardMapObjectInspector inspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)this.unionObjectInspector);
        Map<String, Object> value = Collections.singletonMap("bar", this.union);
        Map result = (Map)this.underTest.convert(value, (ObjectInspector)inspector);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result.get("bar"), (Matcher)CoreMatchers.is(Arrays.asList("foo", null)));
    }

    @Test
    public void convertStruct() {
        StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("foo"), Arrays.asList(this.unionObjectInspector));
        List<Object> value = Arrays.asList(this.union);
        List result = (List)this.underTest.convert(value, (ObjectInspector)inspector);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result.get(0), (Matcher)CoreMatchers.is(Arrays.asList("foo", null)));
    }

    @Test
    public void convertUnion() {
        List result = (List)this.underTest.convert(this.union, (ObjectInspector)this.unionObjectInspector);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(result.get(0), (Matcher)CoreMatchers.is((Object)"foo"));
        Assert.assertThat(result.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

