/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFExtractUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFExtractUnionObjectInspectorConverter {
    private final ObjectInspector unionObjectInspector = ObjectInspectorFactory.getStandardUnionObjectInspector(Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector));
    private final ObjectInspector structObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("tag_0", "tag_1"), Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector));
    private final GenericUDFExtractUnion.ObjectInspectorConverter underTest = new GenericUDFExtractUnion.ObjectInspectorConverter();

    @Test(expected=IllegalArgumentException.class)
    public void convertValue_NoUnionFound() {
        JavaStringObjectInspector inspector = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        this.underTest.convert((ObjectInspector)inspector);
    }

    @Test
    public void convertList() {
        StandardListObjectInspector inspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.unionObjectInspector);
        ObjectInspector result = this.underTest.convert((ObjectInspector)inspector);
        Assert.assertThat((Object)result.getTypeName(), (Matcher)CoreMatchers.is((Object)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.structObjectInspector).getTypeName()));
    }

    @Test
    public void convertMap() {
        StandardMapObjectInspector inspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)this.unionObjectInspector);
        ObjectInspector result = this.underTest.convert((ObjectInspector)inspector);
        Assert.assertThat((Object)result.getTypeName(), (Matcher)CoreMatchers.is((Object)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)this.structObjectInspector).getTypeName()));
    }

    @Test
    public void convertStruct() {
        List<String> names = Arrays.asList("foo");
        StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(names, Arrays.asList(this.unionObjectInspector));
        ObjectInspector result = this.underTest.convert((ObjectInspector)inspector);
        Assert.assertThat((Object)result.getTypeName(), (Matcher)CoreMatchers.is((Object)ObjectInspectorFactory.getStandardStructObjectInspector(names, Arrays.asList(this.structObjectInspector)).getTypeName()));
    }

    @Test
    public void convertUnion() {
        ObjectInspector result = this.underTest.convert(this.unionObjectInspector);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.structObjectInspector));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)CoreMatchers.is((Object)this.structObjectInspector.getTypeName()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void noChildUnions() {
        this.underTest.convert((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
    }
}

