/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedColumnReaderTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestVectorizedDictionaryEncodingColumnReader
extends VectorizedColumnReaderTestBase {
    static boolean isDictionaryEncoding = true;

    @BeforeClass
    public static void setup() throws IOException {
        TestVectorizedDictionaryEncodingColumnReader.removeFile();
        TestVectorizedDictionaryEncodingColumnReader.writeData(TestVectorizedDictionaryEncodingColumnReader.initWriterFromFile(), isDictionaryEncoding);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        TestVectorizedDictionaryEncodingColumnReader.removeFile();
    }

    @Test
    public void testIntRead() throws Exception {
        this.intRead(isDictionaryEncoding);
        this.longReadInt(isDictionaryEncoding);
        this.floatReadInt(isDictionaryEncoding);
        this.doubleReadInt(isDictionaryEncoding);
    }

    @Test
    public void testLongRead() throws Exception {
        this.longRead(isDictionaryEncoding);
        this.floatReadLong(isDictionaryEncoding);
        this.doubleReadLong(isDictionaryEncoding);
    }

    @Test
    public void testTimestamp() throws Exception {
        this.timestampRead(isDictionaryEncoding);
        this.stringReadTimestamp(isDictionaryEncoding);
    }

    @Test
    public void testDoubleRead() throws Exception {
        this.doubleRead(isDictionaryEncoding);
        this.stringReadDouble(isDictionaryEncoding);
    }

    @Test
    public void testFloatRead() throws Exception {
        this.floatRead(isDictionaryEncoding);
        this.doubleReadFloat(isDictionaryEncoding);
    }

    @Test
    public void testBinaryRead() throws Exception {
        this.binaryRead(isDictionaryEncoding);
    }

    @Test
    public void testStructRead() throws Exception {
        this.structRead(isDictionaryEncoding);
    }

    @Test
    public void testNestedStructRead() throws Exception {
        this.structRead(isDictionaryEncoding);
    }

    @Test
    public void structReadSomeNull() throws Exception {
        this.structReadSomeNull(isDictionaryEncoding);
    }

    @Test
    public void decimalRead() throws Exception {
        this.decimalRead(isDictionaryEncoding);
        this.stringReadDecimal(isDictionaryEncoding);
    }
}

