/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.io.IOContextMap;
import org.junit.Assert;
import org.junit.Test;

public class TestIOContextMap {
    private void syncThreadStart(CountDownLatch cdlIn, CountDownLatch cdlOut) {
        cdlIn.countDown();
        try {
            cdlOut.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testMRTezGlobalMap() throws Exception {
        int i;
        int THREAD_COUNT = 2;
        int ITER_COUNT = 1000;
        final AtomicInteger countdown = new AtomicInteger(1000);
        final CountDownLatch phase1End = new CountDownLatch(2);
        final IOContext[] results = new IOContext[1000];
        ExecutorService executor = Executors.newFixedThreadPool(2);
        final CountDownLatch cdlIn = new CountDownLatch(2);
        final CountDownLatch cdlOut = new CountDownLatch(1);
        FutureTask[] tasks = new FutureTask[2];
        for (i = 0; i < tasks.length; ++i) {
            tasks[i] = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int nextIx;
                    Configuration conf = new Configuration();
                    conf.set("fs.default.name", "file:///");
                    TestIOContextMap.this.syncThreadStart(cdlIn, cdlOut);
                    while ((nextIx = countdown.decrementAndGet()) >= 0) {
                        conf.set("iocontext.input.name", "Input " + nextIx);
                        results[nextIx] = IOContextMap.get((Configuration)conf);
                        if (nextIx != 0) continue;
                        break;
                    }
                    phase1End.countDown();
                    phase1End.await();
                    for (int i = 0; i < 1000; ++i) {
                        conf.set("iocontext.input.name", "Input " + i);
                        IOContext ctx = IOContextMap.get((Configuration)conf);
                        Assert.assertSame((Object)results[i], (Object)ctx);
                    }
                    return null;
                }
            });
            executor.execute(tasks[i]);
        }
        cdlIn.await();
        cdlOut.countDown();
        for (i = 0; i < tasks.length; ++i) {
            tasks[i].get();
        }
        Set resultSet = Sets.newIdentityHashSet();
        for (int i2 = 0; i2 < results.length; ++i2) {
            Assert.assertTrue((boolean)resultSet.add(results[i2]));
        }
    }

    @Test
    public void testTezLlapAttemptMap() throws Exception {
        int i;
        int THREAD_COUNT = 2;
        int ITER_COUNT = 1000;
        int ATTEMPT_COUNT = 3;
        final AtomicInteger countdown = new AtomicInteger(1000);
        final IOContext[] results = new IOContext[3000];
        ExecutorService executor = Executors.newFixedThreadPool(2);
        final CountDownLatch cdlIn = new CountDownLatch(2);
        final CountDownLatch cdlOut = new CountDownLatch(1);
        FutureTask[] tasks = new FutureTask[2];
        for (i = 0; i < tasks.length; ++i) {
            tasks[i] = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int nextIx;
                    final Configuration conf = new Configuration();
                    final Configuration conf2 = new Configuration();
                    TestIOContextMap.this.syncThreadStart(cdlIn, cdlOut);
                    while ((nextIx = countdown.decrementAndGet()) >= 0) {
                        String input1 = "Input " + nextIx;
                        conf.set("iocontext.input.name", input1);
                        for (int j = 0; j < 3; ++j) {
                            String attemptId = "Attempt " + nextIx + ":" + j;
                            IOContextMap.setThreadAttemptId((String)attemptId);
                            IOContext iOContext = IOContextMap.get((Configuration)conf);
                            results[nextIx * 3 + j] = iOContext;
                            final IOContext r1 = iOContext;
                            if (nextIx % 100 != 0) continue;
                            String input2 = "Input2 " + nextIx;
                            conf2.set("iocontext.input.name", input2);
                            final AtomicReference ref2 = new AtomicReference();
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    Assert.assertSame((Object)r1, (Object)IOContextMap.get((Configuration)conf));
                                    ref2.set(IOContextMap.get((Configuration)conf2));
                                }
                            });
                            t.start();
                            t.join();
                            Assert.assertSame(ref2.get(), (Object)IOContextMap.get((Configuration)conf2));
                        }
                        if (nextIx != 0) continue;
                        break;
                    }
                    return null;
                }
            });
            executor.execute(tasks[i]);
        }
        cdlIn.await();
        cdlOut.countDown();
        for (i = 0; i < tasks.length; ++i) {
            tasks[i].get();
        }
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        Set resultSet = Sets.newIdentityHashSet();
        for (int i2 = 0; i2 < 1000; ++i2) {
            conf.set("iocontext.input.name", "Input " + i2);
            for (int j = 0; j < 3; ++j) {
                String attemptId = "Attempt " + i2 + ":" + j;
                IOContext result = results[i2 * 3 + j];
                Assert.assertTrue((boolean)resultSet.add(result));
                IOContextMap.setThreadAttemptId((String)attemptId);
                Assert.assertSame((Object)result, (Object)IOContextMap.get((Configuration)conf));
                IOContextMap.clearThreadAttempt((String)attemptId);
                IOContextMap.setThreadAttemptId((String)attemptId);
                Assert.assertNotSame((Object)result, (Object)IOContextMap.get((Configuration)conf));
            }
        }
    }

    @Test
    public void testSparkThreadLocal() throws Exception {
        final Configuration conf1 = new Configuration();
        conf1.set(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, "spark");
        final Configuration conf2 = new Configuration(conf1);
        conf2.set("iocontext.input.name", "Other input");
        int THREAD_COUNT = 2;
        ExecutorService executor = Executors.newFixedThreadPool(2);
        final CountDownLatch cdlIn = new CountDownLatch(2);
        final CountDownLatch cdlOut = new CountDownLatch(1);
        FutureTask[] tasks = new FutureTask[2];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = new FutureTask<IOContext>(new Callable<IOContext>(){

                @Override
                public IOContext call() throws Exception {
                    TestIOContextMap.this.syncThreadStart(cdlIn, cdlOut);
                    IOContext c1 = IOContextMap.get((Configuration)conf1);
                    IOContext c2 = IOContextMap.get((Configuration)conf2);
                    Assert.assertSame((Object)c1, (Object)c2);
                    return c1;
                }
            });
            executor.execute(tasks[i]);
        }
        cdlIn.await();
        cdlOut.countDown();
        Set results = Sets.newIdentityHashSet();
        for (int i = 0; i < tasks.length; ++i) {
            Assert.assertTrue((boolean)results.add(tasks[i].get()));
        }
    }
}

