/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQueryHooks {
    private static HiveConf conf;
    private static QueryLifeTimeHookContext[] ctxs;

    @BeforeClass
    public static void setUpBeforeClass() {
        conf = new HiveConf(TestQueryHooks.class);
        conf.set("fs.default.name", "file:///");
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_LIFETIME_HOOKS, TestLifeTimeHook.class.getName());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
    }

    @Before
    public void setUpBefore() {
        ctxs = new QueryLifeTimeHookContext[4];
    }

    @Test
    public void testCompile() throws Exception {
        Driver driver = TestQueryHooks.createDriver();
        int ret = driver.compile("SELECT 1");
        Assert.assertEquals((String)"Expected compilation to succeed", (long)0L, (long)ret);
        Assert.assertNotNull((Object)ctxs[0]);
        Assert.assertNotNull((Object)ctxs[1]);
        Assert.assertNull((Object)ctxs[2]);
        Assert.assertNull((Object)ctxs[3]);
        Assert.assertEquals((Object)"SELECT 1", (Object)ctxs[0].getCommand());
        Assert.assertEquals((Object)"SELECT 1", (Object)ctxs[1].getCommand());
    }

    @Test
    public void testCompileFailure() {
        Driver driver = TestQueryHooks.createDriver();
        int ret = driver.compile("SELECT * FROM foo");
        Assert.assertNotEquals((String)"Expected compilation to fail", (long)0L, (long)ret);
        Assert.assertNotNull((Object)ctxs[0]);
        Assert.assertNotNull((Object)ctxs[1]);
        Assert.assertNull((Object)ctxs[2]);
        Assert.assertNull((Object)ctxs[3]);
        Assert.assertEquals((Object)"SELECT * FROM foo", (Object)ctxs[0].getCommand());
        Assert.assertEquals((Object)"SELECT * FROM foo", (Object)ctxs[1].getCommand());
    }

    @Test
    public void testAll() throws Exception {
        Driver driver = TestQueryHooks.createDriver();
        int ret = driver.run("SELECT 1").getResponseCode();
        Assert.assertEquals((String)"Expected query to run", (long)0L, (long)ret);
        Assert.assertNotNull((Object)ctxs[0]);
        Assert.assertNotNull((Object)ctxs[1]);
        Assert.assertNotNull((Object)ctxs[2]);
        Assert.assertNotNull((Object)ctxs[3]);
        for (int i = 0; i < ctxs.length; ++i) {
            Assert.assertEquals((Object)"SELECT 1", (Object)ctxs[i].getCommand());
        }
        Assert.assertNotNull((Object)ctxs[2].getHookContext());
        Assert.assertNotNull((Object)ctxs[3].getHookContext());
    }

    private static Driver createDriver() {
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        driver.init();
        return driver;
    }

    private static class TestLifeTimeHook
    implements QueryLifeTimeHook {
        public void beforeCompile(QueryLifeTimeHookContext ctx) {
            ctxs[0] = ctx;
        }

        public void afterCompile(QueryLifeTimeHookContext ctx, boolean hasError) {
            ctxs[1] = ctx;
        }

        public void beforeExecution(QueryLifeTimeHookContext ctx) {
            ctxs[2] = ctx;
        }

        public void afterExecution(QueryLifeTimeHookContext ctx, boolean hasError) {
            ctxs[3] = ctx;
        }
    }
}

