/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.MapRDbJsonUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MapRDbJsonUpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 755: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 756: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 815: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 758: {
                return new ExportSemanticAnalyzer(queryState);
            }
            case 782: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 887: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 888: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 889: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 660: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 676: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 681: 
                    case 684: 
                    case 686: 
                    case 687: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 690: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 691: 
                    case 692: 
                    case 693: 
                    case 694: 
                    case 695: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 880);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 651: 
            case 655: 
            case 656: 
            case 657: 
            case 658: 
            case 659: 
            case 667: 
            case 703: 
            case 711: 
            case 713: 
            case 716: 
            case 735: 
            case 736: 
            case 737: 
            case 744: 
            case 746: 
            case 748: 
            case 749: 
            case 750: 
            case 751: 
            case 770: 
            case 772: 
            case 816: 
            case 817: 
            case 822: 
            case 894: 
            case 895: 
            case 913: 
            case 914: 
            case 915: 
            case 916: 
            case 917: 
            case 918: 
            case 919: 
            case 920: 
            case 921: 
            case 922: 
            case 923: 
            case 924: 
            case 925: 
            case 926: 
            case 927: 
            case 928: 
            case 929: 
            case 930: 
            case 931: 
            case 932: 
            case 933: 
            case 951: 
            case 994: 
            case 1002: 
            case 1003: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 712: 
            case 745: 
            case 884: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 696: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 715: 
            case 747: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 734: 
            case 820: 
            case 1005: {
                HiveConf hiveConf = queryState.getConf();
                if (MapRDbJsonUtils.isMapRDbJsonTable(tree, hiveConf)) {
                    return new MapRDbJsonUpdateDeleteSemanticAnalyzer(queryState);
                }
                if (AcidUtils.isAcidTable(tree, hiveConf)) {
                    return new UpdateDeleteSemanticAnalyzer(queryState);
                }
                throw new SemanticException(ErrorMsg.OPERATION_IS_NOT_SUPPORTED, new String[0]);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(755, HiveOperation.EXPLAIN);
        commandType.put(815, HiveOperation.LOAD);
        commandType.put(758, HiveOperation.EXPORT);
        commandType.put(782, HiveOperation.IMPORT);
        commandType.put(711, HiveOperation.CREATEDATABASE);
        commandType.put(744, HiveOperation.DROPDATABASE);
        commandType.put(951, HiveOperation.SWITCHDATABASE);
        commandType.put(717, HiveOperation.CREATETABLE);
        commandType.put(994, HiveOperation.TRUNCATETABLE);
        commandType.put(749, HiveOperation.DROPTABLE);
        commandType.put(737, HiveOperation.DESCTABLE);
        commandType.put(736, HiveOperation.DESCFUNCTION);
        commandType.put(822, HiveOperation.MSCK);
        commandType.put(661, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(681, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(679, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(678, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(670, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(663, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(686, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(664, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(687, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(677, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(671, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(672, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(669, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(662, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(915, HiveOperation.SHOWDATABASES);
        commandType.put(921, HiveOperation.SHOWTABLES);
        commandType.put(913, HiveOperation.SHOWCOLUMNS);
        commandType.put(931, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(932, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(924, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(925, HiveOperation.SHOW_CREATETABLE);
        commandType.put(917, HiveOperation.SHOWFUNCTIONS);
        commandType.put(918, HiveOperation.SHOWINDEXES);
        commandType.put(920, HiveOperation.SHOWPARTITIONS);
        commandType.put(919, HiveOperation.SHOWLOCKS);
        commandType.put(916, HiveOperation.SHOWLOCKS);
        commandType.put(914, HiveOperation.SHOWCONF);
        commandType.put(922, HiveOperation.SHOWVIEWS);
        commandType.put(712, HiveOperation.CREATEFUNCTION);
        commandType.put(745, HiveOperation.DROPFUNCTION);
        commandType.put(884, HiveOperation.RELOADFUNCTION);
        commandType.put(715, HiveOperation.CREATEMACRO);
        commandType.put(747, HiveOperation.DROPMACRO);
        commandType.put(718, HiveOperation.CREATEVIEW);
        commandType.put(719, HiveOperation.CREATE_MATERIALIZED_VIEW);
        commandType.put(750, HiveOperation.DROPVIEW);
        commandType.put(751, HiveOperation.DROP_MATERIALIZED_VIEW);
        commandType.put(713, HiveOperation.CREATEINDEX);
        commandType.put(746, HiveOperation.DROPINDEX);
        commandType.put(659, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(658, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(694, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(693, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(691, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(692, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(695, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(690, HiveOperation.ALTERVIEW_AS);
        commandType.put(880, HiveOperation.QUERY);
        commandType.put(817, HiveOperation.LOCKTABLE);
        commandType.put(1003, HiveOperation.UNLOCKTABLE);
        commandType.put(816, HiveOperation.LOCKDB);
        commandType.put(1002, HiveOperation.UNLOCKDB);
        commandType.put(716, HiveOperation.CREATEROLE);
        commandType.put(748, HiveOperation.DROPROLE);
        commandType.put(770, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(894, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(926, HiveOperation.SHOW_GRANT);
        commandType.put(772, HiveOperation.GRANT_ROLE);
        commandType.put(895, HiveOperation.REVOKE_ROLE);
        commandType.put(927, HiveOperation.SHOW_ROLES);
        commandType.put(930, HiveOperation.SHOW_ROLES);
        commandType.put(929, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(928, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(657, HiveOperation.ALTERDATABASE);
        commandType.put(656, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(655, HiveOperation.ALTERDATABASE_LOCATION);
        commandType.put(735, HiveOperation.DESCDATABASE);
        commandType.put(684, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(696, HiveOperation.ANALYZE_TABLE);
        commandType.put(703, HiveOperation.CACHE_METADATA);
        commandType.put(676, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(923, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(933, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(651, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(939, HiveOperation.START_TRANSACTION);
        commandType.put(710, HiveOperation.COMMIT);
        commandType.put(900, HiveOperation.ROLLBACK);
        commandType.put(911, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(887, HiveOperation.EXPORT);
        commandType.put(888, HiveOperation.IMPORT);
        commandType.put(889, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(734, HiveOperation.DELETE);
        tablePartitionCommandType.put(673, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(674, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(675, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(683, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(682, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(680, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(668, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(685, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(665, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(667, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(688, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(689, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

