/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdPredicates;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;

public class HiveRelMdPredicates
implements MetadataHandler<BuiltInMetadata.Predicates> {
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.PREDICATES.method, (MetadataHandler)new HiveRelMdPredicates()), (Object)RelMdPredicates.SOURCE));
    private static final List<RexNode> EMPTY_LIST = ImmutableList.of();

    private HiveRelMdPredicates() {
    }

    public MetadataDef<BuiltInMetadata.Predicates> getDef() {
        return BuiltInMetadata.Predicates.DEF;
    }

    public RelOptPredicateList getPredicates(Project project, RelMetadataQuery mq) {
        RelNode child = project.getInput();
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelOptPredicateList childInfo = mq.getPulledUpPredicates(child);
        ArrayList<RexNode> projectPullUpPredicates = new ArrayList<RexNode>();
        HashMultimap inpIndxToOutIndxMap = HashMultimap.create();
        ImmutableBitSet.Builder columnsMappedBuilder = ImmutableBitSet.builder();
        Mapping m = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)child.getRowType().getFieldCount(), (int)project.getRowType().getFieldCount());
        for (Ord o : Ord.zip((List)project.getProjects())) {
            if (!(o.e instanceof RexInputRef)) continue;
            int sIdx = ((RexInputRef)o.e).getIndex();
            m.set(sIdx, o.i);
            inpIndxToOutIndxMap.put((Object)sIdx, (Object)o.i);
            columnsMappedBuilder.set(sIdx);
        }
        ImmutableBitSet columnsMapped = columnsMappedBuilder.build();
        for (RexNode r : childInfo.pulledUpPredicates) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits((RexNode)r);
            if (!columnsMapped.contains(rCols)) continue;
            r = (RexNode)r.accept((RexVisitor)new RexPermuteInputsShuttle((Mappings.TargetMapping)m, new RelNode[]{child}));
            projectPullUpPredicates.add(r);
        }
        for (Ord expr : Ord.zip((List)project.getProjects())) {
            if (RexLiteral.isNullLiteral((RexNode)((RexNode)expr.e))) {
                projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rexBuilder.makeInputRef((RelNode)project, expr.i)}));
                continue;
            }
            if (expr.e instanceof RexLiteral) {
                RexLiteral literal = (RexLiteral)expr.e;
                projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef((RelNode)project, expr.i), literal}));
                continue;
            }
            if (!(expr.e instanceof RexCall) || !HiveCalciteUtil.isDeterministicFuncOnLiterals((RexNode)expr.e)) continue;
            projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef((RelNode)project, expr.i), (RexNode)expr.e}));
        }
        return RelOptPredicateList.of(projectPullUpPredicates);
    }

    public RelOptPredicateList getPredicates(Join join, RelMetadataQuery mq) {
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode left = join.getInput(0);
        RelNode right = join.getInput(1);
        RelOptPredicateList leftInfo = mq.getPulledUpPredicates(left);
        RelOptPredicateList rightInfo = mq.getPulledUpPredicates(right);
        JoinConditionBasedPredicateInference jI = new JoinConditionBasedPredicateInference(join, RexUtil.composeConjunction((RexBuilder)rB, (Iterable)leftInfo.pulledUpPredicates, (boolean)false), RexUtil.composeConjunction((RexBuilder)rB, (Iterable)rightInfo.pulledUpPredicates, (boolean)false));
        return jI.inferPredicates(false);
    }

    public RelOptPredicateList getPredicates(Aggregate agg, RelMetadataQuery mq) {
        RelNode input = agg.getInput();
        RelOptPredicateList inputInfo = mq.getPulledUpPredicates(input);
        ArrayList<RexNode> aggPullUpPredicates = new ArrayList<RexNode>();
        ImmutableBitSet groupKeys = agg.getGroupSet();
        Mapping m = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)input.getRowType().getFieldCount(), (int)agg.getRowType().getFieldCount());
        int i = 0;
        Iterator iterator = groupKeys.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            m.set(j, i++);
        }
        for (RexNode r : inputInfo.pulledUpPredicates) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits((RexNode)r);
            if (rCols.isEmpty() || !groupKeys.contains(rCols)) continue;
            r = (RexNode)r.accept((RexVisitor)new RexPermuteInputsShuttle((Mappings.TargetMapping)m, new RelNode[]{input}));
            aggPullUpPredicates.add(r);
        }
        return RelOptPredicateList.of(aggPullUpPredicates);
    }

    public RelOptPredicateList getPredicates(Union union, RelMetadataQuery mq) {
        RexBuilder rB = union.getCluster().getRexBuilder();
        HashMap finalPreds = new HashMap();
        ArrayList<RexNode> finalResidualPreds = new ArrayList<RexNode>();
        for (int i = 0; i < union.getInputs().size(); ++i) {
            RelNode input = (RelNode)union.getInputs().get(i);
            RelOptPredicateList info = mq.getPulledUpPredicates(input);
            if (info.pulledUpPredicates.isEmpty()) {
                return RelOptPredicateList.EMPTY;
            }
            HashMap<String, RexNode> preds = new HashMap<String, RexNode>();
            ArrayList<RexNode> residualPreds = new ArrayList<RexNode>();
            for (RexNode rexNode : info.pulledUpPredicates) {
                String predString = rexNode.toString();
                if (i == 0) {
                    preds.put(predString, rexNode);
                    continue;
                }
                if (finalPreds.containsKey(predString)) {
                    preds.put(predString, rexNode);
                    continue;
                }
                residualPreds.add(rexNode);
            }
            finalResidualPreds.add(RexUtil.composeConjunction((RexBuilder)rB, residualPreds, (boolean)false));
            for (Map.Entry entry : finalPreds.entrySet()) {
                if (preds.containsKey(entry.getKey())) continue;
                for (int j = 0; j < i; ++j) {
                    finalResidualPreds.set(j, RexUtil.composeConjunction((RexBuilder)rB, (Iterable)Lists.newArrayList((Object[])new RexNode[]{(RexNode)finalResidualPreds.get(j), (RexNode)entry.getValue()}), (boolean)false));
                }
            }
            finalPreds = preds;
        }
        ArrayList preds = new ArrayList(finalPreds.values());
        RexNode disjPred = RexUtil.composeDisjunction((RexBuilder)rB, finalResidualPreds, (boolean)false);
        if (!disjPred.isAlwaysTrue()) {
            preds.add(disjPred);
        }
        return RelOptPredicateList.of(preds);
    }

    static class JoinConditionBasedPredicateInference {
        final Join joinRel;
        final boolean isSemiJoin;
        final int nSysFields;
        final int nFieldsLeft;
        final int nFieldsRight;
        final ImmutableBitSet leftFieldsBitSet;
        final ImmutableBitSet rightFieldsBitSet;
        final ImmutableBitSet allFieldsBitSet;
        SortedMap<Integer, BitSet> equivalence;
        final Map<String, ImmutableBitSet> exprFields;
        final Set<String> allExprsDigests;
        final Set<String> equalityPredicates;
        final RexNode leftChildPredicates;
        final RexNode rightChildPredicates;

        public JoinConditionBasedPredicateInference(Join joinRel, RexNode lPreds, RexNode rPreds) {
            this(joinRel, joinRel instanceof SemiJoin, lPreds, rPreds);
        }

        private JoinConditionBasedPredicateInference(Join joinRel, boolean isSemiJoin, RexNode lPreds, RexNode rPreds) {
            this.joinRel = joinRel;
            this.isSemiJoin = isSemiJoin;
            this.nFieldsLeft = joinRel.getLeft().getRowType().getFieldList().size();
            this.nFieldsRight = joinRel.getRight().getRowType().getFieldList().size();
            this.nSysFields = joinRel.getSystemFieldList().size();
            this.leftFieldsBitSet = ImmutableBitSet.range((int)this.nSysFields, (int)(this.nSysFields + this.nFieldsLeft));
            this.rightFieldsBitSet = ImmutableBitSet.range((int)(this.nSysFields + this.nFieldsLeft), (int)(this.nSysFields + this.nFieldsLeft + this.nFieldsRight));
            this.allFieldsBitSet = ImmutableBitSet.range((int)0, (int)(this.nSysFields + this.nFieldsLeft + this.nFieldsRight));
            this.exprFields = Maps.newHashMap();
            this.allExprsDigests = new HashSet<String>();
            if (lPreds == null) {
                this.leftChildPredicates = null;
            } else {
                Mappings.TargetMapping leftMapping = Mappings.createShiftMapping((int)(this.nSysFields + this.nFieldsLeft), (int[])new int[]{this.nSysFields, 0, this.nFieldsLeft});
                this.leftChildPredicates = (RexNode)lPreds.accept((RexVisitor)new RexPermuteInputsShuttle(leftMapping, new RelNode[]{joinRel.getInput(0)}));
                for (RexNode r : RelOptUtil.conjunctions((RexNode)this.leftChildPredicates)) {
                    this.exprFields.put(r.toString(), RelOptUtil.InputFinder.bits((RexNode)r));
                    this.allExprsDigests.add(r.toString());
                }
            }
            if (rPreds == null) {
                this.rightChildPredicates = null;
            } else {
                Mappings.TargetMapping rightMapping = Mappings.createShiftMapping((int)(this.nSysFields + this.nFieldsLeft + this.nFieldsRight), (int[])new int[]{this.nSysFields + this.nFieldsLeft, 0, this.nFieldsRight});
                this.rightChildPredicates = (RexNode)rPreds.accept((RexVisitor)new RexPermuteInputsShuttle(rightMapping, new RelNode[]{joinRel.getInput(1)}));
                for (RexNode r : RelOptUtil.conjunctions((RexNode)this.rightChildPredicates)) {
                    this.exprFields.put(r.toString(), RelOptUtil.InputFinder.bits((RexNode)r));
                    this.allExprsDigests.add(r.toString());
                }
            }
            this.equivalence = Maps.newTreeMap();
            this.equalityPredicates = new HashSet<String>();
            for (int i = 0; i < this.nSysFields + this.nFieldsLeft + this.nFieldsRight; ++i) {
                this.equivalence.put(i, BitSets.of((int[])new int[]{i}));
            }
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            List exprs = RelOptUtil.conjunctions((RexNode)this.compose(rexBuilder, (Iterable<RexNode>)ImmutableList.of((Object)joinRel.getCondition())));
            final EquivalenceFinder eF = new EquivalenceFinder();
            new ArrayList(Lists.transform((List)exprs, (Function)new Function<RexNode, Void>(){

                public Void apply(RexNode input) {
                    return (Void)input.accept((RexVisitor)eF);
                }
            }));
            this.equivalence = BitSets.closure(this.equivalence);
        }

        public RelOptPredicateList inferPredicates(boolean includeEqualityInference) {
            ArrayList<RexNode> inferredPredicates = new ArrayList<RexNode>();
            ArrayList<RexNode> nonFieldsPredicates = new ArrayList<RexNode>();
            HashSet<String> allExprsDigests = new HashSet<String>(this.allExprsDigests);
            JoinRelType joinType = this.joinRel.getJoinType();
            ImmutableList leftPreds = ImmutableList.copyOf((Collection)RelOptUtil.conjunctions((RexNode)this.leftChildPredicates));
            ImmutableList rightPreds = ImmutableList.copyOf((Collection)RelOptUtil.conjunctions((RexNode)this.rightChildPredicates));
            switch (joinType) {
                case INNER: 
                case LEFT: {
                    this.infer((List<RexNode>)leftPreds, allExprsDigests, inferredPredicates, nonFieldsPredicates, includeEqualityInference, joinType == JoinRelType.LEFT ? this.rightFieldsBitSet : this.allFieldsBitSet);
                }
            }
            switch (joinType) {
                case INNER: 
                case RIGHT: {
                    this.infer((List<RexNode>)rightPreds, allExprsDigests, inferredPredicates, nonFieldsPredicates, includeEqualityInference, joinType == JoinRelType.RIGHT ? this.leftFieldsBitSet : this.allFieldsBitSet);
                }
            }
            Mappings.TargetMapping rightMapping = Mappings.createShiftMapping((int)(this.nSysFields + this.nFieldsLeft + this.nFieldsRight), (int[])new int[]{0, this.nSysFields + this.nFieldsLeft, this.nFieldsRight});
            RexPermuteInputsShuttle rightPermute = new RexPermuteInputsShuttle(rightMapping, new RelNode[]{this.joinRel});
            Mappings.TargetMapping leftMapping = Mappings.createShiftMapping((int)(this.nSysFields + this.nFieldsLeft), (int[])new int[]{0, this.nSysFields, this.nFieldsLeft});
            RexPermuteInputsShuttle leftPermute = new RexPermuteInputsShuttle(leftMapping, new RelNode[]{this.joinRel});
            ArrayList<Object> leftInferredPredicates = new ArrayList<Object>();
            ArrayList<Object> rightInferredPredicates = new ArrayList<Object>();
            for (RexNode iP : inferredPredicates) {
                ImmutableBitSet iPBitSet = RelOptUtil.InputFinder.bits((RexNode)iP);
                if (this.leftFieldsBitSet.contains(iPBitSet)) {
                    leftInferredPredicates.add(iP.accept((RexVisitor)leftPermute));
                    continue;
                }
                if (!this.rightFieldsBitSet.contains(iPBitSet)) continue;
                rightInferredPredicates.add(iP.accept((RexVisitor)rightPermute));
            }
            if (joinType == JoinRelType.INNER && !nonFieldsPredicates.isEmpty()) {
                HashSet leftPredsSet = new HashSet(Lists.transform((List)leftPreds, HiveCalciteUtil.REX_STR_FN));
                HashSet rightPredsSet = new HashSet(Lists.transform((List)rightPreds, HiveCalciteUtil.REX_STR_FN));
                for (RexNode iP : nonFieldsPredicates) {
                    if (!leftPredsSet.contains(iP.toString())) {
                        leftInferredPredicates.add(iP);
                    }
                    if (rightPredsSet.contains(iP.toString())) continue;
                    rightInferredPredicates.add(iP);
                }
            }
            switch (joinType) {
                case INNER: {
                    Iterable pulledUpPredicates = this.isSemiJoin ? Iterables.concat((Iterable)leftPreds, leftInferredPredicates) : Iterables.concat((Iterable)leftPreds, (Iterable)rightPreds, (Iterable)RelOptUtil.conjunctions((RexNode)this.joinRel.getCondition()), inferredPredicates);
                    return RelOptPredicateList.of((Iterable)pulledUpPredicates, leftInferredPredicates, rightInferredPredicates);
                }
                case LEFT: {
                    return RelOptPredicateList.of((Iterable)leftPreds, (Iterable)EMPTY_LIST, rightInferredPredicates);
                }
                case RIGHT: {
                    return RelOptPredicateList.of((Iterable)rightPreds, leftInferredPredicates, (Iterable)EMPTY_LIST);
                }
            }
            assert (inferredPredicates.size() == 0);
            return RelOptPredicateList.EMPTY;
        }

        public RexNode left() {
            return this.leftChildPredicates;
        }

        public RexNode right() {
            return this.rightChildPredicates;
        }

        private void infer(List<RexNode> predicates, Set<String> allExprsDigests, List<RexNode> inferedPredicates, List<RexNode> nonFieldsPredicates, boolean includeEqualityInference, ImmutableBitSet inferringFields) {
            for (RexNode r : predicates) {
                if (!includeEqualityInference && this.equalityPredicates.contains(r.toString())) continue;
                Iterable<Mapping> ms = this.mappings(r);
                if (ms.iterator().hasNext()) {
                    for (Mapping m : ms) {
                        RexNode tr = (RexNode)r.accept((RexVisitor)new RexPermuteInputsShuttle((Mappings.TargetMapping)m, new RelNode[]{this.joinRel.getInput(0), this.joinRel.getInput(1)}));
                        if (!inferringFields.contains(RelOptUtil.InputFinder.bits((RexNode)tr)) || allExprsDigests.contains(tr.toString()) || this.isAlwaysTrue(tr)) continue;
                        inferedPredicates.add(tr);
                        allExprsDigests.add(tr.toString());
                    }
                    continue;
                }
                if (this.isAlwaysTrue(r)) continue;
                nonFieldsPredicates.add(r);
            }
        }

        Iterable<Mapping> mappings(final RexNode predicate) {
            return new Iterable<Mapping>(){

                @Override
                public Iterator<Mapping> iterator() {
                    ImmutableBitSet fields = exprFields.get(predicate.toString());
                    if (fields.cardinality() == 0) {
                        return Iterators.emptyIterator();
                    }
                    return new ExprsItr(fields);
                }
            };
        }

        private void equivalent(int p1, int p2) {
            BitSet b = (BitSet)this.equivalence.get(p1);
            b.set(p2);
            b = (BitSet)this.equivalence.get(p2);
            b.set(p1);
        }

        RexNode compose(RexBuilder rexBuilder, Iterable<RexNode> exprs) {
            exprs = Linq4j.asEnumerable(exprs).where((Predicate1)new Predicate1<RexNode>(){

                public boolean apply(RexNode expr) {
                    return expr != null;
                }
            });
            return RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)exprs, (boolean)false);
        }

        private int pos(RexNode expr) {
            if (expr instanceof RexInputRef) {
                return ((RexInputRef)expr).getIndex();
            }
            return -1;
        }

        private boolean isAlwaysTrue(RexNode predicate) {
            RexCall c;
            if (predicate instanceof RexCall && (c = (RexCall)predicate).getOperator().getKind() == SqlKind.EQUALS) {
                int lPos = this.pos((RexNode)c.getOperands().get(0));
                int rPos = this.pos((RexNode)c.getOperands().get(1));
                return lPos != -1 && lPos == rPos;
            }
            return predicate.isAlwaysTrue();
        }

        class ExprsItr
        implements Iterator<Mapping> {
            final int[] columns;
            final BitSet[] columnSets;
            final int[] iterationIdx;
            Mapping nextMapping = null;
            boolean firstCall;

            ExprsItr(ImmutableBitSet fields) {
                this.columns = new int[fields.cardinality()];
                this.columnSets = new BitSet[fields.cardinality()];
                this.iterationIdx = new int[fields.cardinality()];
                int j = 0;
                int i = fields.nextSetBit(0);
                while (i >= 0) {
                    this.columns[j] = i;
                    this.columnSets[j] = (BitSet)JoinConditionBasedPredicateInference.this.equivalence.get(i);
                    this.iterationIdx[j] = 0;
                    i = fields.nextSetBit(i + 1);
                    ++j;
                }
                this.firstCall = true;
            }

            @Override
            public boolean hasNext() {
                if (this.firstCall) {
                    this.initializeMapping();
                    this.firstCall = false;
                } else {
                    this.computeNextMapping(this.iterationIdx.length - 1);
                }
                return this.nextMapping != null;
            }

            @Override
            public Mapping next() {
                return this.nextMapping;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void computeNextMapping(int level) {
                int t = this.columnSets[level].nextSetBit(this.iterationIdx[level]);
                if (t < 0) {
                    if (level == 0) {
                        this.nextMapping = null;
                    } else {
                        int tmp = this.columnSets[level].nextSetBit(0);
                        this.nextMapping.set(this.columns[level], tmp);
                        this.iterationIdx[level] = tmp + 1;
                        this.computeNextMapping(level - 1);
                    }
                } else {
                    this.nextMapping.set(this.columns[level], t);
                    this.iterationIdx[level] = t + 1;
                }
            }

            private void initializeMapping() {
                this.nextMapping = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)(JoinConditionBasedPredicateInference.this.nSysFields + JoinConditionBasedPredicateInference.this.nFieldsLeft + JoinConditionBasedPredicateInference.this.nFieldsRight), (int)(JoinConditionBasedPredicateInference.this.nSysFields + JoinConditionBasedPredicateInference.this.nFieldsLeft + JoinConditionBasedPredicateInference.this.nFieldsRight));
                for (int i = 0; i < this.columnSets.length; ++i) {
                    BitSet c = this.columnSets[i];
                    int t = c.nextSetBit(this.iterationIdx[i]);
                    if (t < 0) {
                        this.nextMapping = null;
                        return;
                    }
                    this.nextMapping.set(this.columns[i], t);
                    this.iterationIdx[i] = t + 1;
                }
            }
        }

        class EquivalenceFinder
        extends RexVisitorImpl<Void> {
            protected EquivalenceFinder() {
                super(true);
            }

            public Void visitCall(RexCall call) {
                if (call.getOperator().getKind() == SqlKind.EQUALS) {
                    int lPos = JoinConditionBasedPredicateInference.this.pos((RexNode)call.getOperands().get(0));
                    int rPos = JoinConditionBasedPredicateInference.this.pos((RexNode)call.getOperands().get(1));
                    if (lPos != -1 && rPos != -1) {
                        JoinConditionBasedPredicateInference.this.equivalent(lPos, rPos);
                        JoinConditionBasedPredicateInference.this.equalityPredicates.add(call.toString());
                    }
                }
                return null;
            }
        }
    }
}

