/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.util.Map;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TTransport;

final class ThriftTransportHelper {
    private static final Log LOG = LogFactory.getLog(ThriftTransportHelper.class);

    private ThriftTransportHelper() {
    }

    static TTransport createTokenTransport(TTransport underlyingTransport, String tokenStrForm, Map<String, String> saslProps) throws IOException {
        Token t = new Token();
        t.decodeFromUrlString(tokenStrForm);
        TSaslClientTransport saslTransport = new TSaslClientTransport(SaslRpcServer.AuthMethod.TOKEN.getMechanismName(), null, null, "default", saslProps, new HadoopThriftAuthBridge.Client.SaslClientCallbackHandler((Token<? extends TokenIdentifier>)t), underlyingTransport);
        LOG.info((Object)String.format("User authentication with method: %s", SaslRpcServer.AuthMethod.TOKEN.getMechanismName()));
        return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
    }

    static TTransport createMapRSaslTransport(TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
        try {
            TSaslClientTransport saslTransport = new TSaslClientTransport(RpcAuthRegistry.getAuthMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.CUSTOM).getMechanismName(), null, null, "default", saslProps, null, underlyingTransport);
            LOG.info((Object)String.format("User authentication with method: %s", RpcAuthRegistry.getAuthMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.CUSTOM).getMechanismName()));
            return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
        }
        catch (SaslException se) {
            throw new IOException("Could not instantiate SASL transport", se);
        }
    }

    static TTransport createKerberosTransport(String principalConfig, String host, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
        String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
        if (names.length != 3) {
            throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
        }
        try {
            TSaslClientTransport saslTransport = new TSaslClientTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), null, names[0], names[1], saslProps, null, underlyingTransport);
            LOG.info((Object)String.format("User authentication with method: %s", SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()));
            return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
        }
        catch (SaslException se) {
            throw new IOException("Could not instantiate SASL transport", se);
        }
    }

    static String format(String authMethod) {
        return authMethod == null ? "" : authMethod.trim().toUpperCase();
    }
}

